/* this file is a part of gau software, (C) Hwang chi-deok 1997-1999       */

#include "config.h"

#include <stdio.h>
#include <unistd.h>
#include <string.h>

#ifdef TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#ifdef HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include <sys/types.h>
#include <signal.h>		// for signal
#include <sys/types.h>

#ifdef HAVE_SYS_WAIT_H
#include <sys/wait.h>
#endif

#include <gtk/gtk.h>

#include "gau.h"
#include "ansiterm.h"


void telnet_done(void);
int telnet(char *host, char *port, int col, int row);
typedef void SimpleFunction(void);


int use_internal_telnet = FALSE;
pid_t telnet_pid = -1;
static int time_tick = 0;
static guint32 connect_time = 0;


int tcp_write(char *buf, int byte)
{
    int n;
    last_out_time = gdk_time_get();
    if (local_echo)
	term->to_term(term, buf, byte);
    n = write(read_fd, buf, byte);
    if (n != byte) {
	g_warning("%s failure: %d , %d", __FUNCTION__, byte, n);
    }
    return byte;
}

int tcp_write_byte(char c)
{
    if (local_echo)
	term->to_term(term, &c, 1);
    write(read_fd, &c, 1);
    return 1;
}


void telnet_hangup(void)
{
    if (read_fd < 0)
	return;
    if (use_internal_telnet) {
	close(read_fd);
	read_fd = -1;
    } else {
	kill(telnet_pid, SIGKILL);
    }
}

int telnet_connected(void)
{
    if (read_fd != -1)
	return TRUE;
    else
	return FALSE;
}

int telnet_check_connected(char *buf, int size)
{
    static char tcp_connect_string[] = "Escape";
    static char *p = tcp_connect_string;
    GList *list;
    int i;
    for (i = 0; i < size; i++) {
	if (buf[i] != *p)
	    p = tcp_connect_string;
	else if (*++p == '\0') {
	    time_t timep;
	    struct tm *lt;
	    remove_input_filter(telnet_check_connected);
	    // connected 
	    gtk_widget_set_sensitive(write_button, TRUE);
	    gtk_label_set_text(GTK_LABEL(GTK_BIN(call_button)->child),
			  "");
	    gau_state = GAU_TELNET;
	    show_message("%s  Ǿϴ.",
		         telnetinfo ? telnetinfo->name : "???");
	    fprintf(log_file, "=====================================================\n");
	    if (telnetinfo) {
		fprintf(log_file, "%s: %s\n", telnetinfo->name,
			telnetinfo->host);
	    } else {
		fprintf(log_file, "ϾȵȰ\n");
	    }
	    timep = time(NULL);
	    lt = localtime(&timep);
	    fprintf(log_file, ":%02d %02d %02d %02d %02d",
		    lt->tm_mon + 1, lt->tm_mday,
		    lt->tm_hour, lt->tm_min, lt->tm_sec);
	    list = connected_function_list;
	    while (list) {
		SimpleFunction *func = list->data;
		(*func) ();
		list = list->next;
	    }
	    gau_set_title(telnetinfo ? telnetinfo->name: "???");
	    gtk_timeout_add(TIME_TICK_INTERVAL, 
	    		    (GtkFunction)telnet_time_report, NULL);
	    connect_time = gdk_time_get();
	    break;
	}
    }
    return 0;
}

void telnet_connect(char *host, char *port, char *script)
{
    //g_print("%s %s %s\n", host, port, script);
    if (read_fd > 0) {
	/* kill the old telnet process */
	kill(telnet_pid, SIGKILL);
	waitpid(telnet_pid, NULL, 0);
	telnet_done();
    }
    gau_state = GAU_TELNET_DIAL;
    show_message("%s  õմϴ", host);
    read_fd = telnet(host, port, term->col, term->row);
    prepare_telnet_script(script);
    if (read_hack) {
	read_input_tag = gdk_input_add(read_fd, GDK_INPUT_READ,
				 fast_input_handler, NULL);
    } else {
	read_input_tag = gdk_input_add(read_fd, GDK_INPUT_READ,
				       input_handler, NULL);
    }
    input_filter_list =
	g_list_prepend(input_filter_list, telnet_check_connected);
    term->from_term = tcp_write;
}



// return value: file descripter of gate for telnet
int telnet(char *host, char *port, int col, int row)
{
    int result;
    pid_t pid;
    int status;
    char *telnet_full_command;
    if (port && port[0] != '0') {
	telnet_full_command = g_strconcat (telnet_command, " ", 
					   host, " ", port, NULL);
    } else {
	telnet_full_command = g_strconcat (telnet_command, " ", 
					   host, NULL);
    }
    result = pty_open(telnet_full_command, &telnet_pid, col, row);
    g_free (telnet_full_command);
    pid = waitpid(telnet_pid, &status, WUNTRACED | WNOHANG);
    if (pid == telnet_pid && pid >= 0) result = -1;
    if (result > 0)
	child_signal_add(telnet_pid, telnet_done);
    return result;
}

void telnet_done(void)
{
    GList *list;
    if (gau_state == GAU_SCRIPT)
	script_cancel();
    gau_state = GAU_NOTHING;
    remove_input_filter(telnet_check_connected);
    telnet_pid = -1;
    close(read_fd);
    read_fd = -1;
    gdk_input_remove(read_input_tag);
    read_input_tag = -1;
    term->from_term = dumb;
    list = disconnected_function_list;
    while (list) {
	SimpleFunction *func = list->data;
	//g_print("disconnected fun: %p\n", list->data);
	(*func) ();
	list = list->next;
    }
    gau_set_title(NULL);
    gtk_label_set_text(GTK_LABEL(GTK_BIN(call_button)->child), "ϱ");
    last_out_time += 800000000L;
}

int dumb(char *buf, int byte)
{
    return FALSE;
}

int 
telnet_time_report(void)
{
    guint32 current_time = gdk_time_get();
    int new_tick;

    new_tick = (current_time - connect_time) / 1000;
    if (new_tick != time_tick) {
	show_time(time_tick);
	time_tick = new_tick;
    }
    if (read_fd > 0) {
	if ((last_out_time + idle_guard_interval) < current_time) {
	    //g_print("idle_guard\n");
	    term->from_term(idle_guard_string, strlen(idle_guard_string));
	}
	if ((last_incoming_time + 500) < current_time) {
	    auto_response_check(term->buf + term->col * linenumber(term->cu_y),
				term->cu_x);
	    last_incoming_time = current_time + 400000;
	}
	return TRUE;
    }
    // connection lost
    fprintf(log_file, "ȭð:%d %d\n", time_tick / 60, time_tick % 60);
    show_message("̹ ð %d %dԴϴ", 
                 time_tick / 60, time_tick % 60);
    time_tick = -1;
    return FALSE;
}

gint
connect_host_by_name(char *host)
{
    GList *list = telnetinfo_list;
    TelnetInfo *ti;
    while (list) {
	ti = list->data;
	if (strcmp(ti->host, host) == 0 || strcmp(ti->name, host) == 0) {
	    break;
	}
	list = list->next;
    }
    if (list) {
	telnet_connect(ti->host, ti->port, ti->script_file);
	telnetinfo = ti;
    } else {
	telnetinfo = NULL;
	telnet_connect(host, NULL, NULL);
    }
    return FALSE;
}

void
telnet_win_show(void)
{
    GtkWidget *win;
    GtkWidget *vbox, *hbox, *label, *entry;

    win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
    vbox = gtk_vbox_new (FALSE, 2);
    hbox = gtk_hbox_new (FALSE, 2);
    label = gtk_label_new ("");
    entry = gtk_entry_new ();
    //gtk_box_pack_start (GTK_BOX(hbox), label, TR);
    //gtk_box_pack_end (GTK_BOX(hbox), entry);
}

#if 0
static void
telnet_win_go_cb()
{
}


static void
telnet_win_cancel_cb()
{
}
#endif
