/* this file is a part of gau software, (C) Hwang chi-deok 1997, 1998, 1999 */

#include "config.h"

#include <string.h>
#include <ctype.h>
#include <sys/stat.h> /* stat */
#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkprivate.h>

#include "gau.h"

static void
call_gau_install(void)
{
    fprintf (stderr, " gau-install Űʽÿ\n");
    fprintf (stderr, "gau-install ࿡ ʿ   ϵ\n");
    fprintf (stderr, "Ȩ 丮 Ʒ .gau 丮Ʒ ٰԴϴ.\n");
    fprintf (stderr, "  оð  Ȳ µ ϵ\n");
    fprintf (stderr, "ġ  ٽ 츦 Űñ ٶϴ.\n");
    exit(1);
}

void
check_personal_rc (void)
{
    /* check ~/.gau directory */
    char *home;
    char *gau_dir, *gaurc;
    struct stat stats;
    home = g_get_home_dir();
    gau_dir = g_strconcat (home, "/.gau", NULL);
    stat (gau_dir, &stats);
    if (!S_ISDIR(stats.st_mode)) call_gau_install();
    gaurc = g_strconcat (gau_dir, "/gaurc", NULL);
    stat (gaurc, &stats);
    if (!S_ISREG(stats.st_mode)) call_gau_install();
    g_free (gau_dir);
    g_free (gaurc);
}

void
remove_input_filter (gpointer filter)
{
    input_filter_list =
	g_list_remove (input_filter_list, filter);
}

void
register_input_filter (gpointer filter)
{
    input_filter_list =
    	g_list_prepend (input_filter_list, filter);
}

void
gau_set_title (char *title)
{
    char buf[256];
    if (title) {
	strcpy (buf, ": ");
	strncpy (buf + 6, title, 256 - 7);
    } else {
	strcpy (buf, "");
    }
    gtk_window_set_title (GTK_WINDOW (main_win), buf);
}

void
destroy_top_level (GtkWidget *widget)
{
    gtk_widget_destroy (gtk_widget_get_toplevel (widget));
}

guchar *
eat_space(guchar *buf)
{
	while(isspace(*buf)) buf++;
	return buf;
}

char *
replace_ctl_char (char *buf)
{
    GString *des;
    char *str;
    int i;

    i = 0;
    des = g_string_new (NULL);
    while (buf[i] && buf[i] != '"') {
	if ((buf[i] == '\\') && buf[i + 1]) {
	    i++;
	    if (buf[i] == 'n') {
		g_string_append_c (des, '\n');
	    } else if (buf[i] == 'r') {
		g_string_append_c (des, '\r');
	    } else if (buf[i] == 't') {
		g_string_append_c (des, '\t');
	    } else if (buf[i] == 'b') {
		g_string_append_c (des, '\b');
	    } else
		g_string_append_c (des, buf[i]);
	} else if ((buf[i] == '^') && buf[i+1]) {
	    i++;
	    g_string_append_c (des, buf[i] + '\b' - 'H');
	} else {
	    g_string_append_c (des, buf[i]);
	}
	i++;
    }
    str = des->str;
    g_string_free (des, FALSE);
    return str;
}

static int get_string_ok;

static void
get_string_ok_cb(GtkWidget *w)
{
    get_string_ok = TRUE;
    gtk_main_quit();
}

char *
get_string_from_user(char *label_text)
{
    GtkWidget *win;
    GtkWidget *vbox, *label, *entry, *sep, *hbox, *ok_button, *cancel_button;

    get_string_ok = FALSE;
    win = gtk_window_new (GTK_WINDOW_DIALOG);
    gtk_window_set_position (GTK_WINDOW (win), GTK_WIN_POS_MOUSE);
    gtk_window_set_title (GTK_WINDOW (win), label_text);
    gtk_container_set_border_width (GTK_CONTAINER (win), 5);
    /* ignore delete_event */
    gtk_signal_connect (GTK_OBJECT (win), "delete_event",
    			GTK_SIGNAL_FUNC(gtk_true), NULL);

    vbox = gtk_vbox_new (FALSE, 5);
    gtk_container_add (GTK_CONTAINER (win), vbox);

    label = gtk_label_new (label_text);
    gtk_container_add (GTK_CONTAINER (vbox), label);

    entry = gtk_entry_new ();
    gtk_container_add (GTK_CONTAINER (vbox), entry);

    sep = gtk_hseparator_new ();
    gtk_container_add (GTK_CONTAINER (vbox), sep);

    hbox = gtk_hbox_new (TRUE, 5);
    gtk_container_add (GTK_CONTAINER (vbox), hbox);

    ok_button = gtk_button_new_with_label ("Ȯ");
    gtk_container_add (GTK_CONTAINER (hbox), ok_button);
    gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
    			GTK_SIGNAL_FUNC(get_string_ok_cb), NULL);

    cancel_button = gtk_button_new_with_label ("");
    gtk_container_add (GTK_CONTAINER (hbox), cancel_button);
    gtk_signal_connect (GTK_OBJECT (cancel_button), "clicked",
    		        GTK_SIGNAL_FUNC (gtk_main_quit), NULL);

    gtk_widget_show_all (win);
    gtk_grab_add (win);

    gtk_main();
    gtk_grab_remove (win);

    if (get_string_ok) {
	char *s;
	s = gtk_entry_get_text (GTK_ENTRY (entry));
	gtk_widget_destroy (win);
	if (s && *s)
	    return g_strdup (s);
	return NULL;
    }
    gtk_widget_destroy (win);
    return NULL;
}
