/*
 * nhpf.c - Hangul Print filter for Netscape (2.0 or later) PS save file, v1.42.
 * Lee yongjae, setup@shiva.snu.ac.kr, 1997.1.22.
 */
/*
 * Copyright (c) 1996 by Lee yongjae, Narae in dept. of Computer Science
 * in Seoul National University, Korea.
 *
 * Narae is the name for Computer Science Society in dept. of
 * Computer Science in Seoul National University.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, 
 * provided that the above copyright notice appear in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the copyright holder
 * not be used in advertising or publicity pertaining to distribution
 * of the software without specific, written prior permission.
 *
 * This software is provided "as is" without express or implied warranty.
 */
/*
 * This program make you can print hangul homepages with Netscape 2.0 or later,
 * in Unix with PostScript printer (or with Ghostscript).
 *
 * The filtered PS file is self-contained, because this program appends
 * a hangul font to the file. This means that you can print the file
 * with ANY(!) PostScript printer.
 *
 * Usage with Save menu:
 * 
 *   This usage preserves hangul text styles (normal, italic, bold, bold italic)
 *   but you should save-and filter by hand.
 * 
 *   1. Save the Hangul homepage with "Save..." menu as "PostScript".
 *      (Do not save with "Print..." menu. "Print..." destroys texts.)
 * 
 *   2. Filter the PS file through "nhpf", with redirection, such that:
 * 
 *        nhpf < original-ps-file > filtered-ps-file
 * 
 *   3. Print the filtered PS file with PostScript printer.
 * 
 * Usage with Print menu:
 * 
 *   This usage destroys all hangul text styles to normal
 *   but you can print with Print manu at once.
 * 
 *   1. Edit netscape's app-defaults file
 *      (/usr/X11/lib/X11/app-defaults/Netscape in some systems).
 *      such that:
 * 
 *         *documentFonts.euc-kr*psname:          SMgoJ
 *         *documentFonts.euc-kr*pscode:          euc-kr
 *         *documentFonts.euc-kr*pswidth:         1000
 *      to
 *         !*documentFonts.euc-kr*psname:          SMgoJ
 *         !*documentFonts.euc-kr*pscode:          euc-kr
 *         !*documentFonts.euc-kr*pswidth:         1000
 * 
 *      i.e. hide the font setting for documentFonts.euc-kr.
 * 
 *   2. Print with the command in Print dialog box of Netscape:
 * 
 *         nhpf | lp
 *      or
 *         nhpf | lpr
 * 
 */

#include <stdio.h>
#include "ncode.h"

#define BUF_SIZE 20000
unsigned char buf[BUF_SIZE];

void replace_font_defs();
void print_font_defs();
void change_encoding();

void
main()
{
  replace_font_defs();
  change_encoding();
}

void
change_encoding()
{
  unsigned char *p1, *p2;
  unsigned short k;
  int c, b0, b1, x0, x1;
  
  while((c = getchar()) != EOF) {
    putchar(c);
    if (c == '(') {
      while ((c = getchar()) != EOF) {
	if (c == '\\') {
	  if (scanf("%3o", &b0) == 1) {
	    if (scanf("\\%3o", &b1) == 1) {
	      k = b0 * 256 +b1;
	      p1 = buf;
	      p2 = comb_to_n(ks_to_comb(k), buf);
	      while(p1 < p2)
		printf("\\%o", (unsigned)*p1++);
	    }
	    else
	      printf("\\%o",b0);
	  }
	  else {
	    putchar(c);
	    putchar(getchar());
	  }
	}
	else if (c == ')')
	  break;
	else
	  putchar(c);
      } 
    }
    else if (c == '<') {
      while (scanf("%2x", &b0) == 1) {
	if (b0 & 0xf0) {
	  if (scanf("%2x", &b1) == 1) {
	    k = b0 * 256 +b1;
	    p1 = buf;
	    p2 = comb_to_n(ks_to_comb(k), buf);
	    while(p1 < p2)
	      printf("%2x", (unsigned)*p1++); 
	  }
	  else
	    printf("%2x", b0);
	}
	else
	  printf("%2x", b0);
      }
      c = getchar();  /* must be '>' */
    }
    else
      continue;  /* normal character - skip "show" replace */

    putchar(c);  /* print ending delimeter */
    if (fgets(buf, BUF_SIZE, stdin))  /* replace "show" with "nshow" */
      if (!strncmp(buf, " show", 5))
	fputs(" nshow\n", stdout);
      else
	fputs(buf, stdout);
  }
}

void
replace_font_defs()
{
  while(fgets(buf, BUF_SIZE, stdin))
    if (buf[0] == '[')
      break;
    else
      fputs(buf, stdout);
  
  while(fgets(buf, BUF_SIZE, stdin))
    if (!strncmp(buf, "/c", 2))
      break;

#include "n3f-5.str"
#include "n3f-5b.str"
#include "fontdef.str"

  fputs(buf, stdout);
  fgets(buf, BUF_SIZE, stdin);
  fputs(buf, stdout);

  while(fgets(buf, BUF_SIZE, stdin))
    if (!strncmp(buf, "/rhc", 4))
      break;

  fputs(buf, stdout);
}
