/*
 * delinterp.c -- delete an interpreter from the interpreter registry.
 *
 * Sometimes a Tk app will exit without doing a destroy . and leaving
 * its interpreter still registered on the root window.  This program
 * was cut out of tkSend.c, it forcibly deletes the named interpreter
 * from the root window.  It does not check if the named interpreter
 * actually exists.  If you delete an interpreter from the registry,
 * you can no longer send commands to it.  However, I believe the
 * interpreter can still send commands to others.
 *
 * If the delete succeeds delinterp prints "interpreter deleted".
 * If the delete fails it will print some other self-explanatory
 * message.
 *
 * Author: Sam Shen (sls@aero.org)
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>

#define MAX_PROP_WORDS 100000

int main(argc, argv)
     int argc;
     char* argv[];
{
    Atom interpRegistry;
    Display* dpy;
    Atom actualType;
    int result, actualFormat, i, count;
    unsigned long numItems, bytesAfter;
    unsigned long winId;
    char* interpName;
    char* regProp;
    char* entry;
    char* p;

    if (argc != 2) {
	fprintf(stderr, "usage: %s interpName\n", argv[0]);
	exit(1);
    }
    interpName = argv[1];
    regProp = NULL;
    dpy = XOpenDisplay(NULL);
    interpRegistry = XInternAtom(dpy, "InterpRegistry", True);
    if (interpRegistry == None) {
	printf("no registered interpreters\n");
	goto done;
    }
    result = XGetWindowProperty(dpy, RootWindow(dpy, 0),
				interpRegistry, 0, MAX_PROP_WORDS,
				False, XA_STRING,
				&actualType, &actualFormat, &numItems,
				&bytesAfter, (unsigned char **) &regProp);
    if ((result != Success) ||(actualFormat != 8)
	|| (actualType != XA_STRING)) {
	printf("bad or missing InterpRegistry property.\n");
	goto done;
    }
    for (i = 0, p = regProp; (p - regProp) < numItems; i++) {
	entry = p;
	while (*p && *p != ' ')
	    p++;
	if (!strcmp(interpName, p+1))
	    break;
	while (*p)
	    p++;
	p++;
    }
    if ((p - regProp) >= numItems) {
	printf("interpreter not found\n");
	goto done;
    }
    while (*p != 0)
	p++;
    p++;
    count = numItems - (p-regProp);
    if (count > 0)
	memcpy((void *) entry, (void *) p, count);
    XChangeProperty(dpy, RootWindow(dpy, 0),
		    interpRegistry, XA_STRING, 8,
		    PropModeReplace, (unsigned char *) regProp,
		    (int) (numItems - (p-entry)));
    XSync(dpy, False);
    printf("interpreter deleted\n");
 done:
    if (regProp != NULL)
	XFree(regProp);
    XCloseDisplay(dpy);
    exit(0);
}
