/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/text/RCS/FontFamilyP.h,v 3.3 91/01/03 20:11:58 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifdef _AtDevelopment_
#include "FontFamily.h"
#else
#include <At/FontFamily.h>
#endif

/* font families */
#define AtFontCOURIER 0
#define AtFontHELVETICA 1
#define AtFontTIMES 2    
#define AtFontSCHOOLBOOK 3
#define AtFontSYMBOL 4

typedef short PostscriptMetrics[256];

typedef struct {
    char *xname;
    char *psnames[4];
    int flags;
    char slantchar;
    PostscriptMetrics *psmetrics;
    short psascents[4];
    short psdescents[4];
} AtFontFamilyInfo;

extern AtFontFamilyInfo _AtFontFamilies[];

#define XNAME(ff) (_AtFontFamilies[(ff)->num].xname)
#define PSNAME(ff,style) (_AtFontFamilies[(ff)->num].psnames[style])
#define FLAGS(ff) (_AtFontFamilies[(ff)->num].flags)
#define SLANTCHAR(ff) (_AtFontFamilies[(ff)->num].slantchar)
#define PSMETRICS(ff) (_AtFontFamilies[(ff)->num].psmetrics)
#define INFO(ff) (&_AtFontFamilies[(ff)->num])

#ifndef AFMPATH
#define AFMPATH "/usr/athena/lib/ps"
#endif
