/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/text/RCS/FontFamilyPS.c,v 3.3 91/01/03 20:12:00 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#include <stdio.h>

#ifdef _AtDevelopment_
#include "FontFamilyP.h"
#else
#include <At/FontFamilyP.h>
#endif

static void ReadPSMetrics(AtFontFamilyInfo *ffi, int face)
{
    char buf[300];
    FILE *f;
    char *status;
    int code, width;

    sprintf(buf,"%s/%s.afm", AFMPATH, ffi->psnames[face]); 
    f = fopen(buf, "r");
    if (f == NULL) {
	perror("Can't read Postscript font metrics");
	exit(-1);
    }

    do {  /* skip preliminary lines */
	status = fgets(buf, 300, f);
	if (status == NULL) break;
	if (strncmp(buf, "Ascender", 8) == 0)
	    sscanf(buf, "Ascender %hd", &ffi->psascents[face]);
	if (strncmp(buf, "Descender", 9) == 0)
	    sscanf(buf, "Descender %hd", &ffi->psdescents[face]);
    } while (strncmp(buf, "StartCharMetrics", 16));

    while (fgets(buf, 300, f)) {  /* read all the char metrics */
	if (strncmp(buf, "EndCharMetrics", 14) == 0) break;
	sscanf(buf, "C %d ; WX %d ;", &code, &width);
	ffi->psmetrics[face][code] = (short)width;
    }
}

static void GetPSMetrics(AtFontFamily *ff)
{
    extern char *calloc();
    AtFontFamilyInfo *info;

    info = INFO(ff);
    
    if (info->psmetrics != NULL) return;

    info->psmetrics = (PostscriptMetrics *)calloc(4,sizeof(PostscriptMetrics));

    ReadPSMetrics(info, AtFontPLAIN);
    ReadPSMetrics(info, AtFontBOLD);
    ReadPSMetrics(info, AtFontITALIC);
    ReadPSMetrics(info, AtFontBOLDITALIC);
}


int AtFontPSTextWidth(AtFontFamily *ff, int face, int size, char *str, int len)
{
    AtFontFamilyInfo *info;
    int width = 0;
    int i;

    info = INFO(ff);
    if (info->psmetrics == NULL) GetPSMetrics(ff);

    for (i= 0; i < len; i++)
	width += info->psmetrics[face][*str++];

    return (width * AtFontPointSize(ff,size))/1000;
}
    
int AtFontPSAscent(AtFontFamily *ff, int face, int size)
{
    AtFontFamilyInfo *info;
    info = INFO(ff);
    if (info->psmetrics == NULL) GetPSMetrics(ff);

    return (info->psascents[face] * AtFontPointSize(ff, size))/1000;
}

int AtFontPSDescent(AtFontFamily *ff, int face, int size)
{
    AtFontFamilyInfo *info;
    info = INFO(ff);
    if (info->psmetrics == NULL) GetPSMetrics(ff);

    return (-info->psdescents[face] * AtFontPointSize(ff, size))/1000;
}

    
char *AtFontPSName(AtFontFamily *ff, int face)
{
    return (INFO(ff)->psnames[face]);
}
