/* $Date: 92/02/16 08:42:02 $    $Revision: 1.2 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/************************************************************************
CmFigureClass.cc 
 Contact: joe, maschaub
****************************************************************/
#include <CmFigureClass.h>
#include <X11/Intrinsic.h>

/*******************************
 CmFigureClass Constructor
  Called by CmFigureRegistrar
  Initializes local variables, inserts the icon for the figure in the palette
  Adds a callback to the icon that creates CmCreateFigure
 *******************************/
CmFigureClass::CmFigureClass(const CmString& cn) {
  class_name = cn;
  widget_class = NULL;
  super_cm_class = NULL;
  UpdateCallbackProc = NULL;
}

/*******************************
 CmFigureClass Destructor
 *******************************/
CmFigureClass::~CmFigureClass() {
  for (resource_list.MoveFirst(); resource_list.HasCurrent(); 
       resource_list.MoveNext()) {
    CmResource *resource = (CmResource *) resource_list.GetCurrent();
    for (resource->OptionList.MoveFirst(); 
	 resource->OptionList.HasCurrent(); 
	 resource->OptionList.MoveNext())
      delete (CmString *) resource->OptionList.GetCurrent();
    resource->OptionList.Clear();
    delete resource;
  }
  resource_list.Clear();

  for (callback_list.MoveFirst(); callback_list.HasCurrent(); 
       callback_list.MoveNext())
    delete (CmCallback *) callback_list.GetCurrent();
  callback_list.Clear();
}

static CmString empty = "";

const CmString &CmFigureClass::Default(const CmString & name) { 
  for (resource_list.MoveFirst(); 
       resource_list.HasCurrent(); 
       resource_list.MoveNext())
    if (((CmResource*)resource_list.GetCurrent())->ResourceString == name)
      return ((CmResource*)resource_list.GetCurrent())->DefaultValue;
  
  if (SuperCmClass())
    return SuperCmClass()->Default(name);
  else
    return empty;
}

int CmFigureClass::EditMode(const int i) { 
  return(((CmResource *) resource_list[i])->EditMode);
}

Boolean CmFigureClass::IsCommon(const int i) { 
  return(((CmResource *) resource_list[i])->IsCommon);
}

int CmFigureClass::NumOptions(const int i ) { 
  return(((CmResource *) resource_list[i])->OptionList.ListSize());
}

const CmString &CmFigureClass::Option(const int i, const int j) {
  CmString *opt = (CmString *) 
    (((CmResource *) resource_list[i])->OptionList[j]);
  return(*opt);
}


/*******************************
 CmFigureClass - AddResource
  Copies keyword info into local variables
 *******************************/
void CmFigureClass::AddResource(const CmString & resrc, 
				const CmString & dbtxt, 
				const CmString & dft, const int em, 
				const Boolean comm) {
  CmResource * resource = new CmResource;
  resource_list.Append(resource );
  resource->ResourceString = resrc;
  resource->DialogText = dbtxt;
  resource->DefaultValue = dft;
  resource->EditMode = em;
  resource->IsCommon = comm;
}

/*******************************
 CmFigureClass - AddOptionToResource
  Copies keyword info into local variables
 *******************************/
void CmFigureClass::AddOptionToResource(const CmString & resrc, 
					const CmString & opt) {
  for (resource_list.MoveFirst(); resource_list.HasCurrent();
       resource_list.MoveNext()){
    CmResource *resource = 
      (CmResource *) resource_list.GetCurrent();
    if ( resource->ResourceString == resrc ) {
      CmString *new_string = new CmString(opt);
      resource->OptionList.Append( new_string );
    }
  }
}

/*******************************
 CmFigureClass - AddCallback
  Copies adds a callback and its name to the list of possible callbacks
 *******************************/
void CmFigureClass::AddCallback(const CmString & callbck, 
				const CmString & name ) {
  CmCallback *callback = new CmCallback;
  callback_list.Append(callback);
  callback->CallbackName = name;
  callback->Callback = callbck;
}

/*******************************
 CmFigureClass - CallbackName
 returns the callback name of callback # i
 *******************************/
const CmString &CmFigureClass::CallbackName(const int i) {
  return(((CmCallback *)callback_list[i])->CallbackName);
}

/*******************************
 CmFigureClass - Callback
 returns the callback of callback # i
 *******************************/
const CmString & CmFigureClass::Callback(const int i) {
  return(((CmCallback *)callback_list[i])->Callback);
}
