/* $Date: 92/02/16 08:45:29 $    $Revision: 1.2 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
#ifndef CMLIST_H
#define CMLIST_H

#include <stddef.h>  // For NULL

struct CmLink {
    void* data;
    CmLink* prev;
    CmLink* next;
  };

class CmList {
  CmLink* first;
  CmLink* current;
  CmLink* last;
  int num_elements;

  int check_for_empty_list() const;
  CmLink* GetLink(int);
  CmLink* cache_link;
  int cache_index;
public:
  CmList();
  ~CmList();

  // note ++ -- += -= should be added later to be like prev linked list

  void* Append(void *);
  void InsertBefore(void *);
  void* Insert(void *, const int);
  void* Replace(void *, const int);
  void Remove(const int);
  void* operator[](const int index)
    {return check_for_empty_list() ? GetLink(index)->data : NULL;};


  int ListSize() const {return num_elements;};
  void Clear();

  void MoveFirst() {
    current = first;
  }
  void MoveLast() {
    current = last;
  }
  void* GetCurrent() {
    return (current ? current->data : NULL);
  }

  int HasCurrent() {
    return (current != NULL);
  }

  int HasNext() {
    return (current && current->next);
  }

  int HasPrev() {
    return (current && current->prev);
  }

  void MoveNext() {
    if (current)
      current = current->next;
  }

  void MovePrev() {
    if (current) 
      current = current->prev;
  }
};

#endif
