/* $Date: 92/02/15 05:14:10 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/*********************************************
 CmNavigator.h - Page definition
 Contact: joe, maschaub
 *********************************************/
#ifndef _CMNAVIGATOR_H
#define _CMNAVIGATOR_H
#include <CDS.h>

class CmCDS;
class CmDialog;
class CmPage;
class CmNavigatorOutliner;
class CmNavigatorParser;
class CmNavigatorHeap;

class CmNavigator {
 private:
  CmNavigatorHeap *heap;
  CmNavigatorOutliner *outliner;
  CmNavigatorParser *parser;
  Widget prev,  any, scroll, next, file_box;

 public: 
  /* Constructor and Destructor */
  CmNavigator(CmCDS* const, const Widget);
  ~CmNavigator();
  CmCDS *cds;

  /* file management */
  CmBool FileAltered;
  void NewFile(const CmString &);
  void OpenFile(const CmString &);
  void SaveFile(const CmString &);
  void ExitCDS();

  CmString CurrentFilename;

  // page management
  void AppendNewPage(const CmString &, const CmString &, Boolean);
  void AppendPage(CmPage * const);
  void RemovePage(CmPage * const);
  void DestroyPage(CmPage * const);
  void Navigate(const CmString &string) {
    Navigate(string, "");
  }
  void Navigate(const CmString &, const CmString&);
  void Navigate(const CmString &, const int);
  void ToggleNameAndTitles();
  CmPage *GetCurrentPage(); 
  CmPage *GetPageByName(const CmString &);

  void ChangeNameAndTitle(const CmString &, const CmString &);
  void ChangeTitle(const CmString &);

  Widget GetDialogParent();
  void SetListOfHeap(CmDialog *, const CmString &, const CmString &);
};
#endif


