/* $Date: 92/02/16 08:45:52 $    $Revision: 1.2 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/*********************************************************
 CmNavigator.cc - Navigator Code
 Contact: joe, maschaub
 *********************************************************/

#include <CmNavigatorHeap.h>
#include <CmPage.h>
#include <CmDialog.h>

/*************************************
 CmNavigatorHeap constructor
**************************************/
CmNavigatorHeap::CmNavigatorHeap() {
}

/*************************************
 CmNavigator destructor
**************************************/
CmNavigatorHeap::~CmNavigatorHeap() {
  ClearAllPages();
}


/*************************************
 CmNavigator AppendNewPage
  Adds a child to the current page and sets the current page to that new child
**************************************/
void CmNavigatorHeap::AppendPageToHeap(CmPage* new_page) {
  page_heap.Append(new_page);
}

/******************************************
 CmNavigator DestroyPage
 called when the destroy page button is pressed
 destoys the current page
 *****************************************/
void CmNavigatorHeap::DestroyPageInHeap(CmPage *new_page) {
  for (int i =0; i < page_heap.ListSize(); i++)
    if (page_heap[i] == new_page)
      page_heap.Remove(i);
  delete new_page;
}

/*************************************
 CmNavigatorHeap ClearAllPages
 Clears the page list
**************************************/
void CmNavigatorHeap::ClearAllPages() {
  for (page_heap.MoveFirst(); page_heap.HasCurrent(); page_heap.MoveNext())
    delete (CmPage *) page_heap.GetCurrent();
  page_heap.Clear();
}

/*************************************
CmNavigator GetPageByName
returns the page given the title
returns NULL if page not found
**************************************/
CmPage *CmNavigatorHeap::GetPageByName(const CmString & name) {
  for (page_heap.MoveFirst(); page_heap.HasCurrent(); page_heap.MoveNext()) 
    if ( ((CmPage *) page_heap.GetCurrent())->Name == name )
      return((CmPage *) page_heap.GetCurrent());
  return(NULL);
}


/****************************************************************************
CmNavigator MakePageName
returns CmString of a unique page name
****************************************************************************/
CmString CmNavigatorHeap::MakePageName() {
  int counter = 0;
  CmString untitled_name;

  do {
    untitled_name = form("untitled%d", counter);
    counter++;
  }
  while (GetPageByName(untitled_name));
  return untitled_name;
}

void CmNavigatorHeap::SetListOfHeap(CmDialog *dialog, 
				    const CmString &pane_name, 
				    const CmString &dialog_text) {
  for (page_heap.MoveFirst(); page_heap.HasCurrent();
       page_heap.MoveNext())
    dialog->AddOption(pane_name, dialog_text, 
		      CMDIALOG_OPTION,
		   (XtArgVal) ((CmPage *) page_heap.GetCurrent())->Name.Chars());

  page_heap.MoveFirst();
  if (page_heap.HasCurrent())
    dialog->AddOption(pane_name, dialog_text, CMDIALOG_VALUE,
		      (XtArgVal) ((CmPage *) page_heap.GetCurrent())->Name.Chars());
  
}
  
/*************************************
 CmNavigator ostream
**************************************/
ostream& operator << (ostream &stream, CmNavigatorHeap *heap) {
  for(heap->page_heap.MoveFirst(); 
      heap->page_heap.HasCurrent(); 
      heap->page_heap.MoveNext())
    stream << (CmPage *) heap->page_heap.GetCurrent();

  return(stream);
}

