/**/# This is an Imake configuration file for use with cds

/**/# This is the name of the C++ compiler you are using.  Currently
/**/# CDS only works with g++

CC = acc
CXX = CC -DSYSV -DUSE_LIBGXX_INLINES
/*CXX=g++ -DSYSV*/

/**/# These are the C++ flags to use

CXXFLAGS= -Wall -g -pipe
/*CXXFLAGS= -Wall -g -O -pipe */

/**/# Name of Make

MAKE = make

/**/# CDS Version

CDS_VERSION = \"2.00.00\"

CXXINCLUDES = /* -I/usr/tmp/joe/cds/gnu/g++-include */

STD_INCLUDES = -I/usr/tmp/joe/cds/motif 
STD_DEFINES = -DXTFUNCPROTO

EXTRA_LOAD_FLAGS = -L/usr/tmp/joe/cds/motif -L/usr/tmp/joe/cds/gnu -L/local/X11R4/lib

BUILTIN_LIB = /* /usr/tmp/joe/cds/gnu/gnulib */

#define BuildAt
#define BuildCm
#define BuildExpect
#define BuildRegex

/**/# The lines below probably don't need to be changed

.SUFFIXES: .o .cc .c .yacc .lex

.yacc.o:
	$(RM) yy.tmp lex.tmp yy.lex.cc
	yacc $*.yacc
	lex $*.lex
	cat y.tab.c | \
	sed -e "s/extern char \*malloc()\, \*realloc();//g" \
	    -e "s/yyparse() {/int "$*"::yyparse() {/g" \
	    -e 's/yyparse()$$/'$*"::yyparse()/g" \
	    -e "s/# define YYLMAX 200/# define YYLMAX 20000/g"\
	    -e "s/char yytext\[YYLMAX\];//g"\
	    -e "s/extern short yyerrflag;//g" \
	    -e "s/extern int yychar;//g" \
	    -e "s/extern int yyprevious;/static int yyprevious/g" \
	    -e "s/short yyexca/static short yyexca/g" \
	    -e "s/short yyact/static const short yyact/g" \
	    -e "s/short yypact/static const short yypact/g" \
	    -e "s/short yypgo/static const short yypgo/g" \
	    -e "s/short yyr1/static const short yyr1/g" \
	    -e "s/short yyr2/static const short yyr2/g" \
	    -e "s/short yychk/static const short yychk/g" \
	    -e "s/short yydef/static const short yydef/g" \
	    -e "s/int yyexca/static int yyexca/g" \
	    -e "s/int yyact/static const int yyact/g" \
	    -e "s/int yypact/static const int yypact/g" \
	    -e "s/int yypgo/static const int yypgo/g" \
	    -e "s/int yyr1/static const int yyr1/g" \
	    -e "s/int yyr2/static const int yyr2/g" \
	    -e "s/int yychk/static const int yychk/g" \
	    -e "s/int yydef/static const int yydef/g" \
            -e "s/YYSTYPE yylval, yyval;/static YYSTYPE yylval, yyval;/g" \
	    -e "s/struct yysvf \*yyestate/static struct yysvf \*yyestate/g" \
	    -e "s/extern int yychar;//g" \
	    -e "s/extern int yyerrflag;//g" \
	    -e "s/int yychar.*;//g" \
	    -e "s/int yynerrs.*;//g" \
	    -e "s/int yyerrflag.*;//g" \
	    -e "s/int yydebug.*;//g" \
	    -e "s/free(yys)/free((char \*)yys)/g" \
	    -e "s/free(yyv)/free((char \*)yyv)/g" \
	    -e "s/short yyerrflag = 0;//g" > yy.tmp

	cat lex.yy.c | \
	sed -e "s/yylex(){/int "$*"::yylex() {/g"\
	    -e "s/# define YYLMAX 200/# define YYLMAX 20000/g"\
	    -e "s/char yytext\[YYLMAX\];//g"\
	    -e "s/int yyvstop\[\]/static int yyvstop\[\]/g" \
	    -e "s/yysvec/"$*"yysvec/g" \
	    -e "s/yybgin/"$*"yybgin/g" \
	    -e "s/struct yywork \*yytop =/static struct yywork \*yytop =/g" \
            -e "s/int yylineno =1;//g" \
	    -e "s/int yytchar;//g" \
	    -e "s/int yyleng;//g" \
	    -e "s/int yymorfg;//g" \
	    -e "s/char yysbuf\[YYLMAX\];//g" \
	    -e "s/char \*yysptr = yysbuf;//g" \
	    -e "s/extern char \*yysptr, yysbuf\[\];//g"\
	    -e "s/extern int yyprevious;/static int yyprevious;/g" \
	    -e "s/int yyprevious =/static int yyprevious =/g" \
	    -e "s/extern char yytext\[\]//g" \
 	    -e "s/yylook(){/int "$*"::yylook(){/g" \
	    -e "s/struct yywork {/static struct yywork {/g" \
	    -e "s/char yymatch/static char yymatch/g" \
	    -e "s/char yyextra/static char yyextra/g" \
	    -e "s/int \*yyfnd/static int \*yyfnd/g" \
	    -e "s/extern struct yysvf \*yyestate;//g" \
	    -e "s/struct yysvf \*yyestate/static struct yysvf \*yyestate/g" \
            -e "s/struct yysvf \*yylstate/static struct yysvf \*yylstate/g" \
	    -e "/yyback(p\, m)/,/unput(c);\n}/ d" > lex.tmp

	cat yy.tmp lex.tmp | \
	sed -e "s/FILE \*yyin = *{stdin}, \*yyout = *{stdout};//g" \
            -e "s/extern int yylineno;//g" \
		> yy.lex.cc
	$(RM) y.tab.c lex.yy.c yy.tmp lex.tmp
	$(CXX) -c $(CFLAGS) $(CXXFLAGS) $(CXXINCLUDES) yy.lex.cc -o $*.o
	$(RM) yy.lex.cc

#ifndef NormalCPlusPlusObjectRule
#define NormalCPlusPlusObjectRule()					@@\
.cc.o:									@@\
	$(RM) $@							@@\
	${CXX} -c ${CFLAGS} ${CXXFLAGS} $(CXXINCLUDES) $*.cc
#endif /* NormalCPlusPlusObjectRule */

#ifndef ProfiledCPlusPlusObjectRule
#define ProfiledCPlusPlusObjectRule()					@@\
.cc.o:									@@\
	$(RM) $@ profiled/$@						@@\
	$(CXX) -pg -c $(CFLAGS) $(CXXFLAGS) $*.cc			@@\
	$(MV) $*.o profiled/$*.o					@@\
	$(CXX) -c $(CFLAGS) $(CXXFLAGS) $*.cc
#endif

#ifndef DebuggedCPlusPlusObjectRule
#define DebuggedCPlusPlusObjectRule()					@@\
.cc.o:									@@\
	$(RM) $@ debugger/$@						@@\
	$(CXX) -pg -c $(CFLAGS) $(CXXFLAGS) $*.cc			@@\
	$(MV) $*.o debugger/$*.o					@@\
	$(CXX) -c $(CFLAGS) $(CXXFLAGS) $*.cc
#endif



/*
 * ComplexProgramTarget - generate rules for compiling and linking the 
 * program specified by $(OBJS) and $(SRCS), installing the program and its
 * man page, and generating dependencies.  It should only be used in 
 * Imakefiles that describe a single program.
 */
#ifndef ComplexCPlusPlusTarget
#define	ComplexCPlusPlusTarget(program)					@@\
        PROGRAM = program						@@\
									@@\
AllTarget(program)							@@\
									@@\
program: $(OBJS) $(DEPLIBS)						@@\
	RemoveTargetProgram($@)						@@\
	$(CXX) -o $@ $(OBJS) $(LDOPTIONS) $(LOCAL_LIBRARIES) $(LDLIBS) $(EXTRA_LOAD_FLAGS) @@\
									@@\
SaberProgramTarget(program,$(SRCS),$(OBJS),$(LOCAL_LIBRARIES), /**/)	@@\
									@@\
InstallProgram(program,$(BINDIR))					@@\
InstallManPage(program,$(MANDIR))					@@\
DependTarget()								@@\
LintTarget()								@@\
									@@\
clean::									@@\
	$(RM) $(PROGRAM)
#endif /* ComplexCPlusPlusTarget */

