/* $Date: 91/12/06 16:35:34 $    $Revision: 1.6 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/*****************************************************************************
 CmFigureEditor.h - Node Handler/Editor Definition
 Contact: sniyogi,maschaub
*****************************************************************************/
#ifndef _CMFigureEDITOR
#define _CMFigureEDITOR
#include <CDS.h>

#define MSDOUBLECLICK    300


class CmCDS;
class CmDialog;
class CmFigure;
class CmFigureClass;
class CmFigureEditor;
class CmFigureHandler;
class CmFigureParser;
class CmFigureRegistrar;
class CmFigureTree;
class CmPage;

struct CmEditorCmFigureClassWad {
  CmFigureEditor* Editor;
  CmFigureClass * CmClass;
};


// editing callback needed by CmFigureClass
void CmCreateFigure(Widget, CmEditorCmFigureClassWad*, XtPointer);

class CmFigureEditor {
 private:
  CmCDS* cds;          // Links to parent object
  CmFigureParser* figure_parser;       
  CmFigureHandler* figure_handler;
  CmFigureRegistrar* figure_registrar;
  CmFigureTree* figure_tree;
  CmFigure* clipboarded_cmfigure;
  Widget statusbox;   
  Widget workarea;
  void register_figure_classes();
  CmString get_figure_name(CmFigureClass*);
  Boolean cmstring_to_boolean(const CmString &, const CmString &);
  int cmstring_to_cmdialog_item_type(const CmString &, const CmString &);
  void load_widget_config();
 public:
  CmFigureEditor(CmCDS*, const Widget);// Constructor(cds, Figure workarea)
  ~CmFigureEditor();  // Destructor

  // Selectors
  CmCDS* CDSPtr() {
    return cds;
  }
  CmPage* Page;        // Given by navigator
  void ChangePage(CmPage*);  // Set node

  // Editing routines  (called by "Edit" pane menu)
  void EditFigure(Widget);
  void CreateFigure(CmString);
  void CreateFigure(CmFigureClass * const);
  void CreateFigure(CmFigureClass * const, const CmString &);
  void CutFigure();    
  void CopyFigure();   
  void PasteFigure();   

  void ShowAll();
  void HideCurrentFigure();
  void SetStatusBox(CmString);
  void ToggleEditing();
  Boolean Editing;

  CmFigure* GetHighlightedCmFigure();

  void SetHighlightedCmFigure(CmFigure * const);
  CmFigureClass *GetCmFigureClass(const CmString &);
  CmFigureClass *GetCmFigureClass(const WidgetClass);

  friend void CmFigureActivated(const Widget, 
				CmFigureEditor * const, 
				XEvent * const) ;
};

void CmPopupPalette(Widget w, CmFigureRegistrar* wr, XtPointer call_data);
#endif
