/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/XYPlotP.h,v 3.1 91/01/03 17:29:46 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtXYPlotP_h
#define _AtXYPlotP_h    

#include <X11/IntrinsicP.h>

#ifdef _AtDevelopment_
#include "PlotP.h"
#include "XYPlot.h"
#else
#include <At/PlotP.h>
#include <At/XYPlot.h>
#endif 

typedef struct _AtXYPlotClassPart {
    int higgledy_piggledy;
} AtXYPlotClassPart;

typedef struct _AtXYPlotClassRec {
    ObjectClassPart object_class;
    AtPlotClassPart plot_class;
    AtXYPlotClassPart xyplot_class;
} AtXYPlotClassRec;

extern AtXYPlotClassRec atXYPlotClassRec;

typedef struct _AtXYPlotPart {
    /* resources */
    Boolean connectPoints;
    Boolean markPoints;
    Boolean horizontalImpulses;
    Boolean verticalImpulses;
    int horzImpulseInterval;
    int vertImpulseInterval;
    int marker;
    double *xPoints;
    double *yPoints;
    int numPoints;
    /* private state */
    double *xpts;
    double *ypts;
    XPoint *pixpts;
    XPoint *oldpixpts;
    short zeroxpt;
    short zeroypt;
    Boolean valid;
    Boolean refresh; /* if true, refresh only this plot */
    GC solidGc;
} AtXYPlotPart;

typedef struct _AtXYPlotRec {
    ObjectPart object;
    AtPlotPart plot;
    AtXYPlotPart xyplot;
} AtXYPlotRec;


#endif /* _AtXYPlotP_h */
