;;; This emacs script is designed to convert the string manipulation
;;; files which come with the libg++ source into files which follow
;;; CDS naming conventions.

;;; To run this file, copy the files String.cc, String.h, Regex.cc,
;;; Regex.h (note that's with a capital "R") into one directory.
;;; Then start up emacs and execute the command.

;;; M-x load-file

;;; with the name of this file as the file to be loaded.

;;; This script will automatically change the files so that they follow
;;; CDS naming conventions, and save them as CmString and CmRegex.


;;; This function takes a list (a b) and replaces a with b, provided
;;; that a is delimited by things that would identify it as an
;;; identifer.

(defun replace-identifier (a)
	(beginning-of-buffer)
	(replace-regexp (concat "\\([.(<\n\t: ~,]\\)" (car a)
				"\\([ ()\t\n:,{;&.\*]\\)") 
			(concat "\\1" (car (cdr a)) "\\2")))

;;; This function takes a list (a b) and replaces a with b, provided
;;; that a is delimited by things that would identify it as an
;;; function.

(defun replace-function (a)
	(beginning-of-buffer)
	(replace-regexp (concat "\\([.(<\n\t: ~,]\\)" (car a)
				"\\( *(\\)") 
			(concat "\\1" (car (cdr a)) "\\2")))


(find-file "Regex.h")
(set-variable 'case-fold-search nil)
(mapcar 'replace-identifier
	'(("Regex" "CmRegex")))
(mapcar 'replace-function
	'(("match_info" "MatchInfo")
	  ("match" "Match")
	  ("search" "Search")))
(beginning-of-buffer)
(replace-string "CmRegex RX" "CmRegex CmRX")
(write-file "CmRegex.h")


(find-alternate-file "Regex.cc")
(set-variable 'case-fold-search nil)
(mapcar 'replace-identifier
	'(("Regex" "CmRegex")))
(mapcar 'replace-function
	'(("match" "Match")
	  ("search" "Search")
	  ("match_info" "MatchInfo")))
(beginning-of-buffer)
(replace-string "CmRegex RX" "CmRegex CmRX")
(write-file "CmRegex.cc")

(find-alternate-file "String.h")
(set-variable 'string-case-fold nil)
(mapcar 'replace-identifier
	'(("Regex" "CmRegex")
	  ("StrRep" "CmStrRep")
	  ("SubString" "CmSubString")
	  ("String" "CmString")))

(mapcar 'replace-function
	'(("contains" "Contains")
	  ("matches" "Matches")
	  ("match" "Match")
	  ("length" "Length")
	  ("empty" "Empty")
	  ("chars" "Chars")
	  ("prepend" "Prepend")
	  ("cat" "Cat")
	  ("index" "Index")
	  ("freq" "Freq")
	  ("at" "At")
	  ("before" "Before")
	  ("through" "Through")
	  ("from" "From")
	  ("after" "After")
	  ("del" "Del")
	  ("gsub" "Gsub")
	  ("split" "Split")
	  ("common_prefix" "CommonPrefix")
	  ("common_suffix" "CommonSuffix")
	  ("replicate" "Replicate")
	  ("join" "Join")
	  ("reverse" "Reverse")
	  ("upcase" "Upcase")
	  ("downcase" "Downcase")
	  ("capitalize" "Capitalize")
	  ("elem" "Elem")
	  ("firstchar" "Firstchar")
	  ("lastchar" "Lastchar")
	  ("readline" "Readline")
	  ("alloc" "Alloc")
	  ("allocation" "Allocation")
	  ("error" "Error")
	  ("compare" "Compare")
	  ("fcompare" "Fcompare")
	  ("search" "Search")))
(write-file "CmString.h")



(find-alternate-file "String.cc")
(set-variable 'string-case-fold nil)
(mapcar 'replace-identifier
	'(("Regex" "CmRegex")
	  ("StrRep" "CmStrRep")
	  ("SubString" "CmSubString")
	  ("String" "CmString")))
	
(mapcar 'replace-function
	'(("contains" "Contains")
	  ("matches" "Matches")
	  ("match" "Match")
	  ("length" "Length")
	  ("empty" "Empty")
	  ("chars" "Chars")
	  ("prepend" "Prepend")
	  ("cat" "Cat")
	  ("index" "Index")
	  ("freq" "Freq")
	  ("at" "At")
	  ("before" "Before")
	  ("through" "Through")
	  ("from" "From")
	  ("after" "After")
	  ("del" "Del")
	  ("gsub" "Gsub")
	  ("split" "Split")
	  ("common_prefix" "CommonPrefix")
	  ("common_suffix" "CommonSuffix")
	  ("replicate" "Replicate")
	  ("join" "Join")
	  ("reverse" "Reverse")
	  ("upcase" "Upcase")
	  ("downcase" "Downcase")
	  ("capitalize" "Capitalize")
	  ("elem" "Elem")
	  ("firstchar" "Firstchar")
	  ("lastchar" "Lastchar")
	  ("readline" "Readline")
	  ("alloc" "Alloc")
	  ("allocation" "Allocation")
	  ("error" "Error")
	  ("compare" "Compare")
	  ("fcompare" "Fcompare")
	  ("search" "Search")))
(write-file "CmString.cc")

