#ifndef _CMMODELCONNECTION_H
#define _CMMODELCONNECTION_H

#include <CDS.h>

class CmModelConnection {
  FILE *io_stream;
  int master;
  XtInputId input_id;
  XtInputId output_id;
  int child_pid;
  Boolean is_blocked;
  Boolean has_echo;
  CmString connect_buffer;
  XtAppContext app_context;
  XtInputCallbackProc connection_callback;
  XtPointer connection_client_data;
  int send_signal(int);
public:
  CmModelConnection(const CmString &, XtAppContext);
  ~CmModelConnection();
  void AddInput(XtInputCallbackProc, XtPointer);
  int Read(char *, int);
  void Write(CmString);
  void SetEcho(Boolean);
  int SendSignal(int);
  void Interrupt();
  friend void
    CmModelConnectionWorkProc(CmModelConnection*, int *, XtInputId *);
  friend void
    CmModelConnectionCallback(CmModelConnection*, int *, XtInputId *);
};
#endif

