#include <CmModelEvaluator.h>
#include <X11/Shell.h>

#ifdef ATHENA_WIDGETS

#else
#include <Xm/Text.h>
#include <Xm/PushBG.h>
#include <Xm/PanedW.h>
#include <Xm/RowColumn.h>
#endif


static void CmModelPopdown(Widget, Widget shell, XtPointer) {
  XtPopdown(shell);
}

void CmModelClearEvaluatorOutput(Widget, 
					CmModelEvaluator *evaluator, 
					XtPointer) {
#ifdef ATHENA_WIDGETS
#else
  XmTextSetString(evaluator->output, "");
#endif
}

CmModelEvaluator::CmModelEvaluator(Widget widget, 
				   XtCallbackProc proc,
				   XtPointer pointer) {
  shell =
    XtCreatePopupShell("evaluator", transientShellWidgetClass, 
		       widget, NULL, 0);
  
  const Widget evaluator_pane = 
    XtCreateManagedWidget("evaluator_pane", 
#ifdef ATHENA_WIDGETS
#else
			  xmPanedWindowWidgetClass,
#endif 
			  shell, NULL, 0);
  
  button_box = 
    XtCreateManagedWidget("evaluator_buttons", 
#ifdef ATHENA_WIDGETS
#else
			  xmRowColumnWidgetClass,
#endif 
			  evaluator_pane, NULL, 0);

  AddButton("evaluator_close", 
	    (XtCallbackProc) CmModelPopdown, (XtPointer) shell);

  //evaluator clear
  AddButton("evaluator_clear", 
	    (XtCallbackProc) CmModelClearEvaluatorOutput, (XtPointer) this);

#ifdef ATHENA_WIDGETS
#else
  output =
    XmCreateScrolledText(evaluator_pane, "evaluator_output",  NULL, 0);
  XtManageChild(output);

  input = 
    XmCreateScrolledText(evaluator_pane, "evaluator_input", NULL, 0);
  XtManageChild(input);
  if (proc) 
    XtAddCallback(input, XmNactivateCallback, proc, pointer);
#endif
}

CmModelEvaluator::~CmModelEvaluator() {
  XtDestroyWidget(shell);
}

void CmModelEvaluator::AddButton(char *name,
				 XtCallbackProc callback,
				 XtPointer client_data) {
#ifdef ATHENA_WIDGETS
#else
  const Widget button = 
    XtCreateManagedWidget(name, xmPushButtonGadgetClass,
			  button_box, NULL, 0);
  XtAddCallback(button, XmNactivateCallback, callback, client_data);
#endif
}

CmModelEvaluator& operator<<(CmModelEvaluator &evaluator, const CmString &output) {
  return(evaluator << output.Chars());
}

CmModelEvaluator& operator<<(CmModelEvaluator &evaluator, const char *output) {
  const Widget widget = evaluator.output;
  if (widget) {
#ifdef ATHENA_WIDGETS
#else
    XmTextInsert(widget, XmTextGetLastPosition(widget), (char *) output);
    XmTextSetCursorPosition(widget, XmTextGetLastPosition(widget));
    XmTextShowPosition(widget, XmTextGetLastPosition(widget));
#endif
  }
   return evaluator;
}

CmModelEvaluator& operator>>(CmModelEvaluator &evaluator, CmString &output) {
  const Widget input = evaluator.input;
  if (input) {
#ifdef ATHENA_WIDGETS
#else
    // Can't assign the XmTextGetString directly to CmString, otherwise
    // we get a memory leak.
    char *string = XmTextGetString(input);
    XmTextSetString(input, "");
#endif
    output = string;
    free(string);
  }
  return evaluator;
}

