/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/*********************************************
 CmNavigatorOutliner.h - Page definition
 Contact: joe, maschaub
 *********************************************/
#ifndef _CMNAVIGATOROUTLINER_H
#define _CMNAVIGATOROUTLINER_H
class CmNavigator;

struct CmOutlineItem {
  CmString item;
  CmInt level;
  CmBool compressed;
  CmBool hidden;
  CmInt location_on_list;
  CmOutlineItem() {
    level =0; compressed = FALSE; hidden = FALSE; location_on_list = 0;
  }
};

class CmNavigatorOutliner {
 private:
  CmNavigator *navigator;
  Widget any;

  CmList item_list;
  CmInt counter;
  CmInt current_item;
  CmInt current_level;
  CmInt get_index_of_page(const CmString &);
  CmInt number_of_displayed_items;

  CmOutlineItem *get_item(const CmInt i) {
    return ((CmOutlineItem *)item_list[i]);
  };
  CmBool show_titles;

  void highlight_outline_item();
  void update_outline();
 public:

  /* Constructor and Destructor */
  CmNavigatorOutliner(CmNavigator*, Widget);
  ~CmNavigatorOutliner();

  /* modify the outliner */
  void AppendItemToOutline(const CmString &);
  void AddItemToOutline(const CmString &, const CmString &);

  CmString GetPageName(const CmString &command) {
    return GetPageName(command, "");
  }
  CmString GetPageName(const CmString &, const CmString &page_name);
  CmString GetPageName(const CmString &, const int);
  void ShowTitles(Boolean);

  friend ostream& operator << (ostream &, CmNavigatorOutliner *);
};

ostream& operator << (ostream &, CmNavigatorOutliner *);
ostream& operator << (ostream &, CmOutlineItem*);
#endif

