/*
 * This file is part of the OLH On-Line Help system
 *
 *	Chris VanHaren
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /afs/athena.mit.edu/astaff/project/olhdev/src/motif/RCS/MuMenuP.h,v $
 *      $Id: MuMenuP.h,v 1.1 90/12/19 10:59:14 lwvanels Exp $
 *      $Author: lwvanels $
 */

#include <X11/copyright.h>

/* $XConsortium: TemplateP.h,v 1.4 89/07/21 01:41:48 kit Exp $ */
/* Copyright	Massachusetts Institute of Technology	1987, 1988 */

#ifndef _MuMenuP_h
#define _MuMenuP_h

#include "MuMenu.h"
#include <Xm/RowColumnP.h>

typedef struct {
    int empty;
} MuMenuClassPart;

typedef struct _MuMenuClassRec {
    CoreClassPart               core_class;
    CompositeClassPart          composite_class;
    ConstraintClassPart         constraint_class;
    XmManagerClassPart          manager_class;
    XmRowColumnClassPart        row_column_class;
    MuMenuClassPart	        muMenu_class;
} MuMenuClassRec;

extern MuMenuClassRec muMenuClassRec;

typedef struct {
    /* resources */
    char *items;
} MuMenuPart;

typedef struct _MuMenuRec {
    CorePart            core;
    CompositePart       composite;
    ConstraintPart      constraint;
    XmManagerPart       manager;
    XmRowColumnPart     row_column;
    MuMenuPart	        muMenu;
} MuMenuRec;

#endif /* _MuMenuP_h */
