/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/dialog/RCS/dialog.h,v 3.5 91/07/03 09:27:53 dot Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#include <Xm/DialogS.h>
#include <Xm/Label.h>
#include <Xm/Text.h>
#include <Xm/ToggleB.h>
#include <Xm/Separator.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>

#ifdef _AtDevelopment_
#include "Parameter.h"
#include "Layout.h"
#include "MuMenu.h"    
#else
#include <At/Parameter.h>
#include <At/Layout.h>    
#include <At/MuMenu.h>
#endif


typedef struct {
    char *name;         /* the name of the widget in the dialog box */
    short widgettype;   /* the type of the widget in the dialog box */
    short valuetype;    /* what sort of value is being dialoged about */
    char *value;        /* the value or a "pointer" to it */
    Widget w;           /* the widget in the dialog.  Created automatically */
} DialogInfo;

typedef struct {
    Widget shell;
    Widget form;
    DialogInfo *info;
    int n;
    Widget w;          /* the widget that is the subject of the dialog */
    Arg *arglist;      /* the Arglist used in setting widget values. */
    int nargs;         /* number of set arg structures in arglist. */
} Dialog;

/* widget types */
#define AtDialogLABEL 1
#define AtDialogDOUBLEPARAMETER 2
#define AtDialogINTPARAMETER 3
#define AtDialogSHORTPARAMETER 4
#define AtDialogTOGGLE 5
#define AtDialogTEXT 6
#define AtDialogSEPARATOR 7
#define AtDialogPUSHBUTTON 8
#define AtDialogINTOPTION 9
#define AtDialogSHORTOPTION 10
#define AtDialogSTRINGOPTION 11

/* where the value comes from */
#define AtDialogRESOURCE 1
#define AtDialogIMMEDIATE 2
#define AtDialogABSOLUTE 3
#define AtDialogOFFSET 4
#define AtDialogCOPYSTRING 5

extern Dialog* AtDialogCreate(Widget, char *, char *, DialogInfo *, int);
extern void AtDialogDestroy(Dialog *);
extern void AtDialogSetValues(Dialog *, Widget);
extern void AtDialogGetValues(Dialog *, Widget);
extern void AtDialogDo(Dialog *, Widget);
extern void AtDialogApplyCallback();
extern void AtDialogResetCallback();
extern void AtDialogDoneCallback();

