\CDS_Version "2.00.00"

\begin_outline
"introduction"
"what_is_CDS"
"interaction"
"objects"
\end_outline


\begin_page{introduction}
\title{Introduction}
\page_constructor_text "#!scheme
(load \"$CDS_CONFIG_DIR/cds.scheme\")"
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled0_XmLabel0" 
borderWidth "0";
bottomPosition "511";
labelPixmap "mit-logo";
labelType "PIXMAP";
leftPosition "290";
rightPosition "705";
topPosition "209";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled0_XmLabel0" 
borderWidth "0";
bottomPosition "183";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Courseware Development System";
leftPosition "186";
rightPosition "839";
topPosition "105";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled0_XmLabel0" 
borderWidth "0";
bottomPosition "976";
fontList "*lucida-*-r-*-*-24-*";
labelString "Marc Schaub - Introduction
Adam Feder - Objects
Sourabh Niyogi - Usage
Joe Wang - Navigator
Jeff Turcotte - Queue Theory
Jason Beardsley - Bernoulli Process
Rob Nunez - Newton's Method
John Piscitello - Convolution ";
leftPosition "192";
rightPosition "784";
topPosition "448";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled" 
bottomPosition "71";
labelString "Click on the next button to go on . . .";
leftPosition "615";
rightPosition "965";
topPosition "8";
\end_figure
\end_screen
\end_page

\begin_page{what_is_CDS}
\title{What is CDS?}
\page_constructor_text "(define seq 0)
(cds-plotter-xyplot \"$CDS_THIS_PAGE\" \"d5\" \"f1\" 
 (lambda (x)
  (abs (/ (sin (* x 3)) (sin x)))) -3 3 )
"
\page_entry_text "(define seq 0)
(set! cds-plot-resolution 50)
(cds-figure-show \"$CDS_THIS_PAGE\" \"l0\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"d2\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"d3\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"d4\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"d5\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"l1\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"l2\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"l3\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"l4\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"l5\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"l6\")
"
\begin_screen

\begin_figure {XmLabel}
\figure_name "l0" 
borderWidth "10";
bottomPosition "126";
fontList "*lucida-*-r-*-*-24-*";
labelString "CDS is an interactive book";
leftPosition "274";
rightPosition "785";
topPosition "47";
\end_figure

\begin_figure {XmLabel}
\figure_name "l1" 
borderWidth "0";
bottomPosition "224";
fontList "*lucida-*-r-*-*-24-*";
labelString "CDS has all the characteristics of a text book";
leftPosition "128";
mappedWhenManaged "False";
rightPosition "912";
topPosition "144";
\end_figure

\begin_figure {XmLabel}
\figure_name "l2" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "352";
fontList "*lucida-*-r-*-*-24-*";
labelString "1.  It can have textual information";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "816";
topPosition "256";
\end_figure

\begin_figure {XmLabel}
\figure_name "l3" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "448";
fontList "*lucida-*-r-*-*-24-*";
labelString "2.  It can have formulas";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "816";
topPosition "352";
\end_figure

\begin_figure {XmLabel}
\figure_name "l4" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "544";
fontList "*lucida-*-r-*-*-24-*";
labelString "3.  It can have figures";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "816";
topPosition "448";
\end_figure

\begin_figure {XmLabel}
\figure_name "l5" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "656";
fontList "*lucida-*-r-*-*-24-*";
labelString "4.  It can have plots";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "816";
topPosition "544";
\end_figure

\begin_figure {CmLabel}
\figure_name "d2" 
borderWidth "5";
bottomPosition "992";
label "   On-Line Consulting (OLC) is a system which enables users to
     get help from consultants or volunteers.  When a user types
     olc, he is placed in a subsystem which allows him to browse
     answers to common questions, or ask a consultant a question. 
    If the user types ask, olc asks for a one-word description
     of the question, called a \"topic\"'.  Typing a ? at this
     prompt gives a list of the valid topics.  This topic allows
     OLC to find a consultant who knows something about that part
     of the system.  After the user has selected a topic, olc
     prompts him for a question, and tries to find a consultant
     who is available to answer questions.  If there is one, the
     user and the consultant receive messages saying they have
     been connected.  At this point, the user and the consultant
     can exchange messages by using the send command.  There
     may be some delay between messages as the consultant com-
     poses a response.  A user can temporarily exit from olc at
     any point, but the question is terminated only when she uses
     either the done or cancel command, or when the consul-
     tant types done.
";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "784";
topPosition "336";
xFlag "left";
\end_figure

\begin_figure {CmLabel}
\figure_name "d3" 
borderWidth "5";
bottomPosition "688";
fontSize "big";
label "@i[a@-[n] = @Over(Num[1] Denom[@g[Pi]]) @Int(From[-@g[Pi]] To[@g[Pi]]) f(t) sin(nt) dt]";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "688";
textMode "fill";
topPosition "432";
\end_figure

\begin_figure {XmLabel}
\figure_name "d4" 
borderWidth "5";
bottomPosition "845";
labelPixmap "enterprise2";
labelType "PIXMAP";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "657";
topPosition "544";
\end_figure

\begin_figure {AtPlotter}
\figure_name "d5" 
*lineWidth "3";
autoScale "False";
borderWidth "5";
bottomPosition "960";
leftPosition "240";
mappedWhenManaged "False";
motionX "0.211957";
motionY "3.440000";
rightPosition "768";
title "Array Factor";
topPosition "656";
xaxis.label "u = .5(kd@times cos(@theta)) + @psi)";
xaxis.max "3";
xaxis.min "-3";
yaxis.label "(|sin(3u)| @div |sin(u)|)";
yaxis.max "4";
\end_figure

\begin_figure {XmLabel}
\figure_name "l6" 
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "752";
fontList "*lucida-*-r-*-*-24-*";
labelString "5. It has pages that can be referenced 
     just like any book.";
leftPosition "240";
mappedWhenManaged "False";
rightPosition "896";
topPosition "656";
\end_figure

\begin_figure {XmPushButton}
\figure_name "untitled" 
\callback "Activate" ";; seq is an index for stages that hides and shows certain figures
;; at each stage, the last stage goes to the next page
(cond ((= seq 0) (cds-figure-show \"$CDS_THIS_PAGE\" \"l1\"))
 ((= seq 1) (cds-figure-show \"$CDS_THIS_PAGE\" \"l2\") 
	(cds-figure-show \"$CDS_THIS_PAGE\" \"d2\"))
 ((= seq 2) (cds-figure-hide \"$CDS_THIS_PAGE\" \"d2\")  
	(cds-figure-show \"$CDS_THIS_PAGE\" \"l3\") 
	(cds-figure-show \"$CDS_THIS_PAGE\" \"d3\"))
((= seq 3) (cds-figure-hide \"$CDS_THIS_PAGE\" \"d3\")  
	(cds-figure-show \"$CDS_THIS_PAGE\" \"l4\") 
	(cds-figure-show \"$CDS_THIS_PAGE\" \"d4\"))
((= seq 4) (cds-figure-hide \"$CDS_THIS_PAGE\" \"d4\")  
	(cds-figure-show \"$CDS_THIS_PAGE\" \"l5\") 
	(cds-figure-show \"$CDS_THIS_PAGE\" \"d5\"))
((= seq 5) (cds-figure-hide \"$CDS_THIS_PAGE\" \"d5\") 
	(cds-figure-show \"$CDS_THIS_PAGE\" \"l6\"))
)
(set! seq (+ seq 1))
(cond ((> seq 6) 
	(set! seq 0)
	(cds-navigator-goto-page \"interaction\")) )"
borderWidth "0";
bottomPosition "144";
fillOnArm "False";
labelString "Click Here to 
step through 
the demo";
leftPosition "0";
rightPosition "240";
topPosition "0";
\end_figure
\end_screen
\end_page

\begin_page{interaction}
\title{Interaction}
\page_constructor_text "(set! cds-plot-resolution 101)
(cds-plotter-xyplot \"$CDS_THIS_PAGE\" \"p1\" \"f1\" 
 (lambda (x)
   (abs (/ (sin (* x 3)) (sin x)))) -3 3)
"
\begin_screen

\begin_figure {XmLabel}
\figure_name "m0" 
borderWidth "5";
bottomPosition "192";
fontList "*lucida-*-r-*-*-24-*";
labelString "CDS is interactive";
leftPosition "256";
rightPosition "736";
topPosition "48";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
bottomPosition "416";
fontList "*lucida-*-r-*-*-24-*";
labelString "Certain parts of the CDS book are able to accept 
input from the user.   Being able to interact with the
user allows interactive learning rather than passive.";
leftPosition "32";
rightPosition "944";
topPosition "208";
\end_figure

\begin_figure {AtPlotter}
\figure_name "p1" 
\callback "Click" "(define n ${s1:value})  ;; get resource form scale
(set! cds-plot-resolution 101)  ;;; odd number to avoid / 0
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"p1\" \"yaxis.max\" n)
(cds-plotter-xyplot \"$CDS_THIS_PAGE\" \"p1\" \"f1\" (lambda (x)
	(abs (/ (sin (* n x)) (sin x)))) -3 3)
"
*lineWidth "3";
borderWidth "5";
bottomPosition "896";
canZoom "False";
clickX "-2.763788";
clickY "0.086022";
leftPosition "176";
motionX "-3.282276";
motionY "2.120708";
rightPosition "944";
title "Array Factor";
topPosition "431";
xaxis.label "u = .5(kd@times cos(@theta)) + @psi)";
xaxis.max "3";
xaxis.min "-3";
yaxis.label "(|sin(3u)| @div |sin(u)|)";
yaxis.max "2";
\end_figure

\begin_figure {XmScale}
\figure_name "s1" 
borderWidth "0";
bottomPosition "896";
leftPosition "96";
maximum "10";
rightPosition "159";
titleString "n";
topPosition "431";
value "2";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled" 
bottomPosition "990";
fontList "*times-*-r-*-*-20-*";
labelString "Click on the plotter to plot";
leftPosition "324";
rightPosition "756";
topPosition "912";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled" 
bottomPosition "139";
labelString "Click on the NEXT 
button to go on";
leftPosition "778";
rightPosition "975";
topPosition "41";
\end_figure
\end_screen
\end_page

\begin_page{objects}
\title{Objects}
\page_entry_text ";; this page steps through a bunch of figures that are stored
;; in a list

(define (cds-figure-show-fun w) 
	(cds-figure-show \"$CDS_THIS_PAGE\" w))
(define (cds-figure-hide-fun w) 
	(cds-figure-hide \"$CDS_THIS_PAGE\" w))

(define (map proc L)
   (if (null? L) 
	nil
        (cons (proc (car L)) (map proc (cdr L)))))


(define Main-Topics (list \"Text-Tool\" \"Label\" \"Toggle-Button\" 
                     \"Scale\" \"Push-Button\" \"Text\" \"Plotter\"))

(define Display-Name \"*undefined*\")
(define Num-Widgets 1)

(define (make-figure-name  root  suffix)
    (string-append root \"-\" suffix))

(define (setup-display name figure-count)
   (set! Display-Name name)
   (set! Num-Widgets figure-count)
   (cds-figure-hide \"$CDS_THIS_PAGE\" \"Intro-4\")
   (map (lambda (w) (cds-figure-hide \"$CDS_THIS_PAGE\" 
	    (make-figure-name w \"Main\")))
                 Main-Topics)
   (define i 1)
   (while (< i figure-count)
	  (set! i (1+ i))
       (cds-figure-show \"$CDS_THIS_PAGE\" 
			(make-figure-name name (number->string i))))
   (cds-figure-show \"$CDS_THIS_PAGE\" \"Done-Button\"))

(define (delete-token el L)
  (if (null? L) 
	nil
        ((eq? (car L) el) (delete el (cdr L)))
         (else (cons (car L) (delete el (cdr L))))))

(define (toggle-button-action state Turn-ON Turn-OFF)
  (if (eq? state \"On\")
                     (Turn-OFF)
                     (Turn-ON)))

(define (interval a b)
   (if (> a b) 
         nil
         (cons a (interval (+ a 1) b))))

(define log2 (log 2))
(define (damped-sin x)
    (/ (sin (* 3 x)) (exp (* (* x (rnd)) log2))))


(define Intro-Count 1)

(define (reset!)
 (define trekkie? '#t)
 (define fuzzy? '#t)
 (define crazy? '#t)
 (cds-figure-call-callback \"$CDS_THIS_PAGE\" 
  \"Reset-Button\" \"Activate\"))
(reset!)"
\begin_screen
\begin_figure {XmPushButton}
\figure_name "Text-Tool-Main" 
\mapping "False"
\callback "Activate" "(setup-display \"Text-Tool\" 3)"
bottomPosition "206";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Text Tool";
leftPosition "0";
rightPosition "288";
topPosition "111";
\end_figure\begin_figure {XmPushButton}
\figure_name "Label-Main" 
\mapping "False"
\callback "Activate" "(setup-display \"Label\" 5)"
bottomPosition "335";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Labels";
leftPosition "0";
rightPosition "288";
topPosition "240";
\end_figure\begin_figure {XmPushButton}
\figure_name "Toggle-Button-Main" 
\mapping "False"
\callback "Activate" "(setup-display \"Toggle-Button\" 8)
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Toggle-Button-3\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Toggle-Button-5\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Toggle-Button-7\")
(define trekkie? '#t)
(define fuzzy? '#t)
(define crazy? '#t)"
bottomPosition "468";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Toggle Button";
leftPosition "8";
rightPosition "296";
topPosition "373";
\end_figure\begin_figure {XmPushButton}
\figure_name "Scale-Main" 
\mapping "False"
\callback "Activate" "(setup-display \"Scale\" 6)"
bottomPosition "590";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Scale";
leftPosition "0";
rightPosition "288";
topPosition "495";
\end_figure\begin_figure {XmPushButton}
\figure_name "Push-Button-Main" 
\mapping "False"
\callback "Activate" "(setup-display \"Push-Button\" 6)"
bottomPosition "718";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Push Button";
leftPosition "0";
rightPosition "288";
topPosition "623";
\end_figure\begin_figure {XmPushButton}
\figure_name "Text-Main" 
\mapping "False"
\callback "Activate" "(setup-display \"Text\" 4)"
bottomPosition "847";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Text";
leftPosition "0";
rightPosition "207";
topPosition "752";
\end_figure\begin_figure {XmPushButton}
\figure_name "Plotter-Main" 
\mapping "False"
\callback "Activate" "(setup-display \"Plotter\" 6)"
bottomPosition "976";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Plotter";
leftPosition "0";
rightPosition "208";
topPosition "880";
\end_figure\begin_figure {XmLabel}
\figure_name "Text-Tool-1" 
\mapping "False"
bottomPosition "112";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Text Tools";
leftPosition "336";
rightPosition "560";
topPosition "16";
\end_figure\begin_figure {XmLabel}
\figure_name "Text-Tool-2" 
\mapping "False"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "352";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "* Can understand some  Scribe commands
* Can display math formulas";
leftPosition "160";
rightPosition "944";
topPosition "128";
\end_figure\begin_figure {XmPushButton}
\figure_name "Done-Button" 
\mapping "False"
\callback "Activate" "(define i 1)
(while  (< i Num-Widgets) 
	(set! i (1+ i))
	(cds-figure-hide \"$CDS_THIS_PAGE\"
		    (make-figure-name Display-Name (number->string i))))
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Done-Button\")
(map cds-figure-show-fun
     (map (lambda (w) 
	    (make-figure-name w \"Main\"))
	  Main-Topics))
(cds-figure-show \"$CDS_THIS_PAGE\" \"Intro-4\") "
bottomPosition "974";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "OK";
leftPosition "899";
rightPosition "991";
topPosition "879";
\end_figure\begin_figure {XmLabel}
\figure_name "Label-5" 
\mapping "False"
bottomPosition "951";
labelPixmap "wizard";
labelType "PIXMAP";
leftPosition "626";
rightPosition "803";
topPosition "736";
\end_figure\begin_figure {XmLabel}
\figure_name "Label-4" 
\mapping "False"
bottomPosition "698";
fontList "9x15bold";
labelString "CDS (cee-dee-ess) n.  Courseware Development System
a user-friendly and author-friendly system for creating
stimulating, interactive learning devices.  Designed and 
created entirely by students, its environment provides a
simple way to interact with complicated user-interfaces.
It is so simple, even freshmen can create meaningful
applications with it. ";
leftPosition "136";
rightPosition "799";
topPosition "404";
\end_figure\begin_figure {XmLabel}
\figure_name "Label-3" 
\mapping "False"
bottomPosition "955";
labelPixmap "hobbes";
labelType "PIXMAP";
leftPosition "143";
rightPosition "320";
topPosition "735";
\end_figure\begin_figure {XmLabel}
\figure_name "Label-2" 
\mapping "False"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "336";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "* Can Display Normal Fonts 
* Has the Widest Range of Fonts
* Can Display Pixmaps
* (this is a label)";
leftPosition "152";
rightPosition "795";
topPosition "57";
\end_figure\begin_figure {XmLabel}
\figure_name "Label-1" 
\mapping "False"
bottomPosition "114";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Labels";
leftPosition "363";
rightPosition "561";
topPosition "16";
\end_figure\begin_figure {XmLabel}
\figure_name "Toggle-Button-3" 
\mapping "False"
bottomPosition "807";
labelPixmap "enterprise2";
labelType "PIXMAP";
leftPosition "282";
rightPosition "592";
topPosition "498";
\end_figure\begin_figure {XmLabel}
\figure_name "Toggle-Button-1" 
\mapping "False"
bottomPosition "105";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Toggle Buttons";
leftPosition "380";
rightPosition "613";
topPosition "8";
\end_figure\begin_figure {XmLabel}
\figure_name "Toggle-Button-2" 
\mapping "False"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "412";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "* Toggle buttons are like push buttons except 
  that they show state -- On or Off
* Toggle Buttons can be used to change
  and display variables
* Clicking on them with the left button
  changes their state";
leftPosition "9";
rightPosition "989";
topPosition "15";
\end_figure\begin_figure {XmToggleButton}
\figure_name "Toggle-Button-4" 
\mapping "False"
\callback "Value Changed" "(if trekkie?
 (cds-figure-show \"$CDS_THIS_PAGE\" \"Toggle-Button-3\")
 (cds-figure-hide \"$CDS_THIS_PAGE\" \"Toggle-Button-3\"))
(set! trekkie? (not trekkie?))
"
bottomPosition "941";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Trekkie?";
leftPosition "332";
rightPosition "576";
topPosition "846";
\end_figure\begin_figure {XmLabel}
\figure_name "Toggle-Button-5" 
\mapping "False"
bottomPosition "811";
labelPixmap "fuzzball";
labelType "PIXMAP";
leftPosition "55";
rightPosition "249";
topPosition "498";
\end_figure\begin_figure {XmToggleButton}
\figure_name "Toggle-Button-6" 
\mapping "False"
\callback "Value Changed" "(if fuzzy?
 (cds-figure-show \"$CDS_THIS_PAGE\" \"Toggle-Button-5\")
 (cds-figure-hide \"$CDS_THIS_PAGE\" \"Toggle-Button-5\"))
(set! fuzzy? (not fuzzy?))
 "
bottomPosition "934";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Fuzzy?";
leftPosition "54";
rightPosition "249";
topPosition "844";
\end_figure\begin_figure {XmLabel}
\figure_name "Toggle-Button-7" 
\mapping "False"
bottomPosition "810";
labelPixmap "mit-logo";
labelType "PIXMAP";
leftPosition "659";
rightPosition "855";
topPosition "498";
\end_figure\begin_figure {XmToggleButton}
\figure_name "Toggle-Button-8" 
\mapping "False"
\callback "Value Changed" "(if crazy?
 (cds-figure-show \"$CDS_THIS_PAGE\" \"Toggle-Button-7\")
 (cds-figure-hide \"$CDS_THIS_PAGE\" \"Toggle-Button-7\"))
(set! crazy? (not crazy?))"
bottomPosition "944";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Crazy?";
leftPosition "662";
rightPosition "858";
topPosition "849";
\end_figure\begin_figure {XmLabel}
\figure_name "Scale-6" 
\mapping "False"
borderWidth "0";
bottomPosition "901";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "2.1";
leftPosition "462";
rightPosition "606";
topPosition "806";
\end_figure\begin_figure {XmLabel}
\figure_name "Scale-5" 
\mapping "False"
borderWidth "0";
bottomPosition "899";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "A + B =";
leftPosition "289";
rightPosition "481";
topPosition "804";
\end_figure\begin_figure {XmScale}
\figure_name "Scale-3" 
\mapping "False"
\callback "Value Changed" "(cds-figure-set-resource \"$CDS_THIS_PAGE\"  \"Scale-6\"   \"labelString\"
			 (+ (/ ${Scale-3:value} 10)
			    ${Scale-4:value}))
"
borderWidth "0";
bottomPosition "656";
decimalPoints "1";
leftPosition "160";
maximum "1000";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "704";
titleString "B";
topPosition "546";
value "61";
\end_figure\begin_figure {XmScale}
\figure_name "Scale-4" 
\mapping "False"
\callback "Value Changed" "(cds-figure-set-resource \"$CDS_THIS_PAGE\"  \"Scale-6\"   \"labelString\"
      (+ (/ ${Scale-3:value} 10)
            ${Scale-4:value}))
"
borderWidth "0";
bottomPosition "769";
leftPosition "155";
minimum "-100";
orientation "HORIZONTAL";
rightPosition "703";
titleString "A";
topPosition "652";
value "-4";
\end_figure\begin_figure {XmLabel}
\figure_name "Scale-2" 
\mapping "False"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "505";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "* Used to input or display values in a range
* Clicking with the left button on the slide
   will adjust the value in clicks
* Pressing with the middle button and holding
   in will slide the value smoothly
* Have two directions, variable range,
   and variable accuracy";
leftPosition "145";
rightPosition "848";
topPosition "30";
\end_figure\begin_figure {XmLabel}
\figure_name "Scale-1" 
\mapping "False"
bottomPosition "112";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Scales";
leftPosition "352";
rightPosition "560";
topPosition "16";
\end_figure\begin_figure {XmLabel}
\figure_name "Push-Button-4" 
\mapping "False"
bottomPosition "736";
labelPixmap "escherknot";
labelType "PIXMAP";
leftPosition "352";
rightPosition "576";
topPosition "336";
\end_figure\begin_figure {XmLabel}
\figure_name "Push-Button-3" 
\mapping "False"
bottomPosition "736";
labelPixmap "peaco";
labelType "PIXMAP";
leftPosition "352";
rightPosition "576";
topPosition "336";
\end_figure\begin_figure {XmPushButton}
\figure_name "Push-Button-6" 
\mapping "False"
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"Push-Button-3\")"
bottomPosition "880";
fontList "9x15bold";
labelString "Press to see The Man";
leftPosition "512";
rightPosition "784";
topPosition "784";
\end_figure\begin_figure {XmPushButton}
\figure_name "Push-Button-5" 
\mapping "False"
\callback "Activate" "(cds-figure-show \"$CDS_THIS_PAGE\" \"Push-Button-4\")"
bottomPosition "880";
fontList "9x15bold";
labelString "Press to see The Knot";
leftPosition "160";
rightPosition "432";
topPosition "784";
\end_figure\begin_figure {XmLabel}
\figure_name "Push-Button-2" 
\mapping "False"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "255";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "* Pushing starts a Scheme process
* Click on with the left button to Push";
leftPosition "168";
rightPosition "903";
topPosition "111";
\end_figure\begin_figure {XmLabel}
\figure_name "Push-Button-1" 
\mapping "False"
bottomPosition "128";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Push Buttons";
leftPosition "368";
rightPosition "576";
topPosition "16";
\end_figure\begin_figure {XmLabel}
\figure_name "Text-2" 
\mapping "False"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "304";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "* For textual input -- lines, forms, full-window
* Provides consistent editing for the application";
leftPosition "144";
rightPosition "832";
topPosition "144";
\end_figure\begin_figure {XmLabel}
\figure_name "Text-1" 
\mapping "False"
bottomPosition "112";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Text";
leftPosition "384";
rightPosition "592";
topPosition "16";
\end_figure\begin_figure {XmText}
\figure_name "Text-3" 
\mapping "False"
\callback "Value Changed" "(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"Text-4\" \"value\"
   \"\\"${Text-3:value}\\"\")"
bottomPosition "928";
editMode "MULTI_LINE_EDIT";
leftPosition "64";
rightPosition "464";
topPosition "384";
value "llll Type in the left window...";
\end_figure\begin_figure {XmText}
\figure_name "Text-4" 
\mapping "False"
bottomPosition "928";
editMode "MULTI_LINE_EDIT";
leftPosition "464";
rightPosition "864";
topPosition "384";
value "llll Type in the left window...";
\end_figure\begin_figure {XmLabel}
\figure_name "Plotter-2" 
\mapping "False"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "512";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "* Display various kinds of plots
    * Connected/Unconnected Point Plots
    * Bar Charts
* Can Zoom in on plots
* Can have different legends
* Support Linear and Logarithmic axes";
leftPosition "176";
rightPosition "768";
topPosition "112";
\end_figure\begin_figure {XmLabel}
\figure_name "Plotter-1" 
\mapping "False"
bottomPosition "112";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Plotters";
leftPosition "384";
rightPosition "592";
topPosition "16";
\end_figure\begin_figure {AtPlotter}
\figure_name "Plotter-3" 
\mapping "False"
\constructor_text "(add-barchart \"Plotter-3\" \"Random-Pts\" 11)"
bottomPosition "862";
leftPosition "57";
motionX "13.128000";
motionY "0.800559";
rightPosition "480";
title "Random Points";
topPosition "512";
xaxis.label "Toss";
xaxis.max "12";
yaxis.label "Value";
\end_figure\begin_figure {XmPushButton}
\figure_name "Plotter-4" 
\mapping "False"
\callback "Activate" "(define points
   (map (lambda (x) (rnd)) (interval 1 10)))
(cds-plotter-barchart \"$CDS_THIS_PAGE\" \"Plotter-3\" 
	\"rnd1\" (cons 0 points))"
bottomPosition "967";
fontList "*times-*-r-*-*-20-*";
labelString "Plot Random Points";
leftPosition "57";
rightPosition "480";
topPosition "877";
\end_figure\begin_figure {AtPlotter}
\figure_name "Plotter-5" 
\mapping "False"
bottomPosition "864";
leftPosition "496";
motionX "-10.239558";
motionY "59.155656";
rightPosition "930";
title "Y(x) = randomly damped sine wave";
topPosition "514";
xaxis.max "10";
xaxis.min "-10";
yaxis.label "Y(x)";
yaxis.max "5";
yaxis.min "-5";
\end_figure\begin_figure {XmPushButton}
\figure_name "Plotter-6" 
\mapping "False"
\callback "Activate" "(cds-plotter-xyplot \"$CDS_THIS_PAGE\" \"Plotter-5\" 
		    \"the-plot\" damped-sin -10 -3) "
bottomPosition "968";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Plot! ";
leftPosition "499";
plotter "xyplot";
rightPosition "854";
topPosition "878";
\end_figure\begin_figure {XmPushButton}
\figure_name "Click-Continue-Button" 
\mapping "True"
\callback "Activate" "
(set! Intro-Count (+ Intro-Count 1))
 (cond
     ((> Intro-Count 4)
      (cds-figure-hide \"$CDS_THIS_PAGE\" \"Click-Continue-Button\")
      (map cds-figure-show-fun 
	   (map 
	    (lambda (w)
	      (make-figure-name w \"Main\"))
	    Main-Topics)))
     (else
      (cds-figure-show \"$CDS_THIS_PAGE\"
	      (make-figure-name \"Intro\" (number->string Intro-Count)))
      (cds-figure-hide \"$CDS_THIS_PAGE\"
		       (make-figure-name \"Intro\"
                  (number->string (- Intro-Count 1))))))"
bottomPosition "989";
fontList "9x15bold";
labelString "Click Here with the Left
Button to Continue";
leftPosition "688";
rightPosition "987";
topPosition "894";
\end_figure\begin_figure {XmLabel}
\figure_name "Intro-4" 
\mapping "False"
borderWidth "0";
bottomPosition "848";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "
To learn more about Objects
select one to learn about from the list 
at the left, and click on it to continue...
";
leftPosition "288";
rightPosition "989";
topPosition "671";
\end_figure\begin_figure {XmLabel}
\figure_name "Intro-3" 
\mapping "False"
borderWidth "0";
bottomPosition "639";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "CDS uses a set of simple typesetters'
plates -- what we call
Graphical User Interface Objects.";
leftPosition "176";
rightPosition "879";
topPosition "416";
\end_figure\begin_figure {XmLabel}
\figure_name "Intro-2" 
\mapping "False"
borderWidth "0";
bottomPosition "384";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "How does one
CREATE
an interactive book?";
leftPosition "320";
rightPosition "880";
topPosition "160";
\end_figure\begin_figure {XmLabel}
\figure_name "Intro-1" 
\mapping "True"
borderWidth "0";
bottomPosition "140";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "CDS is like an interactive book...";
leftPosition "223";
rightPosition "814";
topPosition "30";
\end_figure\begin_figure {XmPushButton}
\figure_name "Reset-Button" 
\mapping "True"
\callback "Activate" "(set! Intro-Count 1)
(cds-figure-show \"$CDS_THIS_PAGE\" \"Intro-1\")
(cds-figure-show \"$CDS_THIS_PAGE\" \"Click-Continue-Button\")
(cds-figure-hide \"$CDS_THIS_PAGE\" \"Intro-4\")
(map cds-figure-hide-fun 
     (map 
      (lambda (w)
	(make-figure-name w \"Main\"))
      Main-Topics))"
bottomPosition "79";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "RESET!";
leftPosition "0";
rightPosition "176";
topPosition "0";
\end_figure\begin_figure {CmLabel}
\figure_name "Text-Tool-3" 
\mapping "False"
borderWidth "0";
bottomPosition "951";
fontSize "biggest";
label "@.
@^6[@c[@i[f]@-[@i[w]](@i[w]@-[0]) = @Int[From[@i[x]@-[0] = -@Infty]To[@Infty]]]@#@#@i[f]@-[@i[x]](@i[x]@-[0])@i[f]@-[@i[y]](@i[w]@-[0] - @i[x]@-[0])d@i[x]@-[0]]
@.
@.
@^6[@c[@i[f]@-[@i[w]](@i[w]@-[0]) = @Sum(From[@i[x]@-[0] = - @Infty]To[@Infty])@i[f](@i[x]@-[0]) * @i[f]@-[@i[y]](@i[w]@-[0] - @i[y]@-[0])]]
@.
@.
@.
@>[@^6[  ...for @i[w] = @i[x] + @i[y] and @i[x], @i[y] independent@#@#@#@#@#@#]]
@.";
leftPosition "124";
rightPosition "825";
topPosition "390";
\end_figure

\end_screen
\end_page
