#ifndef _CMMODELCONNECTION_H
#define _CMMODELCONNECTION_H

#include <CDS.h>

class CmModelConnection {
  FILE *io_stream;
  int master;
  XtInputId input_id;
  XtWorkProcId work_id;
  int child_pid;
  Boolean is_blocked;
  CmString connect_buffer;
  XtAppContext app_context;
  XtInputCallbackProc connection_callback;
  XtPointer connection_client_data;
public:
  CmModelConnection(const CmString &, XtAppContext);
  ~CmModelConnection();
  void AddInput(XtInputCallbackProc, XtPointer);
  int Read(char *, int);
  void Write(const CmString &);
  void SetEcho(Boolean);
  int SendSignal(int);
  void Interrupt();
  friend int
    CmModelConnectionWorkProc(CmModelConnection*);
  friend void
    CmModelConnectionCallback(CmModelConnection*, int *, XtInputId *);
};
#endif

