/* $Date: 91/12/13 15:27:55 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
/*********************************************************
 CmNavigator.cc - Navigator Code
 Contact: joe, maschaub
 *********************************************************/

#include <CmNavigatorHeap.h>
#include <CmPage.h>
#include <CmDialog.h>

/*************************************
 CmNavigatorHeap constructor
**************************************/
CmNavigatorHeap::CmNavigatorHeap() {
}

/*************************************
 CmNavigator destructor
**************************************/
CmNavigatorHeap::~CmNavigatorHeap() {
  ClearAllPages();
}


/*************************************
 CmNavigator AppendNewPage
  Adds a child to the current page and sets the current page to that new child
**************************************/
void CmNavigatorHeap::AppendPageToHeap(CmPage* new_page) {
  page_heap.Append(new_page);
}

/******************************************
 CmNavigator DestroyPage
 called when the destroy page button is pressed
 destoys the current page
 *****************************************/
void CmNavigatorHeap::DestroyPageInHeap(CmPage *new_page) {
  for (int i =0; i < page_heap.ListSize(); i++)
    if (page_heap[i] == new_page)
      page_heap.Remove(i);
  delete new_page;
}

/*************************************
 CmNavigatorHeap ClearAllPages
 Clears the page list
**************************************/
void CmNavigatorHeap::ClearAllPages() {
  const int number_of_pages_in_heap = page_heap.ListSize();
  for (int i=0; i<number_of_pages_in_heap; i++)
    delete (CmPage *) page_heap[i];
  page_heap.Clear();
}

/*************************************
CmNavigator GetPageByName
returns the page given the title
returns NULL if page not found
**************************************/
CmPage *CmNavigatorHeap::GetPageByName(const CmString & name) {
  const int num_pages = page_heap.ListSize();
  for (int i=0; i<num_pages; i++) 
    if ( ((CmPage *) page_heap[i])->Name == name )
      return((CmPage *) page_heap[i]);
  return(NULL);
}


/****************************************************************************
CmNavigator MakePageName
returns CmString of a unique page name
****************************************************************************/
CmString CmNavigatorHeap::MakePageName() {
  int counter = 0;
  CmString untitled_name;

  do
    untitled_name = form("untitled%d", counter++);
  while (GetPageByName(untitled_name));
  return untitled_name;
}

void CmNavigatorHeap::SetListOfHeap(CmDialog *dialog, 
				    const CmString &pane_name, 
				    const CmString &dialog_text) {
  const int list_size = page_heap.ListSize();
  for (int i = 0; i < list_size; i++)
    dialog->AddOption(pane_name, dialog_text, CMDIALOG_OPTION,
		      (XtArgVal) ((CmPage *) page_heap[i])->Name.Chars());
  if (list_size)
    dialog->AddOption(pane_name, dialog_text, CMDIALOG_VALUE,
		      (XtArgVal) ((CmPage *) page_heap[0])->Name.Chars());
  
}
  
/*************************************
 CmNavigator ostream
**************************************/
ostream& operator << (ostream &stream, CmNavigatorHeap *heap) {
  const int number_of_pages_in_heap = heap->page_heap.ListSize();

  for(int i=0; i< number_of_pages_in_heap; i++)
    stream << (CmPage *) heap->page_heap[i];

  return(stream);
}

