/* $Date: 91/12/13 10:13:23 $    $Revision: 1.1 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */
#include <CmParser.h>
# define U(x) x


 CmParser::CmParser() {
   yymorfg = 0;
   yychar = -1;
   yynerrs = 0;
   yyerrflag = 0;
   yylineno = 1;
   yyin = stdin;
   yyout = stdout;
   yysptr = yysbuf;
   yytext = new char[2000];
   yysbuf = new char[2000];
 }

CmParser::~CmParser() {
  delete yytext;
  delete yysbuf;
}

void CmParser::yyerror(char *error_string) {
   cerr << error_string;
   cerr << " in line ";
   cerr << yylineno;
   cerr << "\n";
 }

int CmParser::yywrap() {
  return(feof(yyin));
}

int CmParser::SetParserInput(FILE *file) {
  yyin = file;
  return (0);
}

int CmParser::SetParserOutput(FILE *file) {
  yyout = file;
  return (0);
}

int CmParser::yyback(int *p, int m) {
  if (p==0) return(0);
  while (*p) {
    if (*p++ == m)
      return(1);
  }
  return(0);
}

int CmParser::yyinput() {
  return(((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar);
}

void CmParser::yyoutput(int c) {
  putc(c, yyout);
}

void CmParser::yyunput(int c) {
  yytchar= (c);
  if(yytchar=='\n')
    yylineno--;
  *yysptr++=yytchar;
}




