/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/text/RCS/Label.c,v 3.1 91/01/03 17:54:32 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#include <stdio.h>
#include <X11/StringDefs.h>
#include <X11/IntrinsicP.h>
#include <X11/CoreP.h>

#ifdef _AtDevelopment_
#include "LabelP.h"
#include "AtConverters.h"    
#else
#include <At/LabelP.h>
#include <At/AtConverters.h>
#endif

static void Initialize();
static void Redisplay();
static void Resize();
static void Destroy();
static Boolean SetValues();
static void ClassInitialize();

#define offset(field) XtOffset(AtLabelWidget, label.field)

static XtResource resources[] = {
  {XtNlabelString, XtCLabelString, XtRString, sizeof(String),
     offset(label_string),
     XtRString, NULL},
  {XtNfontFamily, XtCFontFamily, XtRString, sizeof(String),
     offset(font_family),
     XtRString, "new century schoolbook"},
  {XtNfontSize, XtCFontSize, XtRFontSize, sizeof(int),
     offset(font_size),
     XtRImmediate, (caddr_t)AtFontNORMAL},
  {XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
     offset(foreground),
     XtRString, (caddr_t)XtDefaultForeground},
  {XtNhorizontalJustify, XtCHorizontalJustify, XtRAtJustify, sizeof(int),
     offset(horizontal_justify),
     XtRImmediate, (caddr_t)AtTextJUSTIFY_CENTER},
  {XtNverticalJustify, XtCVerticalJustify, XtRAtJustify, sizeof(int),
     offset(vertical_justify),
     XtRImmediate, (caddr_t)AtTextJUSTIFY_CENTER},
  {XtNrotate, XtCRotate, XtRBoolean, sizeof(Boolean),
     offset(rotate),
     XtRImmediate, (caddr_t)False},
  {XtNmarginWidth, XtCMarginWidth, XtRDimension, sizeof(Dimension),
     offset(margin_width), 
     XtRImmediate, (caddr_t) 4},
  {XtNmarginHeight, XtCMarginHeight, XtRDimension, sizeof(Dimension),
     offset(margin_height),
     XtRImmediate, (caddr_t) 4},
};


/****************************************************************
 *
 * Full class record constant
 *
 ****************************************************************/

AtLabelClassRec atLabelClassRec = {
  {
/* core_class fields */
    /* superclass               */      (WidgetClass) &widgetClassRec,
    /* class_name               */      "AtLabel",
    /* widget_size              */      sizeof(AtLabelRec),
    /* class_initialize         */      ClassInitialize,
    /* class_part_initialize    */      NULL,
    /* class_inited             */      FALSE,
    /* initialize               */      Initialize,
    /* initialize_hook          */      NULL,
    /* realize                  */      XtInheritRealize,
    /* actions                  */      NULL,
    /* num_actions              */      0,
    /* resources                */      resources,
    /* num_resources            */      XtNumber(resources),
    /* xrm_class                */      NULLQUARK,
    /* compress_motion          */      TRUE,
    /* compress_exposure        */      TRUE,
    /* compress_enterleave      */      TRUE,
    /* visible_interest         */      TRUE,
    /* destroy                  */      Destroy,
    /* resize                   */      Resize,
    /* expose                   */      Redisplay,
    /* set_values               */      SetValues,
    /* set_values_hook          */      NULL,
    /* set_values_almost        */      XtInheritSetValuesAlmost,
    /* get_values_hook          */      NULL,
    /* accept_focus             */      NULL,
    /* version                  */      XtVersion,
    /* callback_private         */      NULL,
    /* tm_table                 */      NULL,
    /* query_geometry           */      XtInheritQueryGeometry,
    /* display_accelerator      */      XtInheritDisplayAccelerator,
    /* extension                */      NULL,
  }
};

WidgetClass atLabelWidgetClass = (WidgetClass) &atLabelClassRec;


/*
 *******************
 * Initialize ()
 *******************
 */


static void Initialize (request, new)
     AtLabelWidget request, new;
{
  Dimension min_width, min_height;
  XGCValues values;
  XtGCMask  valueMask;

  if (new->label.label_string == NULL)
      new->label.label_string = XtNewString(new->core.name);
  else
      new->label.label_string = XtNewString(new->label.label_string);
  
  new->label.font_family = XtNewString(new->label.font_family);
  valueMask = GCForeground | GCBackground;
  values.foreground = new->label.foreground;
  values.background = new->core.background_pixel;
  new->label.label_gc = XtGetGC (new, valueMask, &values);
  new->label.family = AtFontFamilyGet (XtDisplay(new), new->label.font_family);
  new->label.formated_text = AtTextCreate (new->label.label_string,
					   new->label.family,
					   new->label.font_size);
  if (new->label.rotate)
    AtTextRotate (new->label.formated_text);

/* calculate ascent and descent of text */

  new->label.text_a = AtTextAscent (new->label.formated_text);
  new->label.text_d = AtTextDescent (new->label.formated_text);
  new->label.text_h = new->label.text_a + new->label.text_d; 

/* minimum acceptable width and height for widget */

  min_width = (new->label.text_w = AtTextWidth (new->label.formated_text)) + 
    (2 * new->label.margin_width);
  min_height = new->label.text_h + (2 * new->label.margin_height);

  if (request->core.width == 0)
    new->core.width = min_width;
  if (request->core.height == 0)
    new->core.height = min_height;

  Resize(new);
}

/*
 ************************
 * ClassInitialize ()
 ************************
 */
  
static void ClassInitialize()
{

/* Register converters */

   AtRegisterFontSizeConverter();
   AtRegisterJustifyConverter();
}


/*
 *******************
 * Resize ()
 *******************
 */

static void Resize (w)
     AtLabelWidget w;
{
  Position x1, y1; /* coordintes of upper left of the bounding box */ 
  Position x2, y2; /* coordintes of lower right of the bounding box */ 

  x1 = w->label.margin_width;
  y1 = w->label.margin_height;
  x2 = w->core.width - w->label.margin_width;
  y2 = w->core.height - w->label.margin_height;

  switch (w->label.horizontal_justify) {
  case AtTextJUSTIFY_LEFT: 
    w->label.x = x1;
    break;
  case AtTextJUSTIFY_RIGHT:
    w->label.x = x2 - w->label.text_w;
    break;
  case AtTextJUSTIFY_CENTER:
    w->label.x = (w->core.width - w->label.text_w) / 2;
    break;
  }
  switch (w->label.vertical_justify) {
  case AtTextJUSTIFY_TOP: 
    w->label.y = y1 + w->label.text_a;
    break;
  case AtTextJUSTIFY_BOTTOM:
    w->label.y = y2 - w->label.text_d;
    break;
  case AtTextJUSTIFY_CENTER:
    w->label.y = (w->core.height - w->label.text_h) / 2 + w->label.text_a;
    break;
  }
}



/*
 **********************
 * SetValues ()
 **********************
 */

static Boolean SetValues (current, request, new)
     AtLabelWidget current, request, new;
{
  XGCValues values;
  XtGCMask  valueMask;
  Boolean   string_changed = FALSE, family_changed = FALSE;
  Boolean   size_changed = FALSE;
  Boolean   Recal = FALSE; /* if true recalculte text_h, text_w, etc... */


  if (strcmp (new->label.label_string, current->label.label_string)) {
    XtFree(current->label.label_string);
    AtTextDestroy (new->label.formated_text);
    new->label.label_string = XtNewString(new->label.label_string);
    string_changed = TRUE;
  }
  if (strcasecmp (new->label.font_family, current->label.font_family)) {
    XtFree(current->label.font_family);
    AtFontFamilyRelease(new->label.family);
    new->label.font_family = XtNewString(new->label.font_family);
    new->label.family = AtFontFamilyGet (XtDisplay(new), new->label.font_family);
    family_changed = TRUE;
  }
  if (new->label.font_size != current->label.font_size)
    size_changed = TRUE;

  if (string_changed) {
    new->label.formated_text = AtTextCreate (new->label.label_string,
					     new->label.family,
					     new->label.font_size);
    if (new->label.rotate)
      AtTextRotate (new->label.formated_text);
    Recal = TRUE;
  }
  else if (family_changed || size_changed) {
    AtTextReformat (new->label.formated_text,
		    new->label.family,
		    new->label.font_size);
    Recal = TRUE;
  }

/* if text previously horizontal, now rotate 90 degrees */
  if ((new->label.rotate != current->label.rotate) && (new->label.rotate)) {
    if (!string_changed) { /* if changed, everything already set */
      AtTextRotate (new->label.formated_text);
      Recal = TRUE;
    }
  }

/* if text previously rotated, now set it back to normal */
  if ((new->label.rotate != current->label.rotate) && (!new->label.rotate)) 
    if (!string_changed) { /* if changed, everything is already set */
      AtTextDestroy (new->label.formated_text);
      new->label.formated_text = AtTextCreate (new->label.label_string,
					       new->label.family,
					       new->label.font_size);
      Recal = TRUE;
    }

  if (Recal) {
    /* recalculate ascent, descent, width, and height of text */

    new->label.text_a = AtTextAscent (new->label.formated_text);
    new->label.text_d = AtTextDescent (new->label.formated_text);
    new->label.text_h = new->label.text_a + new->label.text_d;
    new->label.text_w = AtTextWidth (new->label.formated_text);
  }

  if ((new->label.foreground != current->label.foreground) ||
      (new->core.background_pixel != current->core.background_pixel)) {
    valueMask = GCForeground | GCBackground;
    values.foreground = new->label.foreground;
    values.background = new->core.background_pixel;
    XtReleaseGC (new, new->label.label_gc);
    new->label.label_gc = XtGetGC (new, valueMask, &values);
  }
  if ((new->label.horizontal_justify != current->label.horizontal_justify) ||
      (new->label.vertical_justify != current->label.vertical_justify) ||
      (new->label.margin_width != current->label.margin_width) ||
      (new->label.margin_height != current->label.margin_height) ||
      (Recal))
    Resize (new);
    
  return (True); /* generate an expose event */
}


/*
 ********************
 * Redisplay ()
 ********************
 */

static void Redisplay (w, event, region)
     AtLabelWidget w;
     XEvent *event;
     Region region;
{
  if (w->core.visible) {
/*  XSetRegion (XtDisplay(w), w->label.label_gc, region); */
    AtTextDraw (XtDisplay (w), XtWindow (w), w->label.label_gc,
		  w->label.formated_text,
		  w->label.x, w->label.y);
  }
}


/*
 ******************
 * Destroy ()
 ******************
 */

static void Destroy (w)
     AtLabelWidget w;
{
  XtFree(w->label.label_string);
  XtFree(w->label.font_family);
  AtFontFamilyRelease(w->label.family);
  AtTextDestroy (w->label.formated_text);
  XtReleaseGC (w, w->label.label_gc);
}

