/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/Plotter.h,v 3.2 91/03/17 20:01:25 crcraig Exp Locker: dot $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtPlotter_h
#define _AtPlotter_h

#ifdef _AtDevelopment_
#include "Plot.h"
#include "Axis.h"    
#else
#include <At/Plot.h>
#include <At/Axis.h>    
#endif   
/* resource names and classes */
    
#define XtNtitle "title"
#define XtNlegendTitle "legendTitle"   
#define XtNfontFamily "fontFamily"
#define XtNtitleSize "titleSize"
#define XtNlegendTitleSize "legendTitleSize"    
#define XtNlegendSize "legendSize"
#define XtNtitleColor "titleColor"
#define XtNlegendColor "legendColor"
#define XtNautoScale "autoScale"
#define XtNforceSquare "forceSquare"
#define XtNforceAspect "forceAspecte"
#define XtNfloatingX "floatingX"
#define XtNfloatingY "floatingY"    
#define XtNframedAxes "framedAxes"
#define XtNshowLegend "showLegend"    
#define XtNlegendWidth "legendWidth"
#define XtNlegendSpacing "legendSpacing"
#define XtNmarginWidth "marginWidth"
#define XtNmarginHeight "marginHeight"
#define XtNrankChildren "rankChildren"
#define XtNdoubleClickInterval "doubleClickInterval"    
#define XtNmotionCallback "motionCallback"
#define XtNclickCallback "clickCallback"
#define XtNdragCallback "dragCallback"
#define XtNselectCallback "selectCallback"
#define XtNdoubleSelectCallback "doubleSelectCallback"    
#define XtNerrorCallback "errorCallback"
    
#define XtCTitle "Title"
#define XtCLegendTitle "LegendTitle"    
#define XtCFontFamily "FontFamily"
#define XtCFontSize "FontSize"    
#define XtCAutoScale "AutoScale"
#define XtCForceSquare "ForceSquare"
#define XtCForceAspect "ForceAspect"
#define XtCFloatingAxes "FloatingAxes"
#define XtCFramedAxes "FramedAxes"
#define XtCShowLegend "ShowLegend"    
#define XtCLegendWidth "LegendWidth"
#define XtCMargin "Margin"
#define XtCRankChildren "RankChildren"
#define XtCDoubleClickInterval "DoubleClickInterval"    

/* constraint resource names and classes */
#define XtNdisplayed "displayed"
#define XtNneedsRedraw "needsRedraw"
#define XtNneedsRefresh "needsRefresh"
#define XtNlegendName "legendName"
#define XtNuseY2Axis "useY2Axis"
#define XtNboundingBox "boundingBox"    
#define XtNrankOrder "rankOrder"

#define XtCDisplayed "Displayed"
#define XtCNeedsRedraw "NeedsRedraw"
#define XtCNeedsRefresh "NeedsRefresh"
#define XtCLegendName "LegendName"
#define XtCUseY2Axis "UseY2Axis"
#define XtCBoundingBox "BoundingBox"
#define XtCRankOrder "RankOrder"

/* Class record constants */

extern WidgetClass atPlotterWidgetClass;

typedef struct _AtPlotterClassRec * AtPlotterWidgetClass;
typedef struct _AtPlotterRec      * AtPlotterWidget;


/************************/
/*  Callback structures */
/************************/

/* The PointStruct is used for the call data on motion and point select
   callbacks. The RectangleStruct is used for the call data on the
   rectangle callback. */

typedef struct _PointStruct {
  short pixelx, pixely;
  double x,y,y2;
} PointStruct;

typedef PointStruct RectangleStruct[2];

/* Special Macros */
#define XtStrlen(s)  ((s)? strlen(s) : 0)

/* Public functions */
extern void AtPlotterLayout();
extern AtPlotWidget AtPlotterGetSelectedPlot(AtPlotterWidget);
extern AtPlotWidget AtPlotterGetLastPlot(AtPlotterWidget);
extern AtAxisObject AtPlotterGetXAxis(AtPlotterWidget);
extern AtAxisObject AtPlotterGetYAxis(AtPlotterWidget);
extern AtAxisObject AtPlotterGetY2Axis(AtPlotterWidget);
extern AtAxisObject AtPlotterGetXFrameAxis(AtPlotterWidget);
extern AtAxisObject AtPlotterGetYFrameAxis(AtPlotterWidget);
extern AtAxisObject AtPlotterGetY2FrameAxis(AtPlotterWidget);
void AtPlotterGetPlotExtents(AtPlotterWidget, int *, int *, int *, int *);
extern void AtPlotterGetAxisBounds(AtPlotterWidget, double*, double*,
				   double*, double*);
extern void AtPlotterGetAllAxisBounds(AtPlotterWidget, double*, double*,
				      double*, double*, double*, double*);
extern void AtPlotterSetAxisBounds(AtPlotterWidget, double, double,
				   double, double);
extern void AtPlotterSetAllAxisBounds(AtPlotterWidget, double, double,
				      double, double, double, double);
extern void AtPlotterRemoveAllPlots(AtPlotterWidget);
extern AtPlotWidget AtPlotterCheckHit(AtPlotterWidget, int, int);
void AtPlotterGeneratePostscript(char *,AtPlotterWidget, char *,
				 int, int, int, int, Boolean);
extern void AtPlotterDrawPS(FILE *, AtPlotterWidget, int, int, int, int);

#endif /* _AtPlotter_h */
/* DON'T ADD ANYTHING AFTER THIS #endif */

