/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/PlotterP.h,v 3.2 91/03/17 20:01:30 crcraig Exp Locker: crcraig $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _PlotterP_h
#define _PlotterP_h    

#include <X11/IntrinsicP.h>
#include <X11/ConstrainP.h>

#ifdef _AtDevelopment_
#include "AxisP.h"
#include "PlotP.h"    
#include "Plotter.h"    
#else
#include <At/AxisP.h>
#include <At/PlotP.h>  
#include <At/Plotter.h>
#endif

typedef struct ranking{ /* A private data structure */
  Widget child;
  int rank_order;
  struct ranking *prev;
  struct ranking *next;
} Rank;

typedef struct _AtPlotterPart {    
    /* resources */
    String fontFamily;
    String title;
    String legendTitle;
    int titleSize;
    int legendTitleSize;
    int legendSize;
    Pixel titleColor;
    Pixel legendColor;
    Boolean autoScale;
    Boolean forceSquare;
    Boolean forceAspect;
    Boolean floatingX;
    Boolean floatingY;
    Boolean framedAxes;
    Boolean showLegend;
    short legendWidth;
    short legendSpacing;
    short marginWidth;
    short marginHeight;
    Boolean rankChildren;
    int doubleClickInterval;
    XtCallbackList motionCallback;
    XtCallbackList clickCallback;
    XtCallbackList dragCallback;
    XtCallbackList selectCallback;
    XtCallbackList doubleSelectCallback;
    XtCallbackList errorCallback;

    /* 
     * Private widgets.  They are also managed children, numbered
     *  (in order) 0-5 
     */ 

    AtAxisObject xaxis;
    AtAxisObject yaxis;
    AtAxisObject y2axis;
    AtAxisObject xframeAxis;
    AtAxisObject yframeAxis;
    AtAxisObject y2frameAxis;

    /* private state */

    Rank *ordered_children;    /* rank ordered list of all children */
    Region clip_region;
    AtFontFamily *ff;
    GC titleGC, legendGC, dragGC;
    AtText *titleText;
    AtText *legendTitleText;
    struct {
	short x1, y1, x2, y2;                    /* the plotting area */
	short width, height;                     /* the size of same */
	short titleX, titleY;                    /* where the title goes */
	short legendX, legendY, legendHeight;    /* where the legend goes */
	/*
	 * x-axis length is x2 - x1.  x-axis drawn at (x1, y2)
	 * y-axis length is y2 - y1.  y-axis drawn at (x1, y2)
	 * y2-axis length is y2 - y1.  y2-axis drawn at (x2,y2)
	 */
    } layout;
    short selectionMode;
    Boolean dragging;
    short clickx, clicky, dragwidth, dragheight;
    Time lastclick;
    short legendItem;
    short legendItemY;
    struct {
	double xmin, xmax;
	double ymin, ymax;
	double y2min, y2max;
    } boundingBox;
    Boolean newBoundingBox;
} AtPlotterPart;

typedef struct _AtPlotterRec {
    CorePart core;
    CompositePart composite;
    ConstraintPart constraint;
    AtPlotterPart plotter;
} AtPlotterRec;

typedef struct _AtPlotterClassPart {
    int peek_a_boo;
} AtPlotterClassPart;

typedef struct _AtPlotterClassRec {
    CoreClassPart core_class;
    CompositeClassPart composite_class;
    ConstraintClassPart constraint_class;
    AtPlotterClassPart AtPlotter_class;
} AtPlotterClassRec;

extern AtPlotterClassRec atPlotterClassRec;


typedef struct _AtPlotterConstraintsPart {
    /* resources */
    Boolean displayed;
    Boolean needsRedraw;
    Boolean needsRefresh;
    String legendName;
    Boolean useY2Axis;
    BoundingBox boundingBox;
    int rankOrder;
    /* private state */
    AtText *legendText;
} AtPlotterConstraintsPart;

typedef struct {
    AtPlotterConstraintsPart plotter;
} AtPlotterConstraintsRec, *AtPlotterConstraints;


#define XtRBoundingBox "BoundingBox"

/* This is the number of children that are "private" children - we
   manage them so XtNameToWidget can process them! */
#define FIRST_PUBLIC_CHILD 6
#define CHILD_XAXIS 0
#define CHILD_YAXIS 1
#define CHILD_Y2AXIS 2
#define CHILD_XFRAMEAXIS 3
#define CHILD_YFRAMEAXIS 4
#define CHILD_Y2FRAMEAXIS 5

#endif
