\CDS_Version "b16"

\begin_outline
"title_page"
"introduction"
"newton_method_algorithm"
"newton_method_generalized"
"an_example_calculation"
"how_to_use_newton_method"
"finding_zeros"
\end_outline


\begin_page{newton_method_generalized}
\title{Newton's Method Generalized}
\begin_screen
\begin_figure {CmLabel}
\figure_name "untitled0_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "256";
fontSize "big";
label "(2)  y = f(x@-[@v1[0]]) + f'(x@-[@v1[0]])(x - x@-[@v1[0]])";
leftPosition "272";
rightPosition "752";
topPosition "192";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled0_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "176";
fontSize "big";
label "    To generalize Newton's method, remember that the equation for the tangent of a 
line at a point, x@-[@v1[0]], is:";
leftPosition "48";
rightPosition "960";
topPosition "48";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled0_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "448";
fontSize "big";
label "   At the x-intercept of the tangent, the value of y is zero.  If y=0 is used in (2) 
an equation for the next guess, x@-[@v1[1]] can be obtained.";
leftPosition "48";
rightPosition "960";
topPosition "272";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled0_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "528";
fontSize "big";
label "(3)  0 = f(x@-[@v1[0]]) + f'(x@-[@v1[0]])(x@-[@v1[1]] - x@-[@v1[0]])";
leftPosition "272";
rightPosition "752";
topPosition "464";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled0_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "656";
fontSize "big";
label "(4)  x@-[@v1[1]] = x@-[@v1[0]] - ";
leftPosition "272";
rightPosition "416";
topPosition "544";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled0_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "647";
fontSize "big";
label "@Over[Num[f(x@-[@v1[0]])] Denom[f'(x@-[@v1[0]])]]";
leftPosition "412";
rightPosition "466";
topPosition "541";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled0_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "736";
fontSize "big";
label "  Equation (4) can be generalized to obtain a formula for each subsequent guess,";
leftPosition "64";
rightPosition "960";
topPosition "640";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled0_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "851";
fontSize "big";
label "@Over[Num[f(x@-[@v1[n-1]])] Denom[f'(x@-[@v1[n-1]])]]";
leftPosition "436";
rightPosition "500";
topPosition "739";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled0_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "848";
fontSize "big";
label "(5)  x@-[@v1[n]] = x@-[@v1[n-1]] - ";
leftPosition "272";
rightPosition "432";
topPosition "752";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled0_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "960";
fontSize "big";
label "  This equation can be used to calculate the next guess in the process without 
drawing the tangent and determining its x-intercept.";
leftPosition "64";
rightPosition "960";
topPosition "848";
xFlag "left";
\end_figure

\end_screen
\end_page

\begin_page{title_page}
\title{Title Page}
\page_constructor_text "#!scheme
(load \"/mit/cdsdev/beta/config/cds.scheme\")"
\begin_screen

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
borderWidth "0";
bottomPosition "944";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Newton's Method?
Is that the recipe for ``fig newtons''?";
leftPosition "192";
rightPosition "848";
topPosition "512";
\end_figure

\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
borderWidth "0";
bottomPosition "496";
labelPixmap "mit-logo";
labelType "PIXMAP";
leftPosition "240";
rightPosition "768";
topPosition "64";
\end_figure
\end_screen
\end_page

\begin_page{introduction}
\title{Introduction}
\begin_screen
\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "256";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "  Newton's Method is an iterative procedure that finds a zero 
of a function.  In other words, it helps to solve the equation:";
leftPosition "48";
rightPosition "960";
topPosition "96";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
\mapping "True"
alignment "ALIGNMENT_BEGINNING";
borderWidth "0";
bottomPosition "397";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "(1) f ( x ) = 0";
leftPosition "191";
rightPosition "463";
topPosition "302";
\end_figure\begin_figure {XmLabel}
\figure_name "untitled1_XmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "592";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "A value, x, that satisfies (1) is called a zero of the function f.";
leftPosition "48";
rightPosition "960";
topPosition "432";
\end_figure\begin_figure {AtPlotter}
\figure_name "intro-plotee" 
\mapping "True"
\constructor_text "(define (intro-func x)
  (- (- (+ (* x x x) (* 2 x x)) x) 1))
(cds-plotter-xyplot \"$CDS_THIS_PAGE\" \"intro-plotee\" \"fofx\" intro-func -6 6)
"
autoScale "False";
bottomPosition "928";
clickX "-2.934498";
clickY "1.574468";
floatingX "True";
leftPosition "176";
motionX "-5.187773";
motionY "3.377778";
rightPosition "816";
title "f(x) = x@+[3] + 2x@+[2] - x - 1";
topPosition "640";
xaxis.max "6";
xaxis.min "-6";
yaxis.max "4";
yaxis.min "-2";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "795";
label "f(x)=0";
leftPosition "351";
rightPosition "404";
topPosition "756";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "844";
label "f(x)=0";
leftPosition "556";
rightPosition "609";
topPosition "806";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "794";
label "f(x)=0";
leftPosition "485";
rightPosition "536";
topPosition "756";
\end_figure

\end_screen
\end_page

\begin_page{newton_method_algorithm}
\title{The Newton's Method Algorithm}
\begin_screen
\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "992";
fontSize "big";
label "To find a zero of a function, f(x), follow these steps:   @.@.  1. Make a guess for a zero, x@-[@v1[0]].  @.@.  2. Evaluate f(x@-[@v1[0]]).  @.@.  3. If f(x@-[@v1[0]]) is close enough to zero, you made a lucky guess and you are done.  @.@.  4. If f(x@-[@v1[0]]) is not close enough, a tangent should be drawn from the point (x@-[@v1[0]], f(x@-[@v1[0]]) ).   @.      This tangent is a linear approximation to f(x).  @.@.  5.  Since the tangent is an approximation of f(x), the x-intercept is a solution @.       of f(x) = 0 ... approximately.  @.@.  6. To test the approximation, use the x-intercept of the tangent as the next guess, x@-[@v1[1]], @.      while using x@-[@v1[1]] in place of x@-[@v1[0]].";
leftPosition "48";
rightPosition "992";
topPosition "0";
xFlag "left";
\end_figure

\end_screen
\end_page

\begin_page{an_example_calculation}
\title{An Example Calculation Using Newton's Method}
\begin_screen
\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "128";
fontSize "big";
label "  Newton's Method often gives a numerical value for a zero of f(x) with excellent@.accuracy after only a few steps.";
leftPosition "48";
rightPosition "960";
topPosition "32";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "272";
fontSize "big";
label "  For example, a function could be f(x) = x@+[@v1[2]] + 2x - 4, the accuracy desired could@.be @PM 0.01, and an initial guess could be x@-[@v1[1]] = 2.";
leftPosition "48";
rightPosition "960";
topPosition "144";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "384";
fontSize "big";
label "  This evaluates to f(x@-[@v1[1]]) = 4.  This value is not close enough to zero. ";
leftPosition "48";
rightPosition "960";
topPosition "304";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "528";
fontSize "big";
label "  So the next step is to use equation (5) from the previous page to determine the@.next guess, x@-[@v1[2]] = 1.3333.";
leftPosition "48";
rightPosition "960";
topPosition "416";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "656";
fontSize "big";
label "  This evaluates to f(1.3333) = 0.4444.  This is still not close enough.";
leftPosition "48";
rightPosition "960";
topPosition "544";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "800";
fontSize "big";
label "  One step more gives a value for x@-[@v1[3]] = 0.9697.  This evaluates to f(0.9697) = .0091,@.which is within the desired accuracy for a zero of f(x).";
leftPosition "48";
rightPosition "960";
topPosition "688";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "944";
fontSize "big";
label "  The method gave a zero for f(x) in only three iterations.  OOOOOH!! AAAAAH!!";
leftPosition "48";
rightPosition "960";
topPosition "832";
xFlag "left";
\end_figure

\end_screen
\end_page

\begin_page{how_to_use_newton_method}
\title{How to Use Newton's Method in this Lecture}
\page_constructor_text "(define how-state 0)
(define (how-reset)
  (set! how-state 0)
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-scale-info\")
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-continue-1\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-continue-2\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-plotee\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-guess-slider\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-guess-slider-info\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-guess-value-label\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-guess-value-display\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-function-value-label\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-function-value-display\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-next-guess-value-label\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-next-guess-value-display\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-display-info\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-iterate\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-iterate-info\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-func-button-1\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-func-button-2\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-func-button-3\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-func-button-info\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-final-info\")
)
(how-reset)"
\begin_screen

\begin_figure {CmLabel}
\figure_name "untitled2_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "128";
fontSize "big";
label "  This screen shows how to use the interface of the next screen to use@.Newton's Method to solve for a zero of several functions.";
leftPosition "32";
rightPosition "784";
topPosition "32";
xFlag "left";
\end_figure\begin_figure {XmScale}
\figure_name "untitled2_XmScale0" 
\mapping "True"
borderWidth "0";
bottomPosition "656";
leftPosition "832";
rightPosition "912";
titleString "C_2";
topPosition "160";
value "83";
\end_figure\begin_figure {XmScale}
\figure_name "untitled2_XmScale0" 
\mapping "True"
borderWidth "0";
bottomPosition "656";
leftPosition "752";
rightPosition "832";
titleString "C_1";
topPosition "160";
value "72";
\end_figure\begin_figure {XmScale}
\figure_name "untitled2_XmScale0" 
\mapping "True"
borderWidth "0";
bottomPosition "656";
leftPosition "912";
rightPosition "992";
titleString "C_3";
topPosition "160";
value "63";
\end_figure\begin_figure {CmLabel}
\figure_name "how-scale-info" 
\mapping "True"
bottomPosition "976";
fontSize "big";
label "  These are scales.  They@.allow you to change the@.coefficients in the@.functions you will be@.viewing on the graph.@.Simply press and hold@.the left button on the@.scale to change its value.";
leftPosition "704";
rightPosition "992";
topPosition "640";
xFlag "left";
\end_figure\begin_figure {XmPushButton}
\figure_name "how-continue-1" 
\mapping "True"
\callback "Activate" "(define (how-step-1)
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-scale-info\")
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-plotee\")
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-guess-slider\")
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-guess-slider-info\")
  (set! how-state 1)
)
(define (how-step-2)
 (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-guess-slider-info\")
 (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-continue-1\")
 (cds-figure-show \"$CDS_THIS_PAGE\" \"how-guess-value-label\")
 (cds-figure-show \"$CDS_THIS_PAGE\" \"how-guess-value-display\")
 (cds-figure-show \"$CDS_THIS_PAGE\" \"how-function-value-label\")
 (cds-figure-show \"$CDS_THIS_PAGE\" \"how-function-value-display\")
 (cds-figure-show \"$CDS_THIS_PAGE\" \"how-next-guess-value-label\")
 (cds-figure-show \"$CDS_THIS_PAGE\" \"how-next-guess-value-display\")
 (cds-figure-show \"$CDS_THIS_PAGE\" \"how-display-info\")
 (cds-figure-show \"$CDS_THIS_PAGE\" \"how-continue-2\")
 (set! how-state 2)
)
(cond ((= how-state 0) (how-step-1))
               ((= how-state 1) (how-step-2))
)"
bottomPosition "960";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Continue ...";
leftPosition "16";
rightPosition "208";
topPosition "864";
\end_figure\begin_figure {XmPushButton}
\figure_name "untitled2_XmPushButton0" 
\mapping "True"
\callback "Activate" "(how-reset)"
bottomPosition "128";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Reset ...";
leftPosition "816";
rightPosition "992";
topPosition "32";
\end_figure\begin_figure {XmPushButton}
\figure_name "how-continue-2" 
\mapping "False"
\callback "Activate" "(define (how-step-3)
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-display-info\")
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-iterate\")
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-iterate-info\")
  (set! how-state 3)
)
(define (how-step-4)
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-iterate-info\")
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-func-button-1\")
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-func-button-2\")
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-func-button-3\")
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-func-button-info\")
  (set! how-state 4)
)(define (how-step-5)
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-func-button-info\")
  (cds-figure-hide \"$CDS_THIS_PAGE\" \"how-continue-2\")
  (cds-figure-show \"$CDS_THIS_PAGE\" \"how-final-info\")
  (set! how-state 5)
) 
(cond ((= how-state 2) (how-step-3))
               ((= how-state 3) (how-step-4))
               ((= how-state 4) (how-step-5))
)"
bottomPosition "960";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Continue ...";
leftPosition "784";
rightPosition "976";
topPosition "864";
\end_figure\begin_figure {XmScale}
\figure_name "how-guess-slider" 
\mapping "False"
\callback "Drag" "(set! x (slider-value \"how-guess-slider\"))
(plot-how-guess-line)"
\callback "Value Changed" "(plot-how-guess-line)"
bottomPosition "768";
decimalPoints "1";
leftPosition "224";
maximum "1000";
orientation "HORIZONTAL";
processingDirection "MAX_ON_RIGHT";
rightPosition "752";
topPosition "672";
value "285";
\end_figure\begin_figure {AtPlotter}
\figure_name "how-plotee" 
\mapping "False"
bottomPosition "640";
leftPosition "224";
rightPosition "752";
title "";
topPosition "160";
xaxis.max "100";
\end_figure\begin_figure {CmLabel}
\figure_name "how-guess-slider-info" 
\mapping "False"
bottomPosition "912";
fontSize "big";
label "This scale allows you to input a guess@. for a zero.  As you change the value,@.the vertical line will move.";
leftPosition "528";
rightPosition "944";
topPosition "736";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "how-guess-value-label" 
\mapping "False"
borderWidth "0";
bottomPosition "256";
fontSize "big";
label "Guess Value:";
leftPosition "0";
rightPosition "192";
topPosition "160";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "how-function-value-label" 
\mapping "False"
borderWidth "0";
bottomPosition "432";
fontSize "big";
label "Function Value:";
leftPosition "0";
rightPosition "192";
topPosition "336";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "how-next-guess-value-label" 
\mapping "False"
borderWidth "0";
bottomPosition "608";
fontSize "big";
label "Next Guess Value:";
leftPosition "0";
rightPosition "208";
topPosition "512";
xFlag "left";
\end_figure\begin_figure {XmLabel}
\figure_name "how-guess-value-display" 
\mapping "False"
bottomPosition "336";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "0.0000";
leftPosition "16";
rightPosition "208";
topPosition "240";
\end_figure\begin_figure {XmLabel}
\figure_name "how-next-guess-value-display" 
\mapping "False"
bottomPosition "688";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "0.0000";
leftPosition "16";
rightPosition "208";
topPosition "592";
\end_figure\begin_figure {XmLabel}
\figure_name "how-function-value-display" 
\mapping "False"
bottomPosition "512";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "0.0000";
leftPosition "16";
rightPosition "208";
topPosition "416";
\end_figure\begin_figure {CmLabel}
\figure_name "how-display-info" 
\mapping "False"
bottomPosition "912";
fontSize "big";
label " These will display the values of the@.current guess value, function value,@.and next-guess-value.";
leftPosition "16";
rightPosition "416";
topPosition "720";
xFlag "left";
\end_figure\begin_figure {XmPushButton}
\figure_name "how-iterate" 
\mapping "False"
bottomPosition "928";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "Iterate";
leftPosition "496";
rightPosition "688";
topPosition "816";
\end_figure\begin_figure {CmLabel}
\figure_name "how-iterate-info" 
\mapping "False"
bottomPosition "816";
fontSize "big";
label "  This \"Iterate\"' button will allow you@.to determine the next guess for an@.initial guess which you have input@.with the slider below the graph.";
leftPosition "272";
rightPosition "688";
topPosition "576";
xFlag "left";
\end_figure\begin_figure {XmPushButton}
\figure_name "how-func-button-1" 
\mapping "False"
alignment "ALIGNMENT_BEGINNING";
bottomPosition "832";
fontList "*helvetica-medium-r-*-240-*-p-*";
labelString "  f(x) = a*x^2 + b*x - c";
leftPosition "16";
rightPosition "320";
topPosition "784";
\end_figure\begin_figure {XmPushButton}
\figure_name "how-func-button-2" 
\mapping "False"
alignment "ALIGNMENT_BEGINNING";
bottomPosition "896";
fontList "*helvetica-medium-r-*-240-*-p-*";
labelString "  f(x) = a*sin(b*x) * cos(c*x)";
leftPosition "16";
rightPosition "320";
topPosition "848";
\end_figure\begin_figure {XmPushButton}
\figure_name "how-func-button-3" 
\mapping "False"
alignment "ALIGNMENT_BEGINNING";
bottomPosition "960";
fontList "*helvetica-medium-r-*-240-*-p-*";
labelString "  f(x) = | a*ln x |- b*x + c";
leftPosition "16";
rightPosition "320";
topPosition "912";
\end_figure\begin_figure {CmLabel}
\figure_name "how-func-button-info" 
\mapping "False"
bottomPosition "912";
fontSize "big";
label "  These buttons will allow you to@.change the function you are@.working with on the graph.";
leftPosition "336";
rightPosition "720";
topPosition "736";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "how-final-info" 
\mapping "False"
bottomPosition "720";
fontSize "big";
label "  Proceed to the next screen@.to use Newton's Method.@.@.  If you wish to repeat the help,@.press the ``Reset ...'' button@.in the upper right corner.";
leftPosition "560";
rightPosition "944";
topPosition "384";
xFlag "left";
\end_figure
\end_screen
\end_page

\begin_page{finding_zeros}
\title{Use Newton's Method to Find the Zeros of Functions}
\page_constructor_text "(define x 0)
(define delta_x .00001)
(define (deriv f x)
	(/ (- (f (+ x delta_x)) (f x)) delta_x))
(define (plot-line line-name list)
  (cds-plotter-xyplot-points \"$CDS_THIS_PAGE\" \"use-plotee\" line-name list))

(define (draw-lines)
	(plot-line \"curr-line\" (list (list x 0) (list x (f x))))
	(plot-line \"slope-line\" (list (list x (f x)) (list (next-val f x) 0)))
	(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"guess-value\" \"labelString\" (number->fstring \"%f\" x))
	(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"function-value\" \"labelString\" (number->fstring \"%f\" (f x)))
	(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"next-value\" \"labelString\" (number->fstring \"%f\" (next-val f x))))

(define (next-val f x)
	(- x (/ (f x) (deriv f x))))

(define (draw-func max min)
	(cds-plotter-xyplot \"$CDS_THIS_PAGE\" \"use-plotee\" \"use-func-plot\" f max min))

(define (undraw-func)
	(cds-plotter-delete-plot \"$CDS_THIS_PAGE\" \"use-plotee\" \"use-func-plot\"))

(define (f x) (+ (* a (* x x)) (* b x) c))

(define a (/ ${a:value} (expt 10 ${a:decimalPoints})))

(define b (/ ${b:value} (expt 10 ${b:decimalPoints})))

(define c (/ ${c:value} (expt 10 ${c:decimalPoints})))

(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"use-plotee\" \"title\" \"\\"${use-func-button-1:labelString}\\"\")

(cds-plotter-axis \"$CDS_THIS_PAGE\" \"use-plotee\" -10 10 -10 10)

(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"a\" \"value\" (floor (* a (expt 10 ${a:decimalPoints}))))

(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"b\" \"value\" (floor (* b (expt 10 ${b:decimalPoints}))))

(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"c\" \"value\" (floor (* c (expt 10 ${c:decimalPoints}))))

(draw-func ${use-plotee:xaxis.min} ${use-plotee:xaxis.max})

(draw-lines)"
\begin_screen
\begin_figure {XmScale}
\figure_name "b" 
\mapping "True"
\callback "Value Changed" "(set! b (/ ${b:value} (expt 10 ${b:decimalPoints})))
(draw-func ${use-plotee:xaxis.min} ${use-plotee:xaxis.max})
(draw-lines)"
borderWidth "0";
bottomPosition "656";
decimalPoints "1";
leftPosition "832";
minimum "-100";
rightPosition "912";
titleString "b";
topPosition "16";
value "8";
\end_figure\begin_figure {XmScale}
\figure_name "a" 
\mapping "True"
\callback "Value Changed" "(set! a (/ ${a:value} (expt 10 ${a:decimalPoints})))
(draw-func ${use-plotee:xaxis.min} ${use-plotee:xaxis.max})
(draw-lines)"
borderWidth "0";
bottomPosition "656";
decimalPoints "1";
leftPosition "752";
maximum "50";
minimum "-50";
rightPosition "832";
titleString "a";
topPosition "16";
value "-2";
\end_figure\begin_figure {XmScale}
\figure_name "c" 
\mapping "True"
\callback "Value Changed" "(set! c (/ ${c:value} (expt 10 ${c:decimalPoints})))
(draw-func ${use-plotee:xaxis.min} ${use-plotee:xaxis.max})
(draw-lines)"
borderWidth "0";
bottomPosition "656";
decimalPoints "1";
leftPosition "912";
minimum "-100";
rightPosition "992";
titleString "c";
topPosition "16";
value "7";
\end_figure\begin_figure {AtPlotter}
\figure_name "use-plotee" 
\mapping "True"
\callback "Click" "(set! x ${use-plotee:clickX})
(draw-lines)"
\callback "Drag" "(undraw-func)
(draw-func ${use-plotee:xaxis.min} ${use-plotee:xaxis.max})
(draw-lines)"
autoScale "False";
bottomPosition "636";
clickX "2.469438";
clickY "0.355030";
floatingX "True";
floatingY "True";
leftPosition "222";
motionX "-2.224939";
motionY "8.875740";
rightPosition "750";
title "  f(x) = a*x^2 + b*x + c";
topPosition "14";
xaxis.max "10";
xaxis.min "-10";
yaxis.max "10";
yaxis.min "-10";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "112";
fontSize "big";
label "Guess Value:";
leftPosition "0";
rightPosition "192";
topPosition "16";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "304";
fontSize "big";
label "Function Value:";
leftPosition "0";
rightPosition "192";
topPosition "208";
xFlag "left";
\end_figure\begin_figure {CmLabel}
\figure_name "untitled1_CmLabel0" 
\mapping "True"
borderWidth "0";
bottomPosition "480";
fontSize "big";
label "Next Guess Value:";
leftPosition "0";
rightPosition "208";
topPosition "384";
xFlag "left";
\end_figure\begin_figure {XmLabel}
\figure_name "guess-value" 
\mapping "True"
bottomPosition "192";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "2.469438";
leftPosition "16";
rightPosition "208";
topPosition "96";
\end_figure\begin_figure {XmLabel}
\figure_name "next-value" 
\mapping "True"
bottomPosition "560";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "10.222912";
leftPosition "16";
rightPosition "208";
topPosition "464";
\end_figure\begin_figure {XmLabel}
\figure_name "function-value" 
\mapping "True"
bottomPosition "368";
fontList "*bitstream-charter-medium-r-*-33-*-p-*";
labelString "1.455926";
leftPosition "16";
rightPosition "208";
topPosition "288";
\end_figure\begin_figure {XmPushButton}
\figure_name "untitled1_XmPushButton0" 
\mapping "True"
\callback "Activate" "(set! x (next-val f x))
(draw-lines)"
bottomPosition "852";
fontList "*helvetica-*-r-*-*-24-*";
labelString "Iterate";
leftPosition "376";
rightPosition "568";
topPosition "742";
\end_figure\begin_figure {XmPushButton}
\figure_name "use-func-button-1" 
\mapping "True"
\callback "Activate" "(define (f x) (+ (* a (* x x)) (* b x) c))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"use-plotee\" \"title\" \"\\"${use-func-button-1:labelString}\\"\")
(draw-func ${use-plotee:xaxis.min} ${use-plotee:xaxis.max})
(draw-lines)"
alignment "ALIGNMENT_BEGINNING";
bottomPosition "832";
fontList "*helvetica-medium-r-*-240-*-p-*";
labelString "  f(x) = a*x^2 + b*x + c";
leftPosition "16";
rightPosition "304";
topPosition "784";
\end_figure\begin_figure {XmPushButton}
\figure_name "use-func-button-2" 
\mapping "True"
\callback "Activate" "(define (f x) (* a (+ (sin (* b x)) (cos (* c x))))) 
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"use-plotee\" \"title\" \"\\"${use-func-button-2:labelString}\\"\")
(draw-func ${use-plotee:xaxis.min} ${use-plotee:xaxis.max})
(draw-lines)"
alignment "ALIGNMENT_BEGINNING";
bottomPosition "896";
fontList "*helvetica-medium-r-*-240-*-p-*";
labelString "  f(x) = a*sin(b*x) + cos(c*x)";
leftPosition "16";
rightPosition "304";
topPosition "848";
\end_figure\begin_figure {XmPushButton}
\figure_name "use-func-button-3" 
\mapping "True"
\callback "Activate" "(define (f x) (+ (* a (log (abs x))) (* b x) c))
(cds-figure-set-resource \"$CDS_THIS_PAGE\" \"use-plotee\" \"title\" \"\\"${use-func-button-3:labelString}\\"\")
(draw-func ${use-plotee:xaxis.min} ${use-plotee:xaxis.max})
(draw-lines)"
alignment "ALIGNMENT_BEGINNING";
bottomPosition "955";
fontList "*helvetica-medium-r-*-240-*-p-*";
labelString "  f(x) = a*ln | x |- b*x + c";
leftPosition "14";
rightPosition "304";
topPosition "909";
\end_figure\begin_figure {XmPushButton}
\figure_name "untitled1_XmPushButton0" 
\mapping "True"
\callback "Activate" "(cds-plotter-axis \"$CDS_THIS_PAGE\" \"use-plotee\" -10 10 -10 10)
(draw-func -10 10)
(draw-lines)"
bottomPosition "942";
fontList "*helvetica-*-r-*-*-24-*";
labelString "Reset Axes";
leftPosition "640";
rightPosition "927";
topPosition "831";
\end_figure\begin_figure {XmPushButton}
\figure_name "untitled" 
\mapping "True"
\callback "Activate" "(define window-size (- ${use-plotee:xaxis.max} ${use-plotee:xaxis.min}))
(cds-plotter-delete-plot \"$CDS_THIS_PAGE\" \"use-plotee\" \"use-func-plot\")
(cds-plotter-axis \"$CDS_THIS_PAGE\" \"use-plotee\" 
	(- x (/ window-size 2)) (+ x (/ window-size 2)) 
        ${use-plotee:yaxis.min} ${use-plotee:yaxis.max})
(draw-func (- x (/ window-size 2)) (+ x (/ window-size 2)))
(draw-lines)"
bottomPosition "823";
fontList "*helvetica-*-r-*-*-24-*";
labelString "Center Graph at 
Current Guess";
leftPosition "640";
rightPosition "922";
topPosition "725";
\end_figure

\end_screen
\end_page
