;;; Get floating point number between 0 and 1

(define (frand)
  (/ (random) (1- (expt 2 31))))

;;; Get list of n zeros

(define (zeros n)
  (if (< n 1)
      '()
      (cons 0 (zeros (1- n)))))

;;; Print division returns "infinity" if b is zero
(define (p/ a b)
  (if (= b 0)
      "infinity"
      (/ a b)))

(define (geometric probability num_elements)
  (append '(0.0) (recurse-geometric probability (1- num_elements) probability))
)

(define (recurse-geometric probability num_elements running_total)
  (if (> num_elements 0)
      (cons running_total
	      (recurse-geometric probability (1- num_elements)
				 (* running_total probability)))
      '()))


