/* $Date: 92/01/26 22:56:16 $    $Revision: 1.2 $  by $Author: joe $  */
/* 
  Copyright (C) 1991 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

  */

/***************************************************************************
  CmFigure.cc -  Widget wrapper
  Contact: joe, maschaub
****************************************************************************/

#include<CDS.h>
#include<CmCDS.h>
#include<CmModel.h>
#include<CmFigure.h>
#include<CmFigureClass.h>
#include<CmFigureEditor.h>
#include<Xm/Form.h>

#include<X11/StringDefs.h>


struct CmFigureResource {
  CmString name;
  CmString value;
};

struct CmFigureCallback {
  CmFigure *Figure;
  CmString CallbackText;
  CmString Callback;
  CmString CallbackString;
};

static void CmFigureSendCallbacks(Widget, 
			    CmFigureCallback* callback, 
			    XtPointer call_data) {
  callback->Figure->SendCallbacks(callback, call_data); 
}

static const CmRegex WhiteSpace("[ \n\t\r\v\f]*", 1);

/*************************
 CmFigure Constructor
  Called by CmFigureResistrar
  Copies parameters to local variables
*************************/
CmFigure::CmFigure(CmFigure*   parent_cm_widget, 
		   const CmString  &name_string, 
		   CmFigureClass*  wc, 
		   CmCDS*  cdsptr) {
   Name = name_string;
   parent = parent_cm_widget;
   widget_parent = NULL;
   widget = NULL;
   cmfigure_class = wc;
   cds_ptr = cdsptr;
   use_default_parent = True;
   if(parent_cm_widget)
     parent_cm_widget->children.Append(this);
   
   get_default_resources(wc);
   // Add callbacks to callback list
   for (int i = 0; i < wc->NumCallbacks(); i++) {
     CmFigureCallback *callback = new CmFigureCallback;
     callbacks.Append(callback);
     callback->Figure = this;
     callback->CallbackText = wc->CallbackName(i);
     callback->Callback = wc->Callback(i);
  }
}

/*************************
CmFigure consructor
  Copies parameters to local variables
*************************/
CmFigure::CmFigure( Widget parent_widget, const CmString & name_string, 
		   CmFigureClass*  wc, CmCDS*  cdsptr) {
  Name = name_string;
  widget_parent = parent_widget;
  parent = NULL;
  cmfigure_class = wc;
  cds_ptr = cdsptr;
  use_default_parent = True;
  widget = NULL;

  get_default_resources(wc);
  
  // Add callbacks to callback list
  for (int i = 0; i < wc->NumCallbacks(); i++) {
    CmFigureCallback *callback =  new CmFigureCallback;
    callbacks.Append(callback);
    callback->Figure = this;
    callback->CallbackText = wc->CallbackName(i);
    callback->Callback = wc->Callback(i);
  }
}

/****************************************************************************
  CmFigure Copier
  Copies itself, returns a brand new pointer and copy of itself
****************************************************************************/
CmFigure* CmFigure::Copy(const CmString & node_name, 
			 CmFigure *parent) {
  CmFigure *  new_CmFigure = new CmFigure(parent, "untitled",
					  cmfigure_class,cds_ptr);


  // copy resources
  for (int i = 0; i < NumberOfResources(); i++ )
    new_CmFigure->ChangeResource(get_resource(i)->name, 
				 get_resource(i)->value);
  // copy scheme text
  for (i = 0; i < callbacks.ListSize(); i++) { 
    CmFigureCallback *callback = (CmFigureCallback *) callbacks[i];
    new_CmFigure->ChangeCallback(callback->CallbackText, 
				 callback->CallbackString);
  }
  
  // copy children
  for (i = 0; i < children.ListSize(); i++)
    ((CmFigure *)children[i])->Copy(node_name, new_CmFigure);

  return new_CmFigure;
}

/*************************
 CmFigure Destructor
   Kills all the children
*************************/
CmFigure::~CmFigure() {
  for (int i=0; i < children.ListSize(); i++)
    delete (CmFigure *) children[i];

  for (i=0; i < resources.ListSize(); i++)
    delete (CmFigureResource *) resources[i];

  for (i=0; i < callbacks.ListSize(); i++)
    delete (CmFigureCallback *)  callbacks[i];

  if (widget)
    XtDestroyWidget(widget);
}


void CmFigure::SetIsMapped( CmBool map ) { 
  ChangeResource("mappedWhenManaged", map ? "True" : "False");
}

/*************************
 CmFigure AddCallback
 *************************/
void CmFigure::ChangeCallback(const CmString & cbtext,  
			      const CmString & text) {
  for (int i = 0; i < callbacks.ListSize(); i++ ) {
    CmFigureCallback *  callback = (CmFigureCallback *) callbacks[i];
    if (callback->CallbackText == cbtext)
      callback->CallbackString = text;
  }
}

/*************************
 CmFigure SendCallbacks
 *************************/
void CmFigure::SendCallbacks(CmFigureCallback *callback, 
			     XtPointer call_data) {
  if (cmfigure_class->UpdateCallbackProc)
    (* (cmfigure_class->UpdateCallbackProc))(this, callback->Callback,
					     call_data);

  if (!callback->CallbackString.Matches(WhiteSpace))
    cds_ptr->Model()->Evaluate(callback->CallbackString);
}


/*************************
 CmFigure GetCallbackString
 *************************/
CmString CmFigure::GetCallbackString(const CmString &callback_text ) {
  for (int i = 0; i < callbacks.ListSize(); i++ ) {
    CmFigureCallback *  callback = (CmFigureCallback *) callbacks[i];
    if ( callback->CallbackText == callback_text )
      return(callback->CallbackString);
  }
  return("");
}

static int counter = 0;

#define MAX_NUM_QUARKS 10

/*************************
 CmFigure Widgetize
  Called by CmFigureRegistrar
  Calls change_resources
  Redraw all widgets by creating new widgets and destroying the old ones.
**************************/
void CmFigure::Widgetize() {
  if (widget)
    XtDestroyWidget(widget);

  Widget child = widgetize();
  if (child)
    XtManageChild(child);
}

Widget CmFigure::widgetize()  {
  XrmBinding bindings[MAX_NUM_QUARKS];
  XrmQuark quarks[MAX_NUM_QUARKS];
  
  Widget widget_parent_of_this = 
    widget_parent ? widget_parent : parent->widget;

  XrmDatabase database = XtDatabase(XtDisplay(widget_parent_of_this));

  CmString widget_name = "CDS_widget_";
  widget_name += form("%d", counter);

  XrmStringToBindingQuarkList(widget_name, bindings, quarks);
  bindings[0] = XrmBindLoosely;

  int num_quarks = 0;
  
  while (quarks[num_quarks] != 0)
    num_quarks++;
  if (num_quarks > MAX_NUM_QUARKS -3) {
    cerr << "Uh! Oh! MAX_NUM_QUARKS in CmFigure.cc exceeded";
    return NULL;
  }

  const int num_resources = resources.ListSize();
  for (int i = 0; i < num_resources; i++) {
    CmFigureResource *resource = (CmFigureResource *) resources[i];
    if (resource->value != "XtDefaultValue") {
// This is a hack to append the resource in back of the widget name
      XrmStringToBindingQuarkList(resource->name.Chars(), 
				  bindings + num_quarks,
				  quarks + num_quarks);
      XrmQPutStringResource(&database, bindings, quarks, 
			    resource->value.Chars());
    }
  }

  counter++;

  widget = XtVaCreateWidget(widget_name.Chars(),
			    cmfigure_class->GetWidgetClass(), 
			    widget_parent_of_this,
			    XmNleftAttachment, XmATTACH_POSITION,
			    XmNtopAttachment, XmATTACH_POSITION,
			    XmNrightAttachment, XmATTACH_POSITION,
			    XmNbottomAttachment, XmATTACH_POSITION, NULL);

  WidgetList manage_list = new Widget[children.ListSize()];
  Cardinal manage_count = 0;
  for (i=0; i< children.ListSize(); i++) {
    Widget child = ((CmFigure *) children[i])->widgetize(); 
    if (child)
      manage_list[manage_count++] = child;
  }

  if (manage_count)
    XtManageChildren(manage_list, manage_count);
  delete manage_list;

  // add callbacks to new widget
  for ( i = 0; i < callbacks.ListSize(); i++ ) {
    CmFigureCallback *callback = (CmFigureCallback *) callbacks[i];
    XtAddCallback(widget, callback->Callback.Chars(), 
		  (XtCallbackProc)CmFigureSendCallbacks, 
		  (XtPointer) callback);
  }

  // add event handler
  if (XtClass(widget) != xmFormWidgetClass)
    XtAddEventHandler(widget,  ButtonPressMask | ButtonReleaseMask | 
		      ButtonMotionMask, 0, 
		      (XtEventHandler) CmFigureActivated, 
		      (XtPointer) cds_ptr->Editor());
  return(widget);
}

/*************************
 CmFigure GetResource
  Gets the value of a certain resource
**************************/
CmString CmFigure::GetResource(const CmString &tok) {
  int low = 0;
  int high = NumberOfResources() -1;
  while (low <= high) {
    int mid = (low+high)/2;
    if (tok < get_resource(mid)->name)
      high = mid-1;
    else if (tok > get_resource(mid)->name)
      low = mid+1;
    else
      return (get_resource(mid)->value);
  }
  return("");
}

/*************************
 CmFigure ChangeResource 
  Changes the value of a certain resource
**************************/
void CmFigure::ChangeResource(const CmString &name,  
			      const CmString &value) {

  const int num_resources = resources.ListSize();
 
  for (int i =0; i < num_resources; i++)
    if (name == get_resource(i)->name) {
      get_resource(i)->value = value;
      return;
    } else if (name < get_resource(i)->name) {
      CmFigureResource *  resource = new CmFigureResource;
      resource->name = name;
      resource->value = value;
      resources.Insert(resource, i);
      return;
    }

  CmFigureResource *  resource = new CmFigureResource;
  resource->name = name;
  resource->value = value;
  resources.Append(resource);
}

/*************************
 CmFigure DeleteResource
  Uses the command free to remove an resource from the array
**************************/
void CmFigure::DeleteResource(const CmString &name) {
  int low = 0;
  int high = NumberOfResources() -1;
  while (low <= high) {
    int mid = (low+high)/2;
    if (name < get_resource(mid)->name)
      high = mid-1;
    else if (name > get_resource(mid)->name)
      low = mid+1;
    else
      resources.Remove(mid);
  }
}

/*************************
 CmFigure SetParent
  Gets the name and widget of the parent of the CmFigure
**************************/
void CmFigure::SetParent(CmFigure *reference, 
			 const CmString & parent_name) {
  CmFigure *new_parent = reference->NameToCmFigure(parent_name);
  if (!new_parent)
    SetParent(reference->NameToCmFigure(parent_name));
  else
    cerr << "CmFigure::SetParent could not find widget " << parent_name
         << "\n";
}


/*************************
 CmFigure SetParent
  Gets the name and widget of the parent of the CmFigure
**************************/
void CmFigure::SetParent(CmFigure *  parent_cm_widget) {
  use_default_parent = False;
  parent->remove_child_from_list(this);
  parent = parent_cm_widget;
  parent->children.Append(this);
}


/*************************
 CmFigure GetResources
  called by CreateWidget
  gets the default values of the widget and puts them into the resources
**************************/
void CmFigure::get_default_resources(CmFigureClass*  wc) {
  // get defaults for each resource
  if (wc->SuperCmClass())
    get_default_resources(wc->SuperCmClass());

  for (int i= 0; i < wc->NumberOfResources(); i++)
    ChangeResource(wc->Resource(i), wc->Default(i));
}

/*************************
 CmFigure NumCmFigures
**************************/
int CmFigure::NumCmFigures() { return(children.ListSize()); }

/*************************
 CmFigure GetCmFigure
**************************/
CmFigure* CmFigure::GetCmFigure(int i) { return((CmFigure*)children[i]); }

/*************************
 CmFigure AddCmFigure
  Calls add_child and widgetizes the child
**************************/
void CmFigure::AddCmFigure(CmFigure*  cw) {
  if ( ! cw ) return;
  children.Append(cw);
  cw->Widgetize();
}

/*************************
 CmFigure RemoveCmFigure 
  Deletes, unmaps and unmanages the child
**************************/
void CmFigure::RemoveCmFigure(CmFigure*  cw) {  
  if (cw) {
    remove_child_from_list(cw);
    delete cw;
  }
    cmdebug << "Removed child.\n";
}

void CmFigure::remove_child_from_list(CmFigure *  cw) {
  for (int i=0; i<children.ListSize(); i++) {
    if (children[i] == cw) {
      children.Remove(i);
      break;
    }
  }
}

/*************************
 CmFigure NameToCmFigure
  Converts the name of a widget to a CmFigure
**************************/
CmFigure *CmFigure::NameToCmFigure(const CmString & string) {
  if ( string == Name )
    return(this);
  
  for (int i=0; i<children.ListSize(); i++) {
    CmFigure * cm_widget = 
      ((CmFigure *) children[i])->NameToCmFigure(string);
    
    if (cm_widget)
      return(cm_widget); 
  }
  return((CmFigure *) NULL);
}

/*************************
 CmFigure WidgetToCmFigure
  Converts the widget to a Widget
**************************/
CmFigure *CmFigure::WidgetToCmFigure( Widget w) {
  if (w == widget)
    return(this);
  
  for (int i=0; i<children.ListSize(); i++) {
    CmFigure *cm_widget = 
      ((CmFigure *) children[i])->WidgetToCmFigure(w);

    if (cm_widget)
      return(cm_widget); 
  }
  return((CmFigure *) NULL);
}


/*************************
 CmFigure Map
  Uses XtMapWidget to map the widget
**************************/
void CmFigure::Map() {
  if (widget && XtIsRealized(widget))
    XtMapWidget(widget);
}

/*************************
 CmFigure UnMap
  Uses XtUnMapWidget to unmap the widget
*************************/
void CmFigure::Unmap() { 
  if (widget && XtIsRealized(widget))
    XtUnmapWidget(widget);
}

/*************************
 CmFigure Show
  Displays itself and all children
**************************/
void CmFigure::Show() { 
  Map();
  if (widget && XtIsRealized(widget))
    XRaiseWindow(XtDisplay(widget), XtWindow(widget));
 
  for (int i=0; i<children.ListSize(); i++)
    ((CmFigure *) children[i])->Show();
}

/*************************
 CmFigure Hide
  Hides itself and all children
**************************/
void CmFigure::Hide() { 
  Unmap();
  for (int i=0; i<children.ListSize(); i++)
    ((CmFigure *) children[i])->Hide();
}

/***************************
 Quotify - changes quotes to backslash quotes
****************************/

static inline CmString Quotify (CmString string) {
  string.Gsub("\"", "\\\"");
  return string;
}

/****************************************************************************
  CmFigure GetCmFigureDefinition
    Returns a sring which defines the CmFigure and all its children,
    i.e., the workarea form widget and its list of children.
****************************************************************************/
void CmFigure::GetCmFigureDefinition(CmString &def_string,
				     CmBool recursive = 1,
				     CmBool include_self = 1) {
  if (include_self) {
    // saving class name
    def_string +=  "\n\\begin_figure {" + cmfigure_class->ClassName() + "}\n";
    // saving name
    def_string += "\\figure_name \"" + Name + "\" \n";

    //saving parent
    if (parent && !use_default_parent)
      def_string += "\\figure_parent \"" + parent->Name + "\"\n";

    // add callback list to string
    for (int i = 0; i < callbacks.ListSize(); i++ ) {
      CmFigureCallback *callback = (CmFigureCallback *) callbacks[i];
      if (!callback->CallbackString.Matches(WhiteSpace))
	def_string += "\\callback \"" + callback->CallbackText + 
	  "\" \"" + Quotify(callback->CallbackString) + "\"\n";
    }

    // added resources to def_string
    for (i = 0; i < resources.ListSize(); i++) {
      CmFigureResource *resource = (CmFigureResource *) resources[i];
      CmFigureClass *check_default = cmfigure_class;
      CmString default_value = "";
      do {
	default_value = check_default->Default(resource->name);
	check_default = check_default->SuperCmClass();
      } while (check_default && default_value == "");
      if (resource->value != default_value)  
	def_string += resource->name + " \"" 
	  + Quotify(resource->value) + "\";\n";
    }
    def_string += "\\end_figure\n";
  }
  for (int i=0; i<children.ListSize(); i++)
    ((CmFigure *) children[i])->GetCmFigureDefinition(def_string);
}

// Resize
void CmFigure::Resize(int x, int y, int width, int height) {
  Position leftpos = x, toppos = y;
  Position rightpos = x + width, botpos = y + height;
  ChangeResource(XmNleftPosition, form("%d", leftpos));
  ChangeResource(XmNtopPosition, form("%d",toppos));
  ChangeResource(XmNrightPosition, form("%d", rightpos));
  ChangeResource(XmNbottomPosition, form("%d", botpos));
  
  if (widget) 
    XtVaSetValues(widget,
		  XmNleftPosition, (XtArgVal) leftpos,
		  XmNtopPosition, (XtArgVal) toppos,
		  XmNrightPosition, (XtArgVal) rightpos,
		  XmNbottomPosition, (XtArgVal) botpos, NULL);
}


/*************************
 CmFigure
**************************/
ostream & operator << (ostream &stream, CmFigure * cm_widget) {
  CmString output;
  cm_widget->GetCmFigureDefinition(output, 1, 0);
  stream << output;
  return(stream);
}
