/* $Header: /afs/athena.mit.edu/astaff/project/atdev/src/plotter/RCS/Scale.h,v 3.2 91/03/17 20:01:40 crcraig Exp $ */

/*******************************************************************
  Copyright (C) 1990 by the Massachusetts Institute of Technology

   Export of this software from the United States of America is assumed
   to require a specific license from the United States Government.
   It is the responsibility of any person or organization contemplating
   export to obtain such a license before exporting.

WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
distribute this software and its documentation for any purpose and
without fee is hereby granted, provided that the above copyright
notice appear in all copies and that both that copyright notice and
this permission notice appear in supporting documentation, and that
the name of M.I.T. not be used in advertising or publicity pertaining
to distribution of the software without specific, written prior
permission.  M.I.T. makes no representations about the suitability of
this software for any purpose.  It is provided "as is" without express
or implied warranty.

***************************************************************** */

#ifndef _AtScale_h
#define _AtScale_h    

#include <X11/Intrinsic.h>
    
typedef enum {AtTransformLINEAR,
		  AtTransformLOG,
		  AtTransformINVALID} AtTransform;

typedef struct {
    double low, high;
    int lowpix, highpix;
    AtTransform transform;
    double mult, offset;
    int errorcode;
} AtScale;


extern AtScale *AtScaleCreate(double, double, int, int, AtTransform);
extern AtScale *AtScaleCopy(AtScale *);
extern void AtScaleDestroy(AtScale *);
extern void AtScaleResize(AtScale *, int, int);
extern void AtScaleRescale(AtScale *, double, double);
extern void AtScaleChangeTransform(AtScale *, AtTransform);
extern int AtScaleUserToPixel(AtScale *, double);
extern double AtScalePixelToUser(AtScale *, int);
extern char *AtScaleGetErrorMessage(AtScale *);
extern double _AtScaleAlmostZero;

#define SCALEERROR_NONE 0 
#define SCALEERROR_BOUNDLESS 1 
#define SCALEERROR_BOUNDCLOSE 2 
#define SCALEERROR_LOGNEGATIVE 3 
#define SCALEERROR_NOTRANSFORM 4


#define AtScaleGetLow(scale) (scale->low)
#define AtScaleGetHigh(scale) (scale->high)
#define AtScaleGetLowPix(scale) (scale->lowpix)
#define AtScaleGetHighPix(scale) (scale->highpix)
#define AtScaleGetTransform(scale) (scale->transform)
#define AtScaleGetErrorCode(scale) (scale->errorcode)

/* for use with X Toolkit resources and converters */
#define XtRTransform "Transform"
extern void AtCvtStringToTransform(XrmValue*, Cardinal, XrmValue*, XrmValue*);
extern Boolean _AtStringToTransformRegistered;

#endif /* _AtScale_h */
