% LaTeX2e document class for printing the APOcrypha, the chapter journal
% of the Alpha Chi Chapter of Alpha Phi Omega
%
% David Maze, 2 October 1997
%
% Parts shamelessly stolen from the standard LaTeX2e article class.

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{apocrypha}[1997/10/02 AXcoAPO APOcrypha class]

% \documentstyle[11pt,psbox]{article}  % Had rotcapt once

% Text size options
\newcommand\@ptsize{}
\DeclareOption{10pt}{\renewcommand\@ptsize{0}}
\DeclareOption{11pt}{\renewcommand\@ptsize{1}}
\DeclareOption{12pt}{\renewcommand\@ptsize{2}}

% Draft copy (formerly skel.tex) or final (apoc.tex)?
\newif\if@finalapoc
\DeclareOption{draft}{\setlength\overfullrule{5pt}\@finalapocfalse}
\DeclareOption{final}{\setlength\overfullrule{0pt}\@finalapoctrue}

\ExecuteOptions{11pt,final}
\ProcessOptions

% Load the correct text size
\input{size1\@ptsize.clo}

% Various lengths: APOcs appear on half a landscape-oriented page.  Use
% half-inch margins.
\setlength\oddsidemargin{-.5in}
\setlength\evensidemargin{-.5in}
\setlength\textwidth{4.5in}
\setlength\topmargin{-.5in}
\setlength\textheight{7.5in}
\setlength\paperheight{8.5in}
\setlength\paperwidth{5.5in}

\setlength\parindent{0\p@}
\setlength\parskip{.5\baselineskip}
\setlength\lineskip{1\p@}
\setlength\normallineskip{1\p@}

\newcommand{\PSbox}[3]{\mbox{\rule{0in}{#3}\special{psfile=#1}\hspace{#2}}}

% TOC hacks
\def\@plaintocline#1#2#3#4#5{\ifnum #1>\c@tocdepth \else
  \vskip \z@ plus.2\p@
  {\leftskip #2\relax \rightskip \@tocrmarg \parfillskip -\rightskip
    \parindent #2\relax\@afterindenttrue
   \interlinepenalty\@M
   \leavevmode
   \@tempdima #3\relax \advance\leftskip \@tempdima \hbox{}\hskip -\leftskip
    #4\nobreak \hfill \nobreak
           \hbox to\@pnumwidth{\hfil\reset@font\rm #5}\par}\fi}
\def\l@article{\@plaintocline{2}{1.5em}{2.3em}}
\def\l@subarticle{\@plaintocline{3}{3.8em}{3.2em}}

\newcommand\@rticle{\@startsection {article}{1}{\z@}%
                                  {-3.5ex \@plus -1ex \@minus -.2ex}%
                                  {2.3ex \@plus .2ex}%
                                  {\normalfont\Large\bfseries}}
\newcommand\article[1]{\@rticle*{#1}\addcontentsline{toc}{article}{#1}}
\newcommand\sub@rticle{\@startsection {subarticle}{2}{\z@}%
                                     {-3.25ex \@plus -1ex \@minus -.2ex}%
                                     {1.5ex \@plus .2ex}%
                                     {\normalfont\large\bfseries}}
\newcommand\subarticle[1]{\sub@rticle*{#1}\addcontentsline{toc}{subarticle}{#1}}

\newcommand\tableofcontents{%
    \par
    \vskip -3.5ex plus -1ex minus -.2ex%
    {\normalfont\Large\bfseries%
    \contentsname
    \markboth{\MakeUppercase\contentsname}{\MakeUppercase\contentsname}%
    }%
    \vskip 2.3ex plus .2ex%
    \@starttoc{toc}%
    }
\newcommand\contentsname{Contents}


\def\reporttweak{}
\def\report#1{\noindent{\bf #1} \list{foobar}{\leftmargin=1em%
\itemindent=-\leftmargin \parindent=0in \reporttweak}}
\let\endreport=\endlist

\newcommand\@makefntext[1]{%
    \parindent 1em%
    \noindent
    \hb@xt@1.8em{\hss\@makefnmark}#1}

\pagestyle{plain}
\pagenumbering{arabic}
\input{cover-defs.tex}

% Get useful things for minutes in APOcs, too.
\input{initials.tex}

% Things that need to go at the top of the document:
\AtBeginDocument{%
  \if@finalapoc
  \input{front-cover.tex}
  \fi
  \pagestyle{empty}
  \tableofcontents
  \newpage
  \setcounter{page}{1}
  \pagestyle{plain}
% \special{landscape}
}

\AtEndDocument{%
  \if@finalapoc
  \include{back-cover}
  \fi
}
