/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#include "cont.h"
#include "closure.h"

#define ARG_CHUNK 24
#define ARG_STACK_SIZE (llargtop - llargbase)

LLTag llcont_t;
LLCont *llcur_cont;
LLCont *lltop_cont;

/* Create a new continuation, whose parent is the current
   continuation. */
void llccall_bytecode (bytecode, objects, env)
     LLString *bytecode;
     LLVector *objects;
     LLEnv *env;
{
  LLCont *c;
  
  c = (LLCont *) llmake_obj(llcont_t);
  c->bytecode = bytecode;
  c->objects = objects;
  c->pc = (unsigned char *) llcstring_to_chars(c->bytecode);
  c->env = env;
  c->argc = 0; 
  c->argtop = c->argptr = c->argbase = (LLObj **) malloc(0);
  c->retaddr = llcur_cont;
  llcur_cont = c;
}

void llcmake_arg_space()
{
  LLObj **oldbase;
  int newsize;

  oldbase = llargbase;
  llargbase = (LLObj **) realloc(llargbase, sizeof(LLObj *) * (newsize = ARG_STACK_SIZE + ARG_CHUNK));
  llargtop = llargbase + newsize;
  llargptr = llargbase + (llargptr - oldbase);
}

void llccall_with_current_continuation(closure)
     LLClosure *closure;
{
  llpusharg(llcur_cont);
  llcapply((LLObj *) closure, 1);
}

static void touch_cont(cont)
     LLCont *cont;
{
  LLObj **c, **end;

  lltouch_obj((LLObj *) cont->bytecode);
  lltouch_obj((LLObj *) cont->objects);
  lltouch_obj((LLObj *) cont->env);
  c = cont->argbase;
  end = cont->argptr;
  while (c < end) lltouch_obj(*c++);
  if (cont->retaddr)
    lltouch_obj((LLObj *) cont->retaddr);
}

int llpushlist(cons)
LLCons *cons;
{ 
  int i = 0; 
  if(cons != (LLCons *)NIL) { 
    i = 1 + llpushlist((LLCons *) llccdr(cons));
    llpusharg(llccar(cons));
  }
  return i;
}

static void apply() 
{
  LLObj *closure ;
  LLCons *cons; 
  closure = (LLObj *) llnextarg();
  cons = (LLCons *) llnextarg();
  if (((LLObj*)cons) != NIL)
    lltypecheck(((LLObj*)cons), llcons_t);
  lllastarg();
  llcapply(closure, llpushlist(cons));
}


  
void llinit_cont()
{
  llcont_t = lladd_obj_td (sizeof(LLCont), "Continuation",
			   0, touch_cont, 0, 0);
/*  llcur_cont = lltop_cont = (LLCont *) llmake_obj(llcont_t);*/

				/* this is punted for now because  */
				/* I don't know what I'm doing.  */
				/* also, it needs a PC and ARGSTACK and stuff */
  llcur_cont = (LLCont *)NIL; 

  llregister_cfunc(apply, "apply");
}
