/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

#include "lbc.h"
#include "obj.h"
#include "cons.h"
#include "closure.h"
#include "env.h"
#include "cont.h"
#include "comp.h"

/*
  Limey byte code ... stolen from GNU Emacs

Opcode	Operands		Description
-------	--------		-----------
\010 ...	Push value of object #n on stack
\020 + n	Set object #n to value on stack
\026 , n
\027 , n
\030 ...	Varbind (add variable to current environment)
\040 ...	Call (with n arguments)
\050 ...	Unbind (I doubt I am I going to implement this)
\060 ...	<invalid>
\070		Symbols: nth symbolp consp stringp listp eq memq not 
\100		Symbols: car cdr cons list1 list2 list3 list4
\110		Symbols: aref aset symbol-value symbol-function set fset get substring
\120		Symbols: concat2 concat3 concat4 sub1 add1 eqlsign gtr lss
\130		Symbols: leq geq diff negate plus max min <invalid>
\170            Compile
\171		Create environment
\172		Restore environment
\173		Push current Environment
\174		Push current continuation
\175		Return to parent continuation
\176		Return and also exit llrun_byte_code
\201, n1, n2	constant2 (for object numbers > 63)
\202, n1, n2	goto
\203, n1, n2	goto-if-false
\204, n1, n2	goto-if-not-false
\205, n1, n2	goto-if-false-else-pop
\206, n1, n2	goto-if-not-false-else-pop
\207		Return (will function as NO OP)
\210		Discard dup catch 
\300 + n	Push object #n on stack (n = 0 to 63)
*/


#define getbc() (*llcur_cont->pc++) /* Get a bit of byte code */
#define curobjects (llcur_cont->objects)
#define curenv (llcur_cont->env)
#define setpc(n) (llcur_cont->pc = (unsigned char *) (llcur_cont->bytecode->text + n))

/*ARGSUSED*/
static int lbc_short ()
{
  register int c1;

  c1 = getbc();
  return c1 + (getbc()<<8);
}

llinit_lbc()
{
}

lbc_cons_accessors(b) 
     int b;
{
  LLObj *o[4];
  LLCons *cons;
  int i; 

  o[1] = o[2] = o[3] = o[0] = NIL;
  cons = (LLCons *)NIL;
  switch( b) {
  case 0:			/* car */
    if(llis_cons(cons = (LLCons *)llpoparg()))
    llpusharg(llccar(cons));
    break;
  case 1:			/* cdr */
    if(llis_cons(cons = (LLCons *)llpoparg()))
    llpusharg(llccdr(cons));
    break;
  case 2:			/* cons */
    o[1] = llpoparg();
    o[2] = llpoparg();
    llpusharg(llcmake_cons(o[1], o[2]));
    break;
  case 6:			/* list4 */
    o[3] = llpoparg();
  case 5:			/* list3 */
    o[2] = llpoparg();
  case 4:			/* list2 */
    o[1] = llpoparg();
  case 3:			/* list1 */
    o[0] = llpoparg();
    for (i = 3; o[i] == NIL; i--);
    while(i--) 
      cons = llcmake_cons(o[i], (LLObj *) cons); 
    llpusharg(cons);
  }
}

lbc_stack_perverters(b) 
int b;
{
  LLObj  *obj; 
  switch( b ){ 
  case 0:
    llpoparg();
    break; 
  case 1: 
    obj = llpeekarg();
    llpusharg(obj); 
    break;
  }
}

static int lbc_number (b)
     int b;
{
  switch (b & 7) {
  case 0:
  case 1:
  case 2:
  case 3:
  case 4:
  case 5:
    return b & 7;
  case 6:
    return getbc();
  case 7:
    return lbc_short();
  }
  return 0;			/* We can never get here. */
				/* But suppress a warning. */
}

#define lbc_object_ref(n) llcvector_ref(curobjects,n)
#define lbc_constant llpusharg	
#define lbc_varref(obj) (llpusharg(get_env(curenv, (obj))))
#define lbc_varset(obj) (set_env(curenv, (obj), llpoparg()))
#define lbc_varbind(obj) (add_env(curenv, (obj), llpoparg()))

static void lbc_goto_or_constant2(code, where)
     int code;
     int where;
{
  switch (code) {
  case 0:
    llerror(LLBAD_BYTE_CODE);
    break;
  case 1:
    lbc_constant(lbc_object_ref(where));
				/* Push constant on stack */
    break;
  case 2:			/* Straight GOTO */
    setpc(where);
    break;
  case 3:			/* goto if false */
    if (llpoparg() == LLFALSE)
      setpc(where);
    break;
  case 4:			/* goto if not false */
    if (llpoparg() != LLFALSE)
      setpc(where);
    break;
  case 5:			/* goto if false else pop */
    if (llpeekarg() == LLFALSE)
      setpc(where);
    else
      llpoparg();
    break;
  case 6:			/* goto if not false else pop */
    if (llpeekarg() != LLFALSE)
      setpc(where);
    else
      llpoparg();
    break;
  case 7:
    break;
  }
}

/* If this returns non-NULL, then llrun_byte_code should exit. */
static LLObj *lbc_compiler_hooks(b)
     int b;
{
  LLObj *closure, *retval;

  switch (b) {
  case 0:
    closure = llcompile_lambda_or_delay((LLCons *) llpoparg(), curenv);
    llpusharg(closure);		/* This might be a delay, not a closure... */
    return NULL;		/* So what?  They're the same anyway. */
  case 1:
    curenv = llmake_child_env(curenv);
    return NULL;		/* Begin evaluation in */
				/* a new environment! */
  case 2:		       
    curenv = llcget_parent(curenv);
    return NULL;		/* So much for that one... */

  case 3: 
    llpusharg(curenv);
    return NULL;

  case 4:			/* We trust the type and number of args
				   on the stack because the byte compiler
				   checked already */
    llccall_with_current_continuation((LLClosure *) llpoparg());
    return NULL;

  case 5:			/* Return to caller */
  case 6:			/* Return and exit llrun_byte_codef */
    retval = llpoparg();
    llcur_cont = llcur_cont->retaddr;
    if (b == 5) {
      llpusharg(retval);
      return NULL;
    } else
      return retval;

  default: 
    llerror(LLBAD_BYTE_CODE);
    return NULL;
  }
}

LLObj *llrun_byte_code ()
{
  int b;
  LLObj *retval;
  

  while (llcur_cont != (LLCont *) NIL) { 
/*  while(llcur_cont != lltop_cont) {*/
    b = getbc();
    switch (b >> 3) {
    case 1:
      lbc_varref(lbc_object_ref(lbc_number(b)));
      break;
    case 2:
      lbc_varset(lbc_object_ref(lbc_number(b)));
      break;
    case 3:
      lbc_varbind(lbc_object_ref(lbc_number(b)));
      break;
    case 4: 
      llargc = lbc_number(b);
      llapply();		
      break;
    case 010:
      lbc_cons_accessors(b & 7); 
      break;
    case 017: 
      if (retval = lbc_compiler_hooks(b & 7))
	return retval;
      break;
    case 020:
      lbc_goto_or_constant2(b & 7, lbc_short());
      break;
    case 021:
      lbc_stack_perverters(b & 7);
      break;
    case 030:
    case 031:
    case 032:
    case 033:
    case 034:
    case 035:
    case 036:
    case 037:
      lbc_constant(lbc_object_ref(b-0300));
      break;
    default:
      llerror(LLBAD_BYTE_CODE);		/* Illegal byte code */
    }
  }
  return retval;
}
      
