/*
 * KCLL -  Ken and Chee's Limey Lisp  
 * All Rights to the code and any products created with this code is 
 * hereby granted. 
 *
 * I.E. You can do whatever the hell you want with this code. 
 * The only restriction is that this copyright notice not be modified.
 */

/*

Memory Allocation

*/
#include <stdio.h>
#include "kcll.h"
#include "mem.h"
#include "obj.h"

extern LLTag llnum_tds;
LLHeap llheap;

#define obj_size(t) (((t) > llnum_tds) ? -1 : object_tds[t]->size)
#define OBJ_CHUNK 10000
#define ADD_OBJ_TO_HEAP(obj) llheap.objects[llheap.objnext++] = obj

/* makes an object and enrolls it in MIT
   Returns NULL if invalid type. 
 */
LLObj *llmake_obj(tag)		
     LLTag tag;
{
  LLObj *newobj;
  
  if(obj_size(tag) == -1) llerror(LLINVALID_OBJECT);
  newobj = (LLObj *)malloc(obj_size(tag));
  llobj_tag(newobj) = tag;
  mem_register(newobj);
  return(newobj);
}

mem_register(obj)
LLObj *obj;
{
  if(llheap.objnext == llheap.objalloc) 
    llheap.objects = (LLObj **) realloc(llheap.objects, sizeof(LLObj *) * (llheap.objalloc += OBJ_CHUNK));
  ADD_OBJ_TO_HEAP(obj);
}

llinit_heap()
{
  llheap.objnext = 0;	
  if((llheap.objects =
      (LLObj **)malloc(OBJ_CHUNK*sizeof(LLObj *))) == NULL) {
    llerror(LLNO_MEMORY);
  }
  llheap.objalloc += OBJ_CHUNK;
}

llinit_mem()
{
  llinit_heap();
}
