/*
 * cslota.h - An area which displays a cslot.
 */

/* ---------- Structure definition ---------- */
struct cslota_data {
     struct cslot *ctp;
};

/* ---------- Functions ---------- */
/*
 * cslota_create(cslot, aop) --> struct area *
 * 
 * Create a new area which contains the cslot.  The area will be created
 * according to the stuff in aop.
 */
struct area *cslota_create(struct cslot *, struct aop *);

/*
 * cslota_setinvert(cslota, invert)
 * 
 * Set the invert status of area to invert.  Refresh as needed.
 */
int cslota_setinvert(struct area *, int);

#ifdef SCROTUM
/*
 * cslota_resetcslot(cslota, cslot) 
 */
#endif
