/*
 *    Brutus source file implementing the main() function.
 *    Copyright (C) 2005-2008 OMC Denmark ApS.
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */
#include <windows.h>
#include <tchar.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "gpl.h"

#define VERSION "0.1"

static void print_usage(const char *name)
{
	fprintf(stdout,
		"Usage: %s <REQUESTED WORKING DIRECTORY>\n\n"
		"  -help \tPrints this message.\n"
		"  -license \tPrint software license.\n"
		"\n", name);
}


static void print_license(void)
{
	fprintf(stdout, "%s\n", STR_AGPL_V3);
}

int main(int argc, char *argv[])
{
	int retv = EXIT_FAILURE;
	LPTSTR cmd = NULL;
	STARTUPINFO startup_info;
	PROCESS_INFORMATION process_info;

	const char *name = argv[0];
	int n = strlen(argv[0]);
	name = &(argv[0])[n];
	while (n && ( '\\' != *name) && ('/' != *name)) {
		n--;
		name = &(argv[0])[n];
	}
	if (( '\\' == *name) || ('/' == *name)) 
		name++;

	/* mandatory legal blurb */
	fprintf(stdout,
		"    %s version %s, Copyright (C) 2005-2008 OMC Denmark ApS.\n"
		"\n"
		"    %s comes with ABSOLUTELY NO WARRANTY. This is free software;\n"
		"    you can redistribute it and/or modify it under the term of the\n"
		"    GNU General Public License as published by the Free Software Foundation;\n"
		"    either version 2 of the License, or (at your option) any later version.\n"
		"\n"
		"    Please invoke %s as \"%s -license\" for the legal details.\n\n\n", name, VERSION, name, name, name);

	if (argc < 2) {
		print_usage(name);
		goto out;
	}

	if (!strcmp("-help", argv[1])) {
		print_usage(name);
		goto out;
	}

	if (!strcmp("-license", argv[1])) {
		print_license();
		goto out;
	}

	ZeroMemory(&startup_info, sizeof(startup_info));
	startup_info.cb = sizeof(startup_info);
	ZeroMemory(&process_info, sizeof(process_info));

	cmd = _strdup("ExchangeMapiCdo.EXE");
	if (!cmd)
		goto out;
	CreateProcess(NULL,
		      cmd,
		      NULL,
		      NULL,
		      FALSE,
		      CREATE_NEW_CONSOLE | CREATE_NEW_PROCESS_GROUP | CREATE_DEFAULT_ERROR_MODE,
		      NULL,
		      argv[1],
		      &startup_info,
		      &process_info);

	// Wait until child process exits.
	WaitForSingleObject(process_info.hProcess, INFINITE);
	
	// Close process and thread handles. 
	CloseHandle(process_info.hProcess);
	CloseHandle(process_info.hThread);

	retv = EXIT_SUCCESS;
out:
	if (cmd)
		free(cmd);

	return retv;
}
