/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef __IABCONTAINERS_IMPL_H_
#define __IABCONTAINERS_IMPL_H_

#include "IABContainerS.h"
#include "utils/macros.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>

#include "Brutus_Loader_Impl_Export.h"

class Brutus_Loader_Impl_Export BRUTUS_IABContainer_i : public virtual POA_BRUTUS::IABContainer,
							public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_IABContainer_i(LPABCONT ABContainer,
			      LPMAPISESSION MAPISession,
			      ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BRESULT CreateEntry(const ::BRUTUS::ENTRYID & lpEntryID,
					      ::BRUTUS::BDEFINE ulCreateFlags,
					      ::BRUTUS::IMAPIProp_out lppMAPIPropEntry);

	virtual ::BRUTUS::BRESULT CopyEntries(const ::BRUTUS::SBinaryArray & lpEntries,
					      ::BRUTUS::IMAPIProgress_ptr lpProgress,
					      ::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT DeleteEntries(const ::BRUTUS::SBinaryArray & lpEntries,
						::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT ResolveNames(const ::BRUTUS::SPropTagArray & lpPropTagArray,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::ADRLIST & lpAdrList,
					       ::BRUTUS::seq_BDEFINE_out lpFlagList);

	virtual ::BRUTUS::BRESULT GetContentsTable(::BRUTUS::BDEFINE ulFlags,
						   ::BRUTUS::IMAPITable_out lppTable);

	virtual ::BRUTUS::BRESULT GetHierarchyTable(::BRUTUS::BDEFINE ulFlags,
						    ::BRUTUS::IMAPITable_out lppTable);

	virtual ::BRUTUS::BRESULT OpenEntry(const ::BRUTUS::ENTRYID & lpEntryID,
					    const char * lpInterface,
					    ::BRUTUS::BDEFINE ulFlags,
					    ::CORBA::ULong_out lpulObjType,
					    ::BRUTUS::IUnknown_out lppUnk);

	virtual ::BRUTUS::BRESULT SetSearchCriteria(::BRUTUS::SRestrictionContainer_ptr lpRestriction,
						    ::CORBA::Boolean ContainerListInfo,
						    const ::BRUTUS::SBinaryArray & lpContainerList,
						    ::CORBA::ULong ulSearchFlags);

	virtual ::BRUTUS::BRESULT GetSearchCriteria(::BRUTUS::BDEFINE ulFlags,
						    ::CORBA::Boolean SRestrictionInfo,
						    ::BRUTUS::SRestrictionContainer_out lppRestriction,
						    ::CORBA::Boolean ContainerListInfo,
						    ::BRUTUS::SBinaryArray_out lppContainerList,
						    ::CORBA::Boolean SearchStateInfo,
						    ::CORBA::ULong_out lpulSearchState);

	virtual ::BRUTUS::BRESULT GetLastError(::BRUTUS::BRESULT ReturnCode,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::MAPIERROR_out lppMAPIError);

	virtual ::BRUTUS::BRESULT SaveChanges(::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT GetProps(const ::BRUTUS::SPropTagArray & lpPropTagArray,
					   ::BRUTUS::BDEFINE ulFlags,
					   ::BRUTUS::seq_SPropValue_out lppPropArray);

	virtual ::BRUTUS::BRESULT GetPropList(::BRUTUS::BDEFINE ulFlags,
					      ::BRUTUS::SPropTagArray_out lppPropTagArray);

	virtual ::BRUTUS::BRESULT OpenProperty(::CORBA::ULong ulPropTag,
					       const char * lpiid,
					       ::CORBA::ULong ulInterfaceOptions,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::IUnknown_out lppUnk);

	virtual ::BRUTUS::BRESULT SetProps(const ::BRUTUS::seq_SPropValue & lpPropArray,
					   ::CORBA::Boolean ProblemInfo,
					   ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT DeleteProps(const ::BRUTUS::SPropTagArray & lpPropTagArray,
					      ::CORBA::Boolean ProblemInfo,
					      ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT CopyTo(const ::BRUTUS::seq_GUID & rgiidExclude,
					 const ::BRUTUS::SPropTagArray & lpExcludeProps,
					 ::BRUTUS::IMAPIProgress_ptr lpProgress,
					 const char * lpInterface,
					 const ::BRUTUS::ENTRYID & lpDestObj,
					 ::BRUTUS::BDEFINE ulFlags,
					 ::CORBA::Boolean ProblemInfo,
					 ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT CopyProps(const ::BRUTUS::SPropTagArray & lpIncludeProps,
					    ::BRUTUS::IMAPIProgress_ptr lpProgress,
					    const char * lpInterface,
					    const ::BRUTUS::ENTRYID & lpDestObj,
					    ::BRUTUS::BDEFINE ulFlags,
					    ::CORBA::Boolean ProblemInfo,
					    ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT GetNamesFromIDs(::BRUTUS::SPropTagArray & lppPropTags,
						  const char * lpPropSetGuid,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::BRUTUS::seq_MAPINAMEID_out lpppPropNames);

	virtual ::BRUTUS::BRESULT GetIDsFromNames(const ::BRUTUS::seq_MAPINAMEID & lppPropNames,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::BRUTUS::SPropTagArray_out lppPropTags);

	virtual ::BRUTUS::BRESULT GetNamedProps(const char *PropSetGuid,
						const ::BRUTUS::seq_NamedPropertyTag & lpPropTagArray,
						::BRUTUS::BDEFINE ulFlags,
						::BRUTUS::seq_SPropValue_out lppPropArray);

	virtual ::BRUTUS::BRESULT SetNamedProps(const char *PropSetGuid,
						const ::BRUTUS::seq_NamedPropertyTag & lpPropTagArray,
						const ::BRUTUS::seq_SPropValue & lpPropArray,
						::CORBA::Boolean ProblemInfo,
						::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT QueryInterface(const char *iid,
						 ::BRUTUS::IUnknown_out ppvObject);

	virtual void Destroy(::CORBA::ULong InstanceID);


private:
	BRUTUS_IABContainer_i(void)
	{ };

	virtual ~BRUTUS_IABContainer_i(void)
	{
		try {
			ab_container_->Release();
			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	LPABCONT ab_container_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;

	ACE_RW_Mutex mutex_;
};

#endif /* __IABCONTAINERS_IMPL_H_  */
