/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "IABLogonS_impl.h"
#include "obj_utils.h"
#include "conv_utils.h"

BRUTUS_IABLogon_i::BRUTUS_IABLogon_i(LPABLOGON ABLogon,
				     LPMAPISESSION MAPISession,
				     ::PortableServer::POA_ptr Poa)
	: ab_logon_(ABLogon),
	  mapi_session_(MAPISession),
	  poa_(::PortableServer::POA::_duplicate(Poa))
{
	mapi_session_->AddRef();
}


::BRUTUS::BRESULT BRUTUS_IABLogon_i::GetLastError(::BRUTUS::BRESULT hResult,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::BRUTUS::MAPIERROR_out lppMAPIError)
{
	//Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}

::BRUTUS::BRESULT BRUTUS_IABLogon_i::Logoff(::BRUTUS::BDEFINE ulFlags)
{
	//Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}

::BRUTUS::BRESULT BRUTUS_IABLogon_i::OpenEntry(const ::BRUTUS::ENTRYID & lpEntryID,
					       const char * lpInterface,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::BDEFINE_out lpulObjType,
					       ::BRUTUS::IUnknown_out lppUnk)

{
	//Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}

::BRUTUS::BRESULT BRUTUS_IABLogon_i::CompareEntryIDs(const ::BRUTUS::ENTRYID & lpEntryID1,
						     const ::BRUTUS::ENTRYID & lpEntryID2,
						     ::BRUTUS::BDEFINE ulFlags,
						     ::CORBA::Boolean_out lpulResult)

{
	//Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}

::BRUTUS::BRESULT BRUTUS_IABLogon_i::Advise(const ::BRUTUS::ENTRYID & lpEntryID,
					    ::CORBA::ULong ulEventMask,
					    ::BRUTUS::IMAPIAdviseSink_ptr lpAdviseSink,
					    ::CORBA::ULong_out lpulConnection)

{
	//Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}

::BRUTUS::BRESULT BRUTUS_IABLogon_i::Unadvise(::CORBA::ULong ulConnection)

{
	//Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}

::BRUTUS::BRESULT BRUTUS_IABLogon_i::OpenStatusEntry(const char * lpInterface,
						     ::BRUTUS::BDEFINE ulFlags,
						     ::BRUTUS::BDEFINE_out lpulObjType,
						     ::BRUTUS::IMAPIStatus_out lppEntry)

{
	//Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}

::BRUTUS::BRESULT BRUTUS_IABLogon_i::OpenTemplateID(const ::BRUTUS::ENTRYID & lpTemplateID,
						    ::BRUTUS::BDEFINE ulTemplateFlags,
						    ::BRUTUS::IMAPIProp_ptr lpMAPIPropData,
						    const char * lpInterface,
						    ::BRUTUS::IMAPIProp_out lppMAPIPropNew,
						    ::BRUTUS::IMAPIProp_ptr lpMAPIPropSibling)

{
	//Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}

::BRUTUS::BRESULT BRUTUS_IABLogon_i::GetOneOffTable(::BRUTUS::BDEFINE ulFlags,
						    ::BRUTUS::IMAPITable_out lppTable)

{
	//Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}

::BRUTUS::BRESULT BRUTUS_IABLogon_i::PrepareRecips(::BRUTUS::BDEFINE ulBDEFINE,
						   const ::BRUTUS::SPropTagArray & lpPropTagArray,
						   const ::BRUTUS::ADRLIST & lpRecipList)

{
	//Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}

::BRUTUS::BRESULT BRUTUS_IABLogon_i::QueryInterface(const char *iid,
						    ::BRUTUS::IUnknown_out ppvObject)
{
	ppvObject = ::BRUTUS::IUnknown::_nil();

	GUID mapi_iid;
	if (!guid_brutus_to_mapi_no_alloc(iid, &mapi_iid)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into MAPI GUID");
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	HRESULT hr;
	void *object = NULL;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = ab_logon_->QueryInterface(mapi_iid, &object);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	if (hr == S_OK) {
		if (!create_brutus_object(iid, (LPUNKNOWN)object, poa_, ppvObject, mapi_session_)) {
			BRUTUS_LOG_BUG("Could not create brutus object.");
			((LPUNKNOWN)object)->Release();
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}

	return br;
}


void BRUTUS_IABLogon_i::Destroy(::CORBA::ULong InstanceID)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IABLogon_i::Destroy()");

	::PortableServer::ObjectId_var oid;
	oid = poa_->servant_to_id(this);

	poa_->deactivate_object(oid);

	BRUTUS_LOG_INF("Leaving BRUTUS_IABLogon_i::Destroy()");
}
