/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef __IABLOGONS_IMPL_H_
#define __IABLOGONS_IMPL_H_

#include "IABLogonS.h"
#include "utils/macros.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>
#include <mapispi.h>

#include "Brutus_Loader_Impl_Export.h"

class Brutus_Loader_Impl_Export BRUTUS_IABLogon_i : public virtual POA_BRUTUS::IABLogon,
						    public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_IABLogon_i(LPABLOGON ABLogon,
			  LPMAPISESSION MAPISession,
			  ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BRESULT GetLastError(::BRUTUS::BRESULT hResult,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::MAPIERROR_out lppMAPIError);

	virtual ::BRUTUS::BRESULT Logoff(::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT OpenEntry(const ::BRUTUS::ENTRYID & lpEntryID,
					    const char * lpInterface,
					    ::BRUTUS::BDEFINE ulFlags,
					    ::BRUTUS::BDEFINE_out lpulObjType,
					    ::BRUTUS::IUnknown_out lppUnk);

	virtual ::BRUTUS::BRESULT CompareEntryIDs(const ::BRUTUS::ENTRYID & lpEntryID1,
						  const ::BRUTUS::ENTRYID & lpEntryID2,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::CORBA::Boolean_out lpulResult);

	virtual ::BRUTUS::BRESULT Advise(const ::BRUTUS::ENTRYID & lpEntryID,
					 ::CORBA::ULong ulEventMask,
					 ::BRUTUS::IMAPIAdviseSink_ptr lpAdviseSink,
					 ::CORBA::ULong_out lpulConnection);

	virtual ::BRUTUS::BRESULT Unadvise(::CORBA::ULong ulConnection);

	virtual ::BRUTUS::BRESULT OpenStatusEntry(const char * lpInterface,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::BRUTUS::BDEFINE_out lpulObjType,
						  ::BRUTUS::IMAPIStatus_out lppEntry);

	virtual ::BRUTUS::BRESULT OpenTemplateID(const ::BRUTUS::ENTRYID & lpTemplateID,
						 ::BRUTUS::BDEFINE ulTemplateFlags,
						 ::BRUTUS::IMAPIProp_ptr lpMAPIPropData,
						 const char * lpInterface,
						 ::BRUTUS::IMAPIProp_out lppMAPIPropNew,
						 ::BRUTUS::IMAPIProp_ptr lpMAPIPropSibling);

	virtual ::BRUTUS::BRESULT GetOneOffTable(::BRUTUS::BDEFINE ulFlags,
						 ::BRUTUS::IMAPITable_out lppTable);

	virtual ::BRUTUS::BRESULT PrepareRecips(::BRUTUS::BDEFINE ulBDEFINE,
						const ::BRUTUS::SPropTagArray & lpPropTagArray,
						const ::BRUTUS::ADRLIST & lpRecipList);

	virtual ::BRUTUS::BRESULT QueryInterface(const char *iid,
						 ::BRUTUS::IUnknown_out ppvObject);

	virtual void Destroy(::CORBA::ULong InstanceID);

private:
	// Skeleton constructor
	BRUTUS_IABLogon_i(void)
	{ };


	virtual ~BRUTUS_IABLogon_i(void)
	{
		try {
			ab_logon_->Release();
			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};


	LPABLOGON ab_logon_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;

	ACE_RW_Mutex mutex_;
};


#endif /* __IABLOGONS_IMPL_H_  */
