/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef __IEXCHANGEIMPORTCONTENTSCHANGESS_IMPL_H_
#define __IEXCHANGEIMPORTCONTENTSCHANGESS_IMPL_H_

#include "IExchangeImportContentsChangesS.h"

#include "utils/macros.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>
#include "edkmdb.h"

#include "Brutus_Loader_Impl_Export.h"

class Brutus_Loader_Impl_Export BRUTUS_IExchangeImportContentsChanges_i : public virtual POA_BRUTUS::IExchangeImportContentsChanges,
									  public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_IExchangeImportContentsChanges_i(LPEXCHANGEIMPORTCONTENTSCHANGES ExchangeImportContentsChanges,
						LPMAPISESSION MAPISession,
						::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BRESULT GetLastError(::BRUTUS::BRESULT ReturnCode,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::MAPIERROR_out lppMAPIError);

	virtual ::BRUTUS::BRESULT Config(::BRUTUS::IStream_ptr lpStream,
					 ::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT UpdateState(::BRUTUS::IStream_ptr lpStream);

	virtual ::BRUTUS::BRESULT ImportMessageChange(const ::BRUTUS::seq_SPropValue & ppvalChanges,
						      ::BRUTUS::BDEFINE ulFlags,
						      ::BRUTUS::IMessage_out lppMessage);

	virtual ::BRUTUS::BRESULT ImportMessageDeletion(::BRUTUS::BDEFINE ulFlags,
							const ::BRUTUS::SBinaryArray & lpSrcEntryList);

	virtual ::BRUTUS::BRESULT ImportPerUserReadStateChange(const ::BRUTUS::seq_READSTATE & lpReadState);

	virtual ::BRUTUS::BRESULT ImportMessageMove(const ::BRUTUS::seq_octet & pbSourceKeySrcFolder,
						    const ::BRUTUS::seq_octet & pbSourceKeySrcMessage,
						    const ::BRUTUS::seq_octet & pbPCLMessage,
						    const ::BRUTUS::seq_octet & pbSourceKeyDestMessage,
						    const ::BRUTUS::seq_octet & pbChangeNumDestMessage);

	virtual ::BRUTUS::BRESULT QueryInterface(const char *iid,
						 ::BRUTUS::IUnknown_out ppvObject);

	virtual void Destroy(::CORBA::ULong InstanceID);

private:
	BRUTUS_IExchangeImportContentsChanges_i(void);

	virtual ~BRUTUS_IExchangeImportContentsChanges_i(void)
	{
		try {
			exchange_import_contents_changes_->Release();
			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	LPEXCHANGEIMPORTCONTENTSCHANGES exchange_import_contents_changes_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;

	ACE_RW_Mutex mutex_;
};


#endif /* __IEXCHANGEIMPORTCONTENTSCHANGESS_IMPL_H_  */
