/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "IExchangeImportHierarchyChangesS_impl.h"

#include "obj_utils.h"
#include "conv_utils.h"
#include "istream_utils.h"

#include "templates.i"

static inline ULONG native_flags(const ::BRUTUS::BDEFINE Flags)
{
	::BRUTUS::BDEFINE flags = Flags;
	ULONG retval = 0;

	if (!Flags)
		return 0;

	if (flags & ::BRUTUS::BRUTUS_SYNC_UNICODE) {
		retval |= SYNC_UNICODE;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_SYNC_UNICODE);
	}
	if (flags & ::BRUTUS::BRUTUS_SYNC_ASSOCIATED) {
		retval |= SYNC_ASSOCIATED;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_SYNC_ASSOCIATED);
	}

	if (flags) {
		char msg[128] = {0};
		sprintf_s(msg, sizeof(msg), "Unknown flag(s) from BRUTUS : %X", flags);
		BRUTUS_LOG_BUG(msg);
	}

	return retval;
}

BRUTUS_IExchangeImportHierarchyChanges_i::BRUTUS_IExchangeImportHierarchyChanges_i(
	LPEXCHANGEIMPORTHIERARCHYCHANGES ExchangeImportHierarchyChanges,
	LPMAPISESSION MAPISession,
	::PortableServer::POA_ptr Poa)
	: exchange_import_hierarchy_changes_(ExchangeImportHierarchyChanges),
	  mapi_session_(MAPISession),
	  poa_(::PortableServer::POA::_duplicate(Poa))
{
	mapi_session_->AddRef();
}

::BRUTUS::BRESULT BRUTUS_IExchangeImportHierarchyChanges_i::GetLastError(::BRUTUS::BRESULT ReturnCode,
									 ::BRUTUS::BDEFINE ulFlags,
									 ::BRUTUS::MAPIERROR_out lppMAPIError)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IExchangeImportHierarchyChanges_i::GetLastError()");

	::BRUTUS::MAPIERROR_var error;
	try {
		error = new ::BRUTUS::MAPIERROR;
	}
	catch (std::bad_alloc &) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	error->ulVersion = (::CORBA::ULong)0;
	error->ulLowLevelError = (::CORBA::ULong)0;
	error->ulContext = (::CORBA::ULong)0;

	HRESULT hr;
	if (!bresult_to_hresult(ReturnCode, hr)) {
		lppMAPIError = error._retn();
		BRUTUS_LOG_BUG("Could not convert BRESULT into HRESULT");
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	LPMAPIERROR mapi_error = NULL;
	unsigned long flags = native_flags(ulFlags);
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = exchange_import_hierarchy_changes_->GetLastError(hr, flags, &mapi_error);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		MAPIFreeBuffer(mapi_error);
		lppMAPIError = error._retn();
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}
	if (!mapi_error)
		BRUTUS_LOG_INF("No applicable error information from MAPI");

	mapierror_mapi_to_brutus(mapi_error, error, true);

	lppMAPIError = error._retn();

	BRUTUS_LOG_INF("Leaving Brutus_IExchangeImportHierarchyChanges_I::GetLastError");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IExchangeImportHierarchyChanges_i::Config(::BRUTUS::IStream_ptr lpStream,
								   ::BRUTUS::BDEFINE ulFlags)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IExchangeImportHierarchyChanges_i::Config()");

	ULONG flags = native_flags(ulFlags);

	LPSTREAM mapi_stream = NULL;
	if (!::CORBA::is_nil(lpStream)) {
		try {
			mapi_stream = new CStream(lpStream);
		}
		catch (...) {
			BRUTUS_LOG_ERR("No memory");
			throw ::CORBA::NO_MEMORY();
		}
	}

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = exchange_import_hierarchy_changes_->Config(mapi_stream,
								flags);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IExchangeImportHierarchyChanges_i::Config()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IExchangeImportHierarchyChanges_i::UpdateState(::BRUTUS::IStream_ptr lpStream)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IExchangeImportHierarchyChanges_i::UpdateState()");

	LPSTREAM mapi_stream = NULL;
	if (!::CORBA::is_nil(lpStream)) {
		try {
			mapi_stream = new CStream(lpStream);
		}
		catch (...) {
			BRUTUS_LOG_ERR("No memory");
			throw ::CORBA::NO_MEMORY();
		}
	}

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = exchange_import_hierarchy_changes_->UpdateState(mapi_stream);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IExchangeImportHierarchyChanges_i::UpdateState()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IExchangeImportHierarchyChanges_i::ImportFolderChange(const ::BRUTUS::seq_SPropValue & ppvalChanges)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IExchangeImportHierarchyChanges_i::ImportFolderChange()");

	unsigned long count = 0;
	SPropValue *mapi_props = NULL;
	if (!spropvalue_array_brutus_to_mapi(&ppvalChanges, 0, count, mapi_props)) {
		MAPIFreeBuffer(mapi_props);
		BRUTUS_LOG_ERR("Could not convert Brutus SPropValue to MAPI SPropValue");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = exchange_import_hierarchy_changes_->ImportFolderChange(count,
									    mapi_props);
	}
	MAPIFreeBuffer(mapi_props);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IExchangeImportHierarchyChanges_i::ImportFolderChange()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IExchangeImportHierarchyChanges_i::ImportFolderDeletion(::BRUTUS::BDEFINE ulFlags,
										 const ::BRUTUS::SBinaryArray & lpSrcEntryList)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IExchangeImportHierarchyChanges_i::ImportFolderDeletion()");

	unsigned long flags = native_flags(ulFlags);

	SBinaryArray *mapi_bin_array = NULL;
	if (!sbinary_array_brutus_to_mapi(&lpSrcEntryList, 0, mapi_bin_array)) {
		BRUTUS_LOG_BUG("Conversion error");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = exchange_import_hierarchy_changes_->ImportFolderDeletion(flags, mapi_bin_array);
	}
	MAPIFreeBuffer(mapi_bin_array);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IExchangeImportHierarchyChanges_i::ImportFolderDeletion()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IExchangeImportHierarchyChanges_i::QueryInterface(const char *iid,
									   ::BRUTUS::IUnknown_out ppvObject)
{
	ppvObject = ::BRUTUS::IUnknown::_nil();

	GUID mapi_iid;
	if (!guid_brutus_to_mapi_no_alloc(iid, &mapi_iid)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into GUID");
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	HRESULT hr;
	void *object = NULL;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = exchange_import_hierarchy_changes_->QueryInterface(mapi_iid, &object);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	if (hr == S_OK) {
		if (!create_brutus_object(iid, (LPUNKNOWN)object, poa_, ppvObject, mapi_session_)) {
			BRUTUS_LOG_BUG("Could not create brutus object.");
			((LPUNKNOWN)object)->Release();
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}

	return br;
}

void BRUTUS_IExchangeImportHierarchyChanges_i::Destroy(::CORBA::ULong InstanceID)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IExchangeImportHierarchyChanges_i::Destroy()");

	::PortableServer::ObjectId_var oid;
	oid = poa_->servant_to_id(this);

	poa_->deactivate_object(oid);

	BRUTUS_LOG_INF("Leaving BRUTUS_IExchangeImportHierarchyChanges_i::Destroy()");
}
