/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef __IEXCHANGEMANAGESTORES_IMPL_H_
#define __IEXCHANGEMANAGESTORES_IMPL_H_

#include "IExchangeManageStoreS.h"

#include "utils/macros.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>
#include "edkmdb.h"

#include "Brutus_Loader_Impl_Export.h"

class Brutus_Loader_Impl_Export BRUTUS_IExchangeManageStore_i : public virtual POA_BRUTUS::IExchangeManageStore,
								public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_IExchangeManageStore_i(LPEXCHANGEMANAGESTORE ExchangeManageStore,
				      LPMAPISESSION MAPISession,
				      ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BRESULT CreateStoreEntryID(const char * lpszMsgStoreDN,
						     const char * lpszMailboxDN,
						     ::BRUTUS::BDEFINE ulFlags,
						     ::BRUTUS::ENTRYID_out lppEntryID);

	virtual ::BRUTUS::BRESULT EntryIDFromSourceKey(const ::BRUTUS::seq_octet & lpFolderSourceKey,
						       const ::BRUTUS::seq_octet & lpMessageSourceKey,
						       ::BRUTUS::ENTRYID_out lppEntryID);

	virtual ::BRUTUS::BRESULT GetRights(const ::BRUTUS::ENTRYID & lpUserEntryID,
					    const ::BRUTUS::ENTRYID & lpEntryID,
					    ::CORBA::ULong_out lpulRights);

	virtual ::BRUTUS::BRESULT GetMailboxTable(const char * lpszServerName,
						  ::BRUTUS::IMAPITable_out lppTable,
						  ::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT GetPublicFolderTable(const char * lpszServerName,
						       ::BRUTUS::IMAPITable_out lppTable,
						       ::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT QueryInterface(const char *iid,
						 ::BRUTUS::IUnknown_out ppvObject);

	virtual void Destroy(::CORBA::ULong InstanceID);

private:
	BRUTUS_IExchangeManageStore_i(void);

	virtual ~BRUTUS_IExchangeManageStore_i(void)
	{
		try {
			exchange_manage_store_->Release();
			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	LPEXCHANGEMANAGESTORE exchange_manage_store_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;

	ACE_RW_Mutex mutex_;
};


#endif /* __IEXCHANGEMANAGESTORES_IMPL_H_  */
