/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "IExchangeRuleActionS_impl.h"
#include "obj_utils.h"
#include "conv_utils.h"

BRUTUS_IExchangeRuleAction_i::BRUTUS_IExchangeRuleAction_i(LPEXCHANGERULEACTION ExchangeRuleAction,
							   LPMAPISESSION MAPISession,
							   ::PortableServer::POA_ptr Poa)
	: exchange_rule_action_(ExchangeRuleAction),
	  mapi_session_(MAPISession),
	  poa_(::PortableServer::POA::_duplicate(Poa))
{
	mapi_session_->AddRef();
}

::BRUTUS::BRESULT BRUTUS_IExchangeRuleAction_i::ActionCount(::CORBA::ULong_out lpcActions)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IExchangeRuleAction_i::ActionCount()");

	ULONG actions = 0;;

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = exchange_rule_action_->ActionCount(&actions);
	}
	lpcActions = actions;

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IExchangeRuleAction_i::ActionCount()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IExchangeRuleAction_i::GetAction(::CORBA::ULong ulActionNumber,
							  ::BRUTUS::LARGE_INTEGER_out lpruleid,
							  ::BRUTUS::ACTION_out lppAction)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IExchangeRuleAction_i::ActionCount()");

	::BRUTUS::ACTION_var b_action;
	try {
		b_action = new ::BRUTUS::ACTION;
	}
	catch (...) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	lpruleid = 0;

	LARGE_INTEGER rule_id;
	LPACTION action = NULL;

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = exchange_rule_action_->GetAction((ULONG)ulActionNumber,
						      &rule_id,
						      &action);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		lppAction = b_action._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	if (!large_int_mapi_to_brutus(&rule_id, lpruleid)) {
		BRUTUS_LOG_BUG("Could not convert MAPI LARGE_INTEGER into BRUTUS LARGE_INTEGER");
		lppAction = b_action._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	if (!action_mapi_to_brutus(action, b_action.out(), mapi_session_, poa_.in())) {
		BRUTUS_LOG_BUG("Could not convert MAPI ACTION into BRUTUS ACTION");
		lppAction = b_action._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}
	lppAction = b_action._retn();

	BRUTUS_LOG_INF("Leaving BRUTUS_IExchangeRuleAction_i::ActionCount()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IExchangeRuleAction_i::QueryInterface(const char *iid,
							       ::BRUTUS::IUnknown_out ppvObject)
{
	ppvObject = ::BRUTUS::IUnknown::_nil();

	GUID mapi_iid;
	if (!guid_brutus_to_mapi_no_alloc(iid, &mapi_iid)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into MAPI GUID");
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	HRESULT hr;
	void *object = NULL;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = exchange_rule_action_->QueryInterface(mapi_iid, &object);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	if (hr == S_OK) {
		if (!create_brutus_object(iid, (LPUNKNOWN)object, poa_, ppvObject, mapi_session_)) {
			BRUTUS_LOG_BUG("Could not create brutus object.");
			((LPUNKNOWN)object)->Release();
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}

	return br;
}

void BRUTUS_IExchangeRuleAction_i::Destroy(::CORBA::ULong InstanceID)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IExchangeRuleAction_i::Destroy()");

	::PortableServer::ObjectId_var oid;
	oid = poa_->servant_to_id(this);

	poa_->deactivate_object(oid);

	BRUTUS_LOG_INF("Leaving BRUTUS_IExchangeRuleAction_i::Destroy()");
}
