/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#pragma warning(disable : 6211)

#include "IMAPIFolderS_impl.h"

#include "obj_utils.h"
#include "conv_utils.h"
#include "progress_utils.h"

#include "IMAPITableS_impl.h"
#include "IMsgStoreS_impl.h"
#include "IAddrBookS_impl.h"
#include "IProfSectS_impl.h"
#include "IMAPIFolderS_impl.h"
#include "IABContainerS_impl.h"
#include "IMessageS_impl.h"
#include "IAttachS_impl.h"
#include "IDistListS_impl.h"
#include "IMAPIStatusS_impl.h"
#include "IMailUserS_impl.h"
#include "IMsgServiceAdminS_impl.h"

#include "templates.i"

#include <ace/String_Base.h>

static inline ULONG native_flags(const ::BRUTUS::BDEFINE Flags)
{
	::BRUTUS::BDEFINE flags = Flags;
	ULONG retval = 0;

	if (!Flags)
		return 0;

	if (flags & ::BRUTUS::BRUTUS_STOP_SEARCH) {
		retval |= STOP_SEARCH;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_STOP_SEARCH);
	}
	if (flags & ::BRUTUS::BRUTUS_RESTART_SEARCH) {
		retval |= RESTART_SEARCH;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_RESTART_SEARCH);
	}
	if (flags & ::BRUTUS::BRUTUS_RECURSIVE_SEARCH) {
		retval |= RECURSIVE_SEARCH;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_RECURSIVE_SEARCH);
	}
	if (flags & ::BRUTUS::BRUTUS_SHALLOW_SEARCH) {
		retval |= SHALLOW_SEARCH;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_SHALLOW_SEARCH);
	}
	if (flags & ::BRUTUS::BRUTUS_FOREGROUND_SEARCH) {
		retval |= FOREGROUND_SEARCH;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_FOREGROUND_SEARCH);
	}
	if (flags & ::BRUTUS::BRUTUS_BACKGROUND_SEARCH) {
		retval |= BACKGROUND_SEARCH;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_BACKGROUND_SEARCH);
	}
	if (flags & ::BRUTUS::BRUTUS_MAPI_BEST_ACCESS) {
		retval |= MAPI_BEST_ACCESS;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MAPI_BEST_ACCESS);
	}
	if (flags & ::BRUTUS::BRUTUS_CONVENIENT_DEPTH) {
		retval |= CONVENIENT_DEPTH;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_CONVENIENT_DEPTH);
	}
	if (flags & ::BRUTUS::BRUTUS_MAPI_ASSOCIATED) {
		retval |= MAPI_ASSOCIATED;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MAPI_ASSOCIATED);
	}
	if (flags & ::BRUTUS::BRUTUS_MAPI_DIALOG) {
		retval |= MAPI_DIALOG;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MAPI_DIALOG);
	}
	if (flags & ::BRUTUS::BRUTUS_MAPI_DECLINE_OK) {
		retval |= MAPI_DECLINE_OK;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MAPI_DECLINE_OK);
	}
	if (flags & ::BRUTUS::BRUTUS_MAPI_MOVE) {
		retval |= MAPI_MOVE;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MAPI_MOVE);
	}
	if (flags & ::BRUTUS::BRUTUS_MAPI_NOREPLACE) {
		retval |= MAPI_NOREPLACE;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MAPI_NOREPLACE);
	}
	if (flags & ::BRUTUS::BRUTUS_MAPI_MODIFY) {
		retval |= MAPI_MODIFY;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MAPI_MODIFY);
	}
	if (flags & ::BRUTUS::BRUTUS_MAPI_CREATE) {
		retval |= MAPI_CREATE;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MAPI_CREATE);
	}
	if (flags & ::BRUTUS::BRUTUS_MAPI_UNICODE) {
		retval |= MAPI_UNICODE;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MAPI_UNICODE);
	}
	if (flags & ::BRUTUS::BRUTUS_FORCE_SAVE) {
		retval |= FORCE_SAVE;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_FORCE_SAVE);
	}
	if (flags & ::BRUTUS::BRUTUS_KEEP_OPEN_READONLY) {
		retval |= KEEP_OPEN_READONLY;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_KEEP_OPEN_READONLY);
	}
	if (flags & ::BRUTUS::BRUTUS_KEEP_OPEN_READWRITE) {
		retval |= KEEP_OPEN_READWRITE;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_KEEP_OPEN_READWRITE);
	}
	if (flags & ::BRUTUS::BRUTUS_MAPI_DEFERRED_ERRORS) {
		retval |= MAPI_DEFERRED_ERRORS;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MAPI_DEFERRED_ERRORS);
	}
	if (flags & ::BRUTUS::BRUTUS_MESSAGE_DIALOG) {
		retval |= MESSAGE_DIALOG;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MESSAGE_DIALOG);
	}
	if (flags & ::BRUTUS::BRUTUS_MESSAGE_MOVE) {
		retval |= MESSAGE_MOVE;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MESSAGE_MOVE);
	}
	if (flags & ::BRUTUS::BRUTUS_OPEN_IF_EXISTS) {
		retval |= OPEN_IF_EXISTS;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_OPEN_IF_EXISTS);
	}
	if (flags & ::BRUTUS::BRUTUS_COPY_SUBFOLDERS) {
		retval |= COPY_SUBFOLDERS;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_COPY_SUBFOLDERS);
	}
	if (flags & ::BRUTUS::BRUTUS_FOLDER_DIALOG) {
		retval |= FOLDER_DIALOG;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_FOLDER_DIALOG);
	}
	if (flags & ::BRUTUS::BRUTUS_FOLDER_MOVE) {
		retval |= FOLDER_MOVE;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_FOLDER_MOVE);
	}
	if (flags & ::BRUTUS::BRUTUS_DEL_FOLDERS) {
		retval |= DEL_FOLDERS;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_DEL_FOLDERS);
	}
	if (flags & ::BRUTUS::BRUTUS_DEL_MESSAGES) {
		retval |= DEL_MESSAGES;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_DEL_MESSAGES);
	}
	if (flags & ::BRUTUS::BRUTUS_MSGSTATUS_DELMARKED) {
		retval |= MSGSTATUS_DELMARKED;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MSGSTATUS_DELMARKED);
	}
	if (flags & ::BRUTUS::BRUTUS_MSGSTATUS_HIDDEN) {
		retval |= MSGSTATUS_HIDDEN;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MSGSTATUS_HIDDEN);
	}
	if (flags & ::BRUTUS::BRUTUS_MSGSTATUS_HIGHLIGHTED) {
		retval |= MSGSTATUS_HIGHLIGHTED;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MSGSTATUS_HIGHLIGHTED);
	}
	if (flags & ::BRUTUS::BRUTUS_MSGSTATUS_REMOTE_DELETE) {
		retval |= MSGSTATUS_REMOTE_DELETE;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MSGSTATUS_REMOTE_DELETE);
	}
	if (flags & ::BRUTUS::BRUTUS_MSGSTATUS_REMOTE_DOWNLOAD) {
		retval |= MSGSTATUS_REMOTE_DOWNLOAD;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MSGSTATUS_REMOTE_DOWNLOAD);
	}
	if (flags & ::BRUTUS::BRUTUS_MSGSTATUS_TAGGED) {
		retval |= MSGSTATUS_TAGGED;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MSGSTATUS_TAGGED);
	}
	if (flags & ::BRUTUS::BRUTUS_RECURSIVE_SORT) {
		retval |= RECURSIVE_SORT;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_RECURSIVE_SORT);
	}
	if (flags & ::BRUTUS::BRUTUS_DEL_ASSOCIATED) {
		retval |= DEL_ASSOCIATED;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_DEL_ASSOCIATED);
	}

	if (flags) {
		char msg[128] = {0};
		sprintf_s(msg, sizeof(msg), "Unknown flag(s) from BRUTUS : %X", flags);
		BRUTUS_LOG_BUG(msg);
	}

	return retval;
}

static inline ULONG native_read_flags(const ::BRUTUS::BDEFINE Flags)
{
	::BRUTUS::BDEFINE flags = Flags;
	ULONG retval = 0;

	if (!Flags)
		return 0;

	if (flags & ::BRUTUS::BRUTUS_CLEAR_READ_FLAG) {
		retval |= CLEAR_READ_FLAG;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_CLEAR_READ_FLAG);
	}
	if (flags & ::BRUTUS::BRUTUS_CLEAR_NRN_PENDING) {
		retval |= CLEAR_NRN_PENDING;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_CLEAR_NRN_PENDING);
	}
	if (flags & ::BRUTUS::BRUTUS_CLEAR_RN_PENDING) {
		retval |= CLEAR_RN_PENDING;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_CLEAR_RN_PENDING);
	}
	if (flags & ::BRUTUS::BRUTUS_GENERATE_RECEIPT_ONLY) {
		retval |= GENERATE_RECEIPT_ONLY;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_GENERATE_RECEIPT_ONLY);
	}
	if (flags & ::BRUTUS::BRUTUS_SUPPRESS_RECEIPT) {
		retval |= SUPPRESS_RECEIPT;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_SUPPRESS_RECEIPT);
	}
	if (flags & ::BRUTUS::BRUTUS_MAPI_DEFERRED_ERRORS) {
		retval |= MAPI_DEFERRED_ERRORS;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MAPI_DEFERRED_ERRORS);
	}
	if (flags & ::BRUTUS::BRUTUS_MESSAGE_DIALOG) {
		retval |= MESSAGE_DIALOG;
		FLAGS_OFF(::BRUTUS::BDEFINE, flags, ::BRUTUS::BRUTUS_MESSAGE_DIALOG);
	}

	if (flags) {
		char msg[128] = {0};
		sprintf_s(msg, sizeof(msg), "Unknown read flag(s) from BRUTUS : %X", flags);
		BRUTUS_LOG_BUG(msg);
	}

	return retval;
}

BRUTUS_IMAPIFolder_i::BRUTUS_IMAPIFolder_i(LPMAPIFOLDER MAPIFolder,
					   LPMAPISESSION MAPISession,
					   ::PortableServer::POA_ptr Poa)
	: mapi_folder_(MAPIFolder),
	  mapi_session_(MAPISession),
	  poa_(::PortableServer::POA::_duplicate(Poa))
{
	mapi_session_->AddRef();
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::CreateMessage(const char * lpInterface,
						      ::BRUTUS::BDEFINE ulFlags,
						      ::BRUTUS::IMessage_out lppMessage)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPISession_i::CreateMessage()");

	GUID *i_id;
	if (!guid_brutus_to_mapi(lpInterface, NULL, i_id)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into MAPI GUID");
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	unsigned long flags = native_flags(ulFlags);

	lppMessage = ::BRUTUS::IMessage::_nil();
	LPMESSAGE mapi_message = NULL;

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->CreateMessage(i_id, flags, &mapi_message);
	}
	MAPIFreeBuffer(i_id);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	if (hr == S_OK)
		lppMessage = create_object<BRUTUS_IMessage_i, ::BRUTUS::IMessage, LPMESSAGE>
			(mapi_message, poa_.in(), mapi_session_);

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::CreateMessage()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::CopyMessages(const ::BRUTUS::seq_ENTRYID &lpMsgList,
						     const char * lpInterface,
						     const ::BRUTUS::ENTRYID &lpDestFolder,
						     ::BRUTUS::IMAPIProgress_ptr lpProgress,
						     ::BRUTUS::BDEFINE ulFlags)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::CopyMessages()");

	::ENTRYLIST mapi_entrylist = { 0 };
	if (!entrylist_brutus_to_mapi_internal_alloc(&lpMsgList, NULL, &mapi_entrylist)) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}

	GUID *i_id;
	if (!guid_brutus_to_mapi(lpInterface, NULL, i_id)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into MAPI GUID");
		MAPIFreeBuffer(mapi_entrylist.lpbin);
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	ENTRYID *entry_id = NULL;
	unsigned long entry_id_size;
	if (!entryid_brutus_to_mapi(&lpDestFolder, 0, entry_id_size, entry_id)) {
		BRUTUS_LOG_ERR("No memory");
		MAPIFreeBuffer(mapi_entrylist.lpbin);
		MAPIFreeBuffer(i_id);
		throw ::CORBA::NO_MEMORY();
	}
	LPUNKNOWN unk_dest_object = NULL;
	HRESULT hr;
	{
		unsigned long obj_type;
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_session_->OpenEntry(entry_id_size,
					      entry_id,
					      i_id,
					      MAPI_BEST_ACCESS,
					      &obj_type,
					      &unk_dest_object);
	}
	::BRUTUS::BRESULT br;
	if (hr != S_OK) {
		if (!hresult_to_bresult(hr, br)) {
			BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
			br = ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
		BRUTUS_LOG_BUG("Error opening object");
		if (unk_dest_object)
			unk_dest_object->Release();

		MAPIFreeBuffer(mapi_entrylist.lpbin);
		MAPIFreeBuffer(entry_id);
		MAPIFreeBuffer(i_id);

		return br;
	}

	ULONG flags = native_flags(ulFlags);
	CMAPIProgress *progress = NULL;
	if ((flags & MESSAGE_DIALOG) && !::CORBA::is_nil(lpProgress)) {
		try {
			progress = new CMAPIProgress(lpProgress);
		}
		catch (std::bad_alloc &) {
			BRUTUS_LOG_ERR("No memory");
			MAPIFreeBuffer(mapi_entrylist.lpbin);
			MAPIFreeBuffer(entry_id);
			MAPIFreeBuffer(i_id);
			unk_dest_object->Release();
			throw ::CORBA::NO_MEMORY();
		}
	} else
		FLAGS_OFF(ULONG, flags, MESSAGE_DIALOG);

	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->CopyMessages(&mapi_entrylist,
						i_id,
						(void*)unk_dest_object,
						0,
						progress,
						flags);
	}
	MAPIFreeBuffer(mapi_entrylist.lpbin);
	MAPIFreeBuffer(entry_id);
	MAPIFreeBuffer(i_id);
	unk_dest_object->Release();

	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::CopyMessages()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::DeleteMessages(const ::BRUTUS::seq_ENTRYID &lpMsgList,
						       ::BRUTUS::IMAPIProgress_ptr lpProgress,
						       ::BRUTUS::BDEFINE ulFlags)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::DeleteMessages()");

	::ENTRYLIST mapi_entrylist = { 0 };
	if (!entrylist_brutus_to_mapi_internal_alloc(&lpMsgList, NULL, &mapi_entrylist)) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}

	ULONG flags = native_flags(ulFlags);
	CMAPIProgress *progress = NULL;
	if ((flags & MESSAGE_DIALOG) && !::CORBA::is_nil(lpProgress)) {
		try {
			progress = new CMAPIProgress(lpProgress);
		}
		catch (std::bad_alloc &) {
			BRUTUS_LOG_ERR("No memory");
			MAPIFreeBuffer(mapi_entrylist.lpbin);
			throw ::CORBA::NO_MEMORY();
		}
	} else
		FLAGS_OFF(ULONG, flags, MESSAGE_DIALOG);

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->DeleteMessages(&mapi_entrylist,
						  0,
						  progress,
						  flags);
	}
	MAPIFreeBuffer(mapi_entrylist.lpbin);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::Deletemessages()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::CreateFolder(::CORBA::ULong ulFolderType,
						     const char * lpszFolderName,
						     const char * lpszFolderComment,
						     const char * lpInterface,
						     ::BRUTUS::BDEFINE ulFlags,
						     ::BRUTUS::IMAPIFolder_out lppFolder)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::CreateFolder()");

	GUID *i_id;
	if (!guid_brutus_to_mapi(lpInterface, NULL, i_id)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into MAPI GUID");
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	ULONG ftype;
	switch (ulFolderType) {
	case ::BRUTUS::BRUTUS_FOLDER_GENERIC :
		ftype = FOLDER_GENERIC;
		break;
	case ::BRUTUS::BRUTUS_FOLDER_SEARCH :
		ftype = FOLDER_SEARCH;
		break;
	default :
		BRUTUS_LOG_BUG("Unknown folder type from Brutus");
		ftype = (ULONG)ulFolderType;
	}

	ULONG flags = native_flags(ulFlags);
	lppFolder = ::BRUTUS::IMAPIFolder::_nil();

	LPMAPIFOLDER mapi_folder = NULL;
	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->CreateFolder(ftype,
						(char*)lpszFolderName,
						(char*)lpszFolderComment,
						i_id,
						flags,
						&mapi_folder);
	}
	MAPIFreeBuffer(i_id);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	if (hr == S_OK)
		lppFolder = create_object<BRUTUS_IMAPIFolder_i, ::BRUTUS::IMAPIFolder, LPMAPIFOLDER>
			(mapi_folder, poa_.in(), mapi_session_);

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::CreateFolder()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::CopyFolder(const ::BRUTUS::ENTRYID & lpEntryID,
						   const char * lpInterface,
						   const ::BRUTUS::ENTRYID & lpDestFolder,
						   const char * lpszNewFolderName,
						   ::BRUTUS::IMAPIProgress_ptr lpProgress,
						   ::BRUTUS::BDEFINE ulFlags)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::CopyFolder()");

	ENTRYID *entry_id = NULL;
	unsigned long entry_id_size;
	if (!entryid_brutus_to_mapi(&lpEntryID, 0, entry_id_size, entry_id)) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}

	GUID *i_id;
	if (!guid_brutus_to_mapi(lpInterface, NULL, i_id)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into MAPI GUID");
		MAPIFreeBuffer(entry_id);
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	ENTRYID *dest_entry_id = NULL;
	unsigned long dest_entry_id_size;
	if (!entryid_brutus_to_mapi(&lpDestFolder, 0, dest_entry_id_size, dest_entry_id)) {
		BRUTUS_LOG_ERR("No memory");
		MAPIFreeBuffer(entry_id);
		MAPIFreeBuffer(i_id);
		throw ::CORBA::NO_MEMORY();
	}
	LPUNKNOWN unk_dest_object = NULL;
	HRESULT hr;
	{
		unsigned long obj_type;
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_session_->OpenEntry(dest_entry_id_size,
					      dest_entry_id,
					      i_id,
					      MAPI_MODIFY,
					      &obj_type,
					      &unk_dest_object);
	}
	MAPIFreeBuffer(dest_entry_id);
	::BRUTUS::BRESULT br;
	if (hr != S_OK) {
		if (!hresult_to_bresult(hr, br)) {
			BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
			br = ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
		BRUTUS_LOG_BUG("Error opening object");
		if (unk_dest_object)
			unk_dest_object->Release();

		MAPIFreeBuffer(entry_id);
		MAPIFreeBuffer(i_id);

		return br;
	}

	ULONG flags = native_flags(ulFlags);
	CMAPIProgress *progress = NULL;
	if ((flags & FOLDER_DIALOG) && !::CORBA::is_nil(lpProgress)) {
		try {
			progress = new CMAPIProgress(lpProgress);
		}
		catch (std::bad_alloc &) {
			BRUTUS_LOG_ERR("No memory");
			MAPIFreeBuffer(entry_id);
			MAPIFreeBuffer(i_id);
			unk_dest_object->Release();
			throw ::CORBA::NO_MEMORY();
		}
	} else
		FLAGS_OFF(ULONG, flags, FOLDER_DIALOG);

	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->CopyFolder(entry_id_size,
					      entry_id,
					      i_id,
					      unk_dest_object,
					      (char*)lpszNewFolderName,
					      0,
					      progress,
					      flags);
	}
	MAPIFreeBuffer(entry_id);
	MAPIFreeBuffer(i_id);
	unk_dest_object->Release();

	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::CopyFolder()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::DeleteFolder(const ::BRUTUS::ENTRYID & lpEntryID,
						     ::BRUTUS::IMAPIProgress_ptr lpProgress,
						     ::BRUTUS::BDEFINE ulFlags)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::DeleteFolder()");

	ENTRYID *entry_id = NULL;
	unsigned long entry_id_size;
	if (!entryid_brutus_to_mapi(&lpEntryID, 0, entry_id_size, entry_id)) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}

	ULONG flags = native_flags(ulFlags);
	CMAPIProgress *progress = NULL;
	if ((flags & FOLDER_DIALOG) && !::CORBA::is_nil(lpProgress)) {
		try {
			progress = new CMAPIProgress(lpProgress);
		}
		catch (std::bad_alloc &) {
			BRUTUS_LOG_ERR("No memory");
			MAPIFreeBuffer(entry_id);
			throw ::CORBA::NO_MEMORY();
		}
	} else
		FLAGS_OFF(ULONG, flags, FOLDER_DIALOG);

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->DeleteFolder(entry_id_size,
						entry_id,
						0,
						progress,
						flags);
	}
	MAPIFreeBuffer(entry_id);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::DeleteFolder()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::SetReadFlags(const ::BRUTUS::seq_ENTRYID &lpMsgList,
						     ::BRUTUS::IMAPIProgress_ptr lpProgress,
						     ::BRUTUS::BDEFINE ulFlags)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::SetReadFlags()");

	::ENTRYLIST mapi_entrylist = { 0 };
	if (!entrylist_brutus_to_mapi_internal_alloc(&lpMsgList, NULL, &mapi_entrylist)) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}

	ULONG flags = native_read_flags(ulFlags);
	CMAPIProgress *progress = NULL;
	if ((flags & MESSAGE_DIALOG) && !::CORBA::is_nil(lpProgress)) {
		try {
			progress = new CMAPIProgress(lpProgress);
		}
		catch (std::bad_alloc &) {
			BRUTUS_LOG_ERR("No memory");
			MAPIFreeBuffer(mapi_entrylist.lpbin);
			throw ::CORBA::NO_MEMORY();
		}
	} else
		FLAGS_OFF(ULONG, flags, MESSAGE_DIALOG);

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->SetReadFlags(&mapi_entrylist, 0, progress, flags);
	}
	MAPIFreeBuffer(mapi_entrylist.lpbin);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::SetReadFlags()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::GetMessageStatus(const ::BRUTUS::ENTRYID & lpEntryID,
							 ::BRUTUS::BDEFINE ulFlags,
							 ::CORBA::ULong_out lpulMessageStatus)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::GetMessageStatus()");

	ENTRYID *entry_id = NULL;
	unsigned long entry_id_size;
	if (!entryid_brutus_to_mapi(&lpEntryID, 0, entry_id_size, entry_id)) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}

	ULONG flags = native_flags(ulFlags);

	ULONG status;
	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetMessageStatus(entry_id_size,
						    entry_id,
						    flags,
						    &status);
	}
	MAPIFreeBuffer(entry_id);

	lpulMessageStatus = status;

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::GetMessageStatus()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::SetMessageStatus(const ::BRUTUS::ENTRYID & lpEntryID,
							 ::CORBA::ULong ulNewStatus,
							 ::CORBA::ULong ulNewStatusMask,
							 ::CORBA::ULong_out lpulOldStatus)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::SetMessageStatus()");

	ENTRYID *entry_id = NULL;
	unsigned long entry_id_size;
	if (!entryid_brutus_to_mapi(&lpEntryID, 0, entry_id_size, entry_id)) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}

	ULONG old_status;
	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->SetMessageStatus(entry_id_size,
						    entry_id,
						    (ULONG)ulNewStatus,
						    (ULONG)ulNewStatusMask,
						    &old_status);
	}
	MAPIFreeBuffer(entry_id);

	lpulOldStatus = old_status;

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::SetMessageStatus()");
	return br;

	//Add your implementation here
	return ::BRUTUS::BRUTUS_MAPI_E_NO_SUPPORT;
}

::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::SaveContentsSort(const ::BRUTUS::SSortOrderSet & lpSortCriteria,
							 ::BRUTUS::BDEFINE ulFlags)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::SaveContentsSort()");

	SSortOrderSet *mapi_set = NULL;
	if (!sort_order_set_brutus_to_mapi(&lpSortCriteria, 0, mapi_set)) {
		if (mapi_set)
			MAPIFreeBuffer(mapi_set);

		BRUTUS_LOG_BUG("Conversion error");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	unsigned long flags = native_flags(ulFlags);

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->SaveContentsSort(mapi_set, flags);
	}
	MAPIFreeBuffer(mapi_set);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::SaveContentsSort()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::EmptyFolder(::BRUTUS::IMAPIProgress_ptr lpProgress,
						    ::BRUTUS::BDEFINE ulFlags)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::EmptyFolder()");

	ULONG flags = native_flags(ulFlags);
	CMAPIProgress *progress = NULL;
	if ((flags & FOLDER_DIALOG) && !::CORBA::is_nil(lpProgress)) {
		try {
			progress = new CMAPIProgress(lpProgress);
		}
		catch (std::bad_alloc &) {
			BRUTUS_LOG_ERR("No memory");
			throw ::CORBA::NO_MEMORY();
		}
	} else
		FLAGS_OFF(ULONG, flags, FOLDER_DIALOG);

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->EmptyFolder(0, progress, flags);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::EmptyFolder()");
	return br;
}




::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::GetContentsTable(::BRUTUS::BDEFINE ulFlags,
							 ::BRUTUS::IMAPITable_out lppTable)

{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::GetContentsTable()");

	lppTable = ::BRUTUS::IMAPITable::_nil();
	LPMAPITABLE mapi_table = NULL;

	unsigned long flags = native_flags(ulFlags);

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetContentsTable(flags, &mapi_table);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	if (hr == S_OK)
		lppTable = create_object<BRUTUS_IMAPITable_i, ::BRUTUS::IMAPITable, LPMAPITABLE>
			(mapi_table, poa_.in(), mapi_session_);

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::GetContentsTable()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::GetHierarchyTable(::BRUTUS::BDEFINE ulFlags,
							  ::BRUTUS::IMAPITable_out lppTable)

{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::GetHierarchyTable()");

	lppTable = ::BRUTUS::IMAPITable::_nil();
	LPMAPITABLE mapi_table = NULL;

	unsigned long flags = native_flags(ulFlags);

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetHierarchyTable(flags, &mapi_table);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	lppTable = create_object<BRUTUS_IMAPITable_i, ::BRUTUS::IMAPITable, LPMAPITABLE>
		(mapi_table, poa_.in(), mapi_session_);

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::GetHierarchyTable()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::OpenEntry(const ::BRUTUS::ENTRYID & lpEntryID,
						  const char * lpInterface,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::CORBA::ULong_out lpulObjType,
						  ::BRUTUS::IUnknown_out lppUnk)

{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::OpenEntry()");

	lpulObjType = 0;
	lppUnk = ::BRUTUS::IUnknown::_nil();

	unsigned long flags = native_flags(ulFlags);

	GUID *i_id;
	if (!guid_brutus_to_mapi(lpInterface, NULL, i_id)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into MAPI GUID");
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	unsigned long obj_type;
	LPUNKNOWN unk_object = NULL;
	ENTRYID *entry_id = NULL;

	unsigned long entry_id_size;
	if (!entryid_brutus_to_mapi(&lpEntryID, 0, entry_id_size, entry_id)) {
		MAPIFreeBuffer(i_id);
		BRUTUS_LOG_ERR("No memory");
		return ::BRUTUS::BRUTUS_MAPI_E_NOT_ENOUGH_MEMORY;
	}

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->OpenEntry(entry_id_size,
					     entry_id,
					     i_id,
					     flags,
					     &obj_type,
					     &unk_object);
	}
	MAPIFreeBuffer(entry_id);
	MAPIFreeBuffer(i_id);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}
	if (S_OK != hr) {
		BRUTUS_LOG_ERR("BRUTUS_IMAPIFolder_i::OpenEntry() failed");
		return br;
	}

	::BRUTUS::IUnknown_var obj = ::BRUTUS::IUnknown::_nil();
	if (object_type_mapi_to_brutus(obj_type, lpulObjType)) {
		if (!create_brutus_object(obj_type, unk_object, poa_.in(), obj.out(), mapi_session_)) {
			if (unk_object)
				unk_object->Release();
			BRUTUS_LOG_BUG("Could not create brutus object");
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	} else {
		if (!create_brutus_object(lpInterface, unk_object, poa_, obj.out())) {
			if (unk_object)
				unk_object->Release();
			BRUTUS_LOG_BUG("Could not create brutus object");
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}
	lppUnk = obj._retn();

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::OpenEntry()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::SetSearchCriteria(::BRUTUS::SRestrictionContainer_ptr lpRestriction,
							  ::CORBA::Boolean ContainerListInfo,
							  const ::BRUTUS::SBinaryArray & lpContainerList,
							  ::CORBA::ULong ulSearchFlags)

{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::SetSearchCriteria()");

	SRestriction *mapi_res = NULL;
	if (!::CORBA::is_nil(lpRestriction)) {
		::BRUTUS::SRestriction_var brutus_res;
		try {
			brutus_res = lpRestriction->content();
		}
		catch (const ::CORBA::Exception &e) {
			BRUTUS_LOG_CRITICAL(e._info().c_str());
			return ::BRUTUS::BRUTUS_EXCEPTION_FROM_CLIENT;
		}
		if (!srestriction_brutus_to_mapi(brutus_res.in(), 0, mapi_res)) {
			MAPIFreeBuffer(mapi_res);

			BRUTUS_LOG_BUG("Conversion error");
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}

	SBinaryArray *mapi_bin_array = NULL;
	if (ContainerListInfo) {
		if (!sbinary_array_brutus_to_mapi(&lpContainerList, 0, mapi_bin_array)) {
			MAPIFreeBuffer(mapi_res);
			MAPIFreeBuffer(mapi_bin_array);

			BRUTUS_LOG_BUG("Conversion error");
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}

	unsigned long flags = native_flags(ulSearchFlags);

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->SetSearchCriteria(mapi_res, mapi_bin_array, flags);
	}
	MAPIFreeBuffer(mapi_res);
	MAPIFreeBuffer(mapi_bin_array);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::SetSearchCriteria()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::GetSearchCriteria(::BRUTUS::BDEFINE ulFlags,
							  ::CORBA::Boolean SRestrictionInfo,
							  ::BRUTUS::SRestrictionContainer_out lppRestriction,
							  ::CORBA::Boolean ContainerListInfo,
							  ::BRUTUS::SBinaryArray_out lppContainerList,
							  ::CORBA::Boolean SearchStateInfo,
							  ::CORBA::ULong_out lpulSearchState)

{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::GetSearchCriteria()");

	// Initiate _out parameters
	::BRUTUS::SRestrictionContainer_var brutus_restrict_container = ::BRUTUS::SRestrictionContainer::_nil();
	::BRUTUS::SBinaryArray_var brutus_container_list;
	try {
		brutus_container_list = new ::BRUTUS::SBinaryArray;
	}
	catch (std::bad_alloc &) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	brutus_container_list->length(0);

	HRESULT hr;

	SRestriction *mapi_res = NULL;
	if (SRestrictionInfo) {
		hr = MAPIAllocateBuffer(sizeof(SRestriction), (void**)&mapi_res);
		if (hr != S_OK) {
			BRUTUS_LOG_ERR("No memory");
			MAPIFreeBuffer(mapi_res);
			lppRestriction = brutus_restrict_container._retn();
			lppContainerList = brutus_container_list._retn();
			lpulSearchState = 0;
			return ::BRUTUS::BRUTUS_MAPI_E_NOT_ENOUGH_MEMORY;
		}
	}

	SBinaryArray *mapi_container_list = NULL;
	if (ContainerListInfo) {
		hr = MAPIAllocateBuffer(sizeof(SBinaryArray), (void**)&mapi_container_list);
		if (hr != S_OK) {
			BRUTUS_LOG_ERR("No memory");
			MAPIFreeBuffer(mapi_res);
			MAPIFreeBuffer(mapi_container_list);
			lppRestriction = brutus_restrict_container._retn();
			lppContainerList = brutus_container_list._retn();
			lpulSearchState = 0;
			return ::BRUTUS::BRUTUS_MAPI_E_NOT_ENOUGH_MEMORY;
		}
		mapi_container_list->cValues = 0;
		mapi_container_list->lpbin = NULL;
	}

	unsigned long *mss = NULL;
	unsigned long mapi_search_state;
	if (SearchStateInfo)
		mss = &mapi_search_state;

	unsigned long flags = native_flags(ulFlags);

	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetSearchCriteria(flags,
						     &mapi_res,
						     &mapi_container_list,
						     mss);
	}
	if (SearchStateInfo)
		lpulSearchState = (::CORBA::ULong)mapi_search_state;

	if (SRestrictionInfo) {
		if (!srestriction_mapi_to_container(mapi_res, mapi_session_, brutus_restrict_container.out(), poa_.in())) {
			BRUTUS_LOG_ERR("Could not convert MAPI SRestriction to Brutus SRestrictionContainer");
			MAPIFreeBuffer(mapi_res);
			MAPIFreeBuffer(mapi_container_list);
			lppContainerList = brutus_container_list._retn();
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}
	lppRestriction = brutus_restrict_container._retn();

	if (ContainerListInfo) {
		if (!sbinary_array_mapi_to_brutus(mapi_container_list, brutus_container_list.inout(), true)) {
			BRUTUS_LOG_ERR("Could not convert MAPI SRestriction to Brutus SRestrictionContainer");
			MAPIFreeBuffer(mapi_container_list);
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}
	lppContainerList = brutus_container_list._retn();

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::GetSearchCriteria()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::GetLastError(::BRUTUS::BRESULT ReturnCode,
						     ::BRUTUS::BDEFINE ulFlags,
						     ::BRUTUS::MAPIERROR_out lppMAPIError)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::GetLastError()");

	::BRUTUS::MAPIERROR_var error;
	try {
		error = new ::BRUTUS::MAPIERROR;
	}
	catch (std::bad_alloc &) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	error->ulVersion = (::CORBA::ULong)0;
	error->ulLowLevelError = (::CORBA::ULong)0;
	error->ulContext = (::CORBA::ULong)0;

	HRESULT hr;
	if (!bresult_to_hresult(ReturnCode, hr)) {
		lppMAPIError = error._retn();
		BRUTUS_LOG_BUG("Could not convert BRESULT into HRESULT");
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	LPMAPIERROR mapi_error = NULL;
	unsigned long flags = native_flags(ulFlags);

	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetLastError(hr, flags, &mapi_error);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		MAPIFreeBuffer(mapi_error);
		lppMAPIError = error._retn();
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}
	if (!mapi_error)
		BRUTUS_LOG_INF("No applicable error information from MAPI");

	mapierror_mapi_to_brutus(mapi_error, error, true);

	lppMAPIError = error._retn();

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::GetLastError()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::SaveChanges(::BRUTUS::BDEFINE ulFlags)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::SaveChanges()");

	unsigned long flags = native_flags(ulFlags);

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->SaveChanges(flags);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::SaveChanges()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::GetProps(const ::BRUTUS::SPropTagArray& lpPropTagArray,
						 ::BRUTUS::BDEFINE ulFlags,
						 ::BRUTUS::seq_SPropValue_out lppPropArray)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::GetProps()");

	SPropTagArray *tags = NULL;
	proptag_array_brutus_to_mapi(&lpPropTagArray, 0, tags);
	unsigned long flags = native_flags(ulFlags);
	SPropValue *props = NULL;
	unsigned long count = 0;

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetProps(tags, flags, &count, &props);
	}
	MAPIFreeBuffer(tags);

	::BRUTUS::seq_SPropValue_var brutus_props;
	try {
		brutus_props = new ::BRUTUS::seq_SPropValue;
	}
	catch (std::bad_alloc &) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	brutus_props->length(0);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		lppPropArray = brutus_props._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	spropvalue_array_mapi_to_brutus(count, props, brutus_props, mapi_session_, true, poa_);
	lppPropArray = brutus_props._retn();

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::GetProps()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::GetPropList(::BRUTUS::BDEFINE ulFlags,
						    ::BRUTUS::SPropTagArray_out lppPropTagArray)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::GetPropList()");

	SPropTagArray *tags = NULL;
	unsigned long flags = native_flags(ulFlags);

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetPropList(flags,
					       &tags);
	}

	::BRUTUS::SPropTagArray_var brutus_tags;
	if (!proptag_array_mapi_to_brutus(tags, brutus_tags.out(), true)) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	lppPropTagArray = brutus_tags._retn();

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		br = ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::GetPropList()");
	return br;
}

// FIXME. Support for all possible interfaces are misssing
::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::OpenProperty(::CORBA::ULong ulPropTag,
						     const char * lpiid,
						     ::CORBA::ULong ulInterfaceOptions,
						     ::BRUTUS::BDEFINE ulFlags,
						     ::BRUTUS::IUnknown_out lppUnk)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::OpenProperty()");

	lppUnk = ::BRUTUS::IUnknown::_nil();

	unsigned long tag;
	proptag_brutus_to_mapi(ulPropTag, tag);

	GUID id;
	if (!guid_brutus_to_mapi_no_alloc(lpiid, &id)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into MAPI GUID");
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	unsigned long options = (unsigned long)ulInterfaceOptions;
	unsigned long flags = native_flags(ulFlags);

	LPUNKNOWN unknown = NULL;

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->OpenProperty(tag, &id, options, flags, &unknown);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}
	if (S_OK != hr)
		return br;

	bool create_result = false;
	try {
		if (S_OK == hr)
			create_result = create_brutus_object(lpiid, unknown, poa_, lppUnk, mapi_session_);
		else if (unknown) {
			unknown->Release();
			unknown = NULL;
		}
	}
	catch (...) {
		BRUTUS_LOG_BUG("Exception caught");
	}

	if (!create_result) {
		BRUTUS_LOG_BUG("Could not convert MAPI object into BRUTUS object");
		if (unknown)
			unknown->Release();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::OpenProperty()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::SetProps(const ::BRUTUS::seq_SPropValue & lpPropArray,
						 ::CORBA::Boolean ProblemInfo,
						 ::BRUTUS::SPropProblemArray_out lppProblems)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::SetProps()");

	unsigned long count = 0;
	SPropValue *mapi_props = NULL;
	::BRUTUS::SPropProblemArray_var brutus_problems;
	try {
		brutus_problems = new ::BRUTUS::SPropProblemArray;
	}
	catch (std::bad_alloc &) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	brutus_problems->length(0);

	if (!spropvalue_array_brutus_to_mapi(&lpPropArray, 0, count, mapi_props)) {
		MAPIFreeBuffer(mapi_props);
		BRUTUS_LOG_ERR("Could not convert Brutus SPropValue to MAPI SPropValue");
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	HRESULT hr;
	LPSPropProblemArray mapi_problems = NULL;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->SetProps(count, mapi_props, (ProblemInfo ? &mapi_problems : NULL));
	}
	MAPIFreeBuffer(mapi_props);

	if (!sPropProblem_array_mapi_to_brutus(mapi_problems, brutus_problems.inout(), true)) {
		BRUTUS_LOG_ERR("Could not convert MAPI SPropProblemArray to Brutus SPropProblemArray");
		brutus_problems->length(0);
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}
	lppProblems = brutus_problems._retn();

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::SetProps()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::DeleteProps(const ::BRUTUS::SPropTagArray & lpPropTagArray,
						    ::CORBA::Boolean ProblemInfo,
						    ::BRUTUS::SPropProblemArray_out lppProblems)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::DeleteProps()");

	::BRUTUS::SPropProblemArray_var brutus_problems;
	try {
		brutus_problems = new ::BRUTUS::SPropProblemArray;
	}
	catch (std::bad_alloc &) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	brutus_problems->length(0);

	SPropTagArray *tags = NULL;
	if (!proptag_array_brutus_to_mapi(&lpPropTagArray, 0, tags)) {
		BRUTUS_LOG_ERR("Could not convert Brutus SPropTagArray to MAPI SPropTagArray");
		MAPIFreeBuffer(tags);
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	HRESULT hr;
	LPSPropProblemArray mapi_problems = NULL;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->DeleteProps(tags, (ProblemInfo ? &mapi_problems : NULL));
	}
	MAPIFreeBuffer(tags);

	if (!sPropProblem_array_mapi_to_brutus(mapi_problems, brutus_problems.inout(), true)) {
		BRUTUS_LOG_ERR("Could not convert MAPI SPropProblemArray to Brutus SPropProblemArray");
		brutus_problems->length(0);
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}
	lppProblems = brutus_problems._retn();

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::DeleteProps()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::CopyTo(const ::BRUTUS::seq_GUID & rgiidExclude,
					       const ::BRUTUS::SPropTagArray & lpExcludeProps,
					       ::BRUTUS::IMAPIProgress_ptr lpProgress,
					       const char * lpInterface,
					       const ::BRUTUS::ENTRYID & lpDestObj,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::CORBA::Boolean ProblemInfo,
					       ::BRUTUS::SPropProblemArray_out lppProblems)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::CopyTo()");

	::BRUTUS::SPropProblemArray_var brutus_problems;
	try {
		brutus_problems = new ::BRUTUS::SPropProblemArray;
	}
	catch (std::bad_alloc &) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	brutus_problems->length(0);

	GUID *guids = NULL;
	unsigned long count = rgiidExclude.length();
	if (count) {
		if (!guid_array_brutus_to_mapi(&rgiidExclude, 0, guids)) {
			BRUTUS_LOG_ERR("Could not convert Brutus GUID to MAPI GUID");
			lppProblems = brutus_problems._retn();
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}

	SPropTagArray *exc_tags = NULL;
	if (lpExcludeProps.length()) {
		if (!proptag_array_brutus_to_mapi(&lpExcludeProps, 0, exc_tags)) {
			BRUTUS_LOG_ERR("Could not convert Brutus SPropTagArray to MAPI SPropTagArray");
			MAPIFreeBuffer(guids);
			lppProblems = brutus_problems._retn();
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}
	ULONG flags = native_flags(ulFlags);

	CMAPIProgress *progress = NULL;
	if ((flags & MAPI_DIALOG) && !::CORBA::is_nil(lpProgress)) {
		try {
			progress = new CMAPIProgress(lpProgress);
		}
		catch (std::bad_alloc &) {
			BRUTUS_LOG_ERR("No memory");
			MAPIFreeBuffer(exc_tags);
			MAPIFreeBuffer(guids);
			lppProblems = brutus_problems._retn();
			return ::BRUTUS::BRUTUS_MAPI_E_NOT_ENOUGH_MEMORY;
		}
	} else
		FLAGS_OFF(ULONG, flags, MAPI_DIALOG);

	GUID i_id;
	if (!guid_brutus_to_mapi_no_alloc(lpInterface, &i_id)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into GUID");
		if (progress)
			progress->Release();
		MAPIFreeBuffer(exc_tags);
		MAPIFreeBuffer(guids);
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	ENTRYID *entry_id = NULL;
	unsigned long entry_id_size;
	if (!entryid_brutus_to_mapi(&lpDestObj, 0, entry_id_size, entry_id)) {
		BRUTUS_LOG_ERR("No memory");
		if (progress)
			progress->Release();
		MAPIFreeBuffer(exc_tags);
		MAPIFreeBuffer(guids);
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_MAPI_E_NOT_ENOUGH_MEMORY;
	}

	LPUNKNOWN unk_dest_object = NULL;
	HRESULT hr;
	{
		unsigned long obj_type;
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_session_->OpenEntry(entry_id_size,
					      entry_id,
					      &i_id,
					      MAPI_MODIFY,
					      &obj_type,
					      &unk_dest_object);
	}
	::BRUTUS::BRESULT br;
	if (hr != S_OK) {
		if (!hresult_to_bresult(hr, br)) {
			BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
			br = ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
		BRUTUS_LOG_BUG("Error opening object");
		if (progress)
			progress->Release();
		if (unk_dest_object)
			unk_dest_object->Release();

		MAPIFreeBuffer(exc_tags);
		MAPIFreeBuffer(guids);
		lppProblems = brutus_problems._retn();
		return br;
	}

	LPSPropProblemArray mapi_problems = NULL;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->CopyTo(count,
					  guids,
					  exc_tags,
					  0, // UI handle
					  progress,
					  &i_id,
					  unk_dest_object,
					  flags,
					  (ProblemInfo ? &mapi_problems : NULL));
	}
	if (progress)
		progress->Release();
	if (unk_dest_object)
		unk_dest_object->Release();
	MAPIFreeBuffer(exc_tags);
	MAPIFreeBuffer(guids);

	if (!sPropProblem_array_mapi_to_brutus(mapi_problems, brutus_problems.inout(), true)) {
		BRUTUS_LOG_ERR("Could not convert MAPI SPropProblemArray to Brutus SPropProblemArray");
		brutus_problems->length(0);
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}
	lppProblems = brutus_problems._retn();

	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::CopyTo()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::CopyProps(const ::BRUTUS::SPropTagArray & lpIncludeProps,
						  ::BRUTUS::IMAPIProgress_ptr lpProgress,
						  const char * lpInterface,
						  const ::BRUTUS::ENTRYID &lpDestObj,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::CORBA::Boolean ProblemInfo,
						  ::BRUTUS::SPropProblemArray_out lppProblems)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::CopyProps()");

	::BRUTUS::SPropProblemArray_var brutus_problems;
	try {
		brutus_problems = new ::BRUTUS::SPropProblemArray;
	}
	catch (std::bad_alloc &) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	brutus_problems->length(0);

	GUID i_id;
	if (!guid_brutus_to_mapi_no_alloc(lpInterface, &i_id)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into GUID");
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	SPropTagArray *inc_tags = NULL;
	if (lpIncludeProps.length()) {
		if (!proptag_array_brutus_to_mapi(&lpIncludeProps, 0, inc_tags)) {
			BRUTUS_LOG_ERR("Could not convert Brutus SPropTagArray to MAPI SPropTagArray");
			lppProblems = brutus_problems._retn();
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}

	ULONG flags = native_flags(ulFlags);

	CMAPIProgress *progress = NULL;
	if ((flags & MAPI_DIALOG) && !::CORBA::is_nil(lpProgress)) {
		try {
			progress = new CMAPIProgress(lpProgress);
		}
		catch (std::bad_alloc &) {
			BRUTUS_LOG_ERR("No memory");
			MAPIFreeBuffer(inc_tags);
			lppProblems = brutus_problems._retn();
			return ::BRUTUS::BRUTUS_MAPI_E_NOT_ENOUGH_MEMORY;
		}
	} else
		FLAGS_OFF(ULONG, flags, MAPI_DIALOG);

	ENTRYID *entry_id = NULL;
	unsigned long entry_id_size;
	if (!entryid_brutus_to_mapi(&lpDestObj, 0, entry_id_size, entry_id)) {
		BRUTUS_LOG_ERR("No memory");
		MAPIFreeBuffer(inc_tags);
		if (progress)
			progress->Release();
		throw ::CORBA::NO_MEMORY();
	}

	LPUNKNOWN unk_dest_object = NULL;
	HRESULT hr;
	{
		unsigned long obj_type;
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_session_->OpenEntry(entry_id_size,
					      entry_id,
					      &i_id,
					      MAPI_MODIFY,
					      &obj_type,
					      &unk_dest_object);
	}
	::BRUTUS::BRESULT br;
	if (hr != S_OK) {
		if (!hresult_to_bresult(hr, br)) {
			BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
			br = ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
		BRUTUS_LOG_BUG("Error opening object");
		if (progress)
			progress->Release();
		if (unk_dest_object)
			unk_dest_object->Release();

		MAPIFreeBuffer(inc_tags);
		lppProblems = brutus_problems._retn();

		return br;
	}

	LPSPropProblemArray mapi_problems = NULL;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->CopyProps(inc_tags,
					     0, // UI handle
					     progress,
					     &i_id,
					     unk_dest_object,
					     flags,
					     (ProblemInfo ? &mapi_problems : NULL));
	}
	MAPIFreeBuffer(inc_tags);
	if (progress)
		progress->Release();
	if (unk_dest_object)
		unk_dest_object->Release();

	if (!sPropProblem_array_mapi_to_brutus(mapi_problems, brutus_problems.inout(), true)) {
		BRUTUS_LOG_ERR("Could not convert MAPI SPropProblemArray to Brutus SPropProblemArray");
		brutus_problems->length(0);
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}
	lppProblems = brutus_problems._retn();

	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::CopyProps()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::GetNamesFromIDs(::BRUTUS::SPropTagArray & lppPropTags,
							const char * lpPropSetGuid,
							::BRUTUS::BDEFINE ulFlags,
							::BRUTUS::seq_MAPINAMEID_out lpppPropNames)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::GetNamesFromIDs()");

	::BRUTUS::seq_MAPINAMEID_var brutus_names;
	try {
		brutus_names = new ::BRUTUS::seq_MAPINAMEID;
	}
	catch (std::bad_alloc &) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	brutus_names->length(0);

	SPropTagArray *tags = NULL;
	if (lppPropTags.length())
		proptag_array_brutus_to_mapi(&lppPropTags, 0, tags);

	GUID *i_id;
	if (!guid_brutus_to_mapi(lpPropSetGuid, NULL, i_id)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into GUID");
		MAPIFreeBuffer(tags);
		lpppPropNames = brutus_names._retn();
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	unsigned long flags = native_flags(ulFlags);

	unsigned long count = 0;
	MAPINAMEID **mapi_names = NULL;

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetNamesFromIDs(&tags, i_id, flags, &count, &mapi_names);
	}
	MAPIFreeBuffer(i_id);

	if (!proptag_array_mapi_to_brutus(tags, lppPropTags, true)) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}

	nameid_array_mapi_to_brutus(count, mapi_names, brutus_names, true);
	lpppPropNames = brutus_names._retn();

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::GetNamesFromIDs()");
	return br;
}


::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::GetIDsFromNames(const ::BRUTUS::seq_MAPINAMEID & lppPropNames,
							::BRUTUS::BDEFINE ulFlags,
							::BRUTUS::SPropTagArray_out lppPropTags)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::GetIDsFromNames()");

	unsigned long count = lppPropNames.length();
	::LPMAPINAMEID *mapi_names = NULL;
	nameid_array_brutus_to_mapi(&lppPropNames, 0, mapi_names);

	unsigned long flags = native_flags(ulFlags);

	SPropTagArray *tags = NULL;

	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetIDsFromNames(count,
						   mapi_names,
						   flags,
						   &tags);
	}
	MAPIFreeBuffer(mapi_names);

	::BRUTUS::SPropTagArray_var brutus_tags;
	if (!proptag_array_mapi_to_brutus(tags, brutus_tags.out(), true)) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	lppPropTags = brutus_tags._retn();

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::GetIDsFromNames()");
	return br;
}

::BRUTUS::BRESULT
BRUTUS_IMAPIFolder_i::GetNamedProps(const char *PropSetGuid,
				    const ::BRUTUS::seq_NamedPropertyTag & lpPropTagArray,
				    ::BRUTUS::BDEFINE ulFlags,
				    ::BRUTUS::seq_SPropValue_out lppPropArray)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::GetNamedProps()");

	unsigned long flags = 0;
	SPropValue *props = NULL;
	unsigned long count = 0;

	::BRUTUS::seq_SPropValue_var brutus_props;
	try {
		brutus_props = new ::BRUTUS::seq_SPropValue;
	}
	catch (std::bad_alloc &) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	brutus_props->length(0);

	GUID mapi_propset_guid;
	if (!guid_brutus_to_mapi_no_alloc(PropSetGuid, &mapi_propset_guid, false)) {
		lppPropArray = brutus_props._retn();
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	::LPMAPINAMEID *mapi_names = NULL;
	if (S_OK != MAPIAllocateBuffer(lpPropTagArray.length()*sizeof(::MAPINAMEID*),
				       (void**)&mapi_names)) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}

	ULONG n = 0;
	for (n = 0; n < lpPropTagArray.length(); n++) {
		if (S_OK != MAPIAllocateMore(sizeof(::MAPINAMEID),
					     mapi_names,
					     (void**)&(mapi_names[n]))) {
			BRUTUS_LOG_ERR("No memory");
			MAPIFreeBuffer(mapi_names);
			throw ::CORBA::NO_MEMORY();
		}
	}

	for (n = 0; n < lpPropTagArray.length(); n++) {
		mapi_names[n]->lpguid = (LPGUID)&mapi_propset_guid;
		switch (lpPropTagArray[n].name._d()) {
		case ::BRUTUS::BRUTUS_ID_INTEGER :
			mapi_names[n]->ulKind = MNID_ID;
			mapi_names[n]->Kind.lID = lpPropTagArray[n].name.int_name();
			break;
		case ::BRUTUS::BRUTUS_ID_STRING :
			mapi_names[n]->ulKind = MNID_STRING;
			mapi_names[n]->Kind.lpwstrName = ascii_to_unicode((void*)mapi_names, (const char*)lpPropTagArray[n].name.str_name());
			if (!mapi_names[n]->Kind.lpwstrName) {
				BRUTUS_LOG_ERR("No memory");
				MAPIFreeBuffer(mapi_names);
				throw ::CORBA::NO_MEMORY();
			}
			break;
		default :
			BRUTUS_LOG_BUG("Unknown name kind");
			lppPropArray = brutus_props._retn();
			MAPIFreeBuffer(mapi_names);
			return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
		}
	}

	SPropTagArray *tags = NULL;
	HRESULT hr;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetIDsFromNames(lpPropTagArray.length(),
						   mapi_names,
						   MAPI_CREATE,
						   &tags);
	}
	MAPIFreeBuffer(mapi_names);

	if (!tags || (tags->cValues != lpPropTagArray.length())) {
		BRUTUS_LOG_ERR("Could not get PropTag ID from name");
		BRUTUS_EXIT;
	}
	if ((MAPI_W_ERRORS_RETURNED != hr) && (S_OK != hr))
		BRUTUS_EXIT;

	ULONG prop_id = 0;
	ULONG prop_type = 0;
	for (n = 0; n < tags->cValues; n++) {
		prop_id = PROP_ID(tags->aulPropTag[n]);
		prop_type = proptype_brutus_to_mapi(lpPropTagArray[n].type);
		tags->aulPropTag[n] = PROP_TAG(prop_type, prop_id);
	}

	flags = native_flags(ulFlags);
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetProps(tags,
					    flags,
					    &count,
					    &props);
	}

exit:
	MAPIFreeBuffer(tags);

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		lppPropArray = brutus_props._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	spropvalue_array_mapi_to_brutus(count, props, brutus_props, mapi_session_, true, poa_);
	lppPropArray = brutus_props._retn();

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::GetNamedProps()");
	return br;
}

::BRUTUS::BRESULT
BRUTUS_IMAPIFolder_i::SetNamedProps(const char *PropSetGuid,
				    const ::BRUTUS::seq_NamedPropertyTag & lpPropTagArray,
				    const ::BRUTUS::seq_SPropValue & lpPropArray,
				    ::CORBA::Boolean ProblemInfo,
				    ::BRUTUS::SPropProblemArray_out lppProblems)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::SetNamedProps()");

	unsigned long count = 0;
	SPropValue *mapi_props = NULL;
	::BRUTUS::SPropProblemArray_var brutus_problems;
	try {
		brutus_problems = new ::BRUTUS::SPropProblemArray;
	}
	catch (std::bad_alloc &) {
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}
	brutus_problems->length(0);

	if (!spropvalue_array_brutus_to_mapi(&lpPropArray, 0, count, mapi_props)) {
		MAPIFreeBuffer(mapi_props);
		BRUTUS_LOG_ERR("Could not convert Brutus SPropValue to MAPI SPropValue");
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	HRESULT hr;
	LPSPropProblemArray mapi_problems = NULL;

	GUID mapi_propset_guid;
	if (!guid_brutus_to_mapi_no_alloc(PropSetGuid, &mapi_propset_guid, false)) {
		MAPIFreeBuffer(mapi_props);
		MAPIFreeBuffer(mapi_problems);
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	::LPMAPINAMEID *mapi_names = NULL;
	if (S_OK != MAPIAllocateBuffer(lpPropArray.length()*sizeof(::MAPINAMEID*),
				       (void**)&mapi_names)) {
		MAPIFreeBuffer(mapi_props);
		MAPIFreeBuffer(mapi_problems);
		BRUTUS_LOG_ERR("No memory");
		throw ::CORBA::NO_MEMORY();
	}

	ULONG n = 0;
	for (n = 0; n < lpPropArray.length(); n++) {
		if (S_OK != MAPIAllocateMore(sizeof(::MAPINAMEID),
					     mapi_names,
					     (void**)&(mapi_names[n]))) {
			BRUTUS_LOG_ERR("No memory");
			MAPIFreeBuffer(mapi_names);
			throw ::CORBA::NO_MEMORY();
		}
	}

	for (n = 0; n < lpPropTagArray.length(); n++) {
		mapi_names[n]->lpguid = (LPGUID)&mapi_propset_guid;
		switch (lpPropTagArray[n].name._d()) {
		case ::BRUTUS::BRUTUS_ID_INTEGER :
			mapi_names[n]->ulKind = MNID_ID;
			mapi_names[n]->Kind.lID = lpPropTagArray[n].name.int_name();
			break;
		case ::BRUTUS::BRUTUS_ID_STRING :
			mapi_names[n]->ulKind = MNID_STRING;
			mapi_names[n]->Kind.lpwstrName = ascii_to_unicode((void*)mapi_names, (const char*)lpPropTagArray[n].name.str_name());
			if (!mapi_names[n]->Kind.lpwstrName) {
				BRUTUS_LOG_ERR("No memory");
				MAPIFreeBuffer(mapi_names);
				throw ::CORBA::NO_MEMORY();
			}
			break;
		default :
			BRUTUS_LOG_BUG("Unknown name kind");
			MAPIFreeBuffer(mapi_props);
			MAPIFreeBuffer(mapi_problems);
			MAPIFreeBuffer(mapi_names);
			lppProblems = brutus_problems._retn();
			return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
		}
	}

	SPropTagArray *tags = NULL;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->GetIDsFromNames(lpPropTagArray.length(),
						   mapi_names,
						   MAPI_CREATE,
						   &tags);
	}
	MAPIFreeBuffer(mapi_names);

	if (!tags || (tags->cValues != lpPropArray.length())) {
		BRUTUS_LOG_ERR("Could not get PropTag ID from name");
		BRUTUS_EXIT;
	}
	if ((MAPI_W_ERRORS_RETURNED != hr) && (S_OK != hr))
		BRUTUS_EXIT;

	ULONG prop_id = 0;
	ULONG prop_type = 0;
	for (n = 0; n < tags->cValues; n++) {
		prop_id = PROP_ID(tags->aulPropTag[n]);
		prop_type = proptype_brutus_to_mapi(lpPropTagArray[n].type);
		mapi_props[n].ulPropTag = PROP_TAG(prop_type, prop_id);
	}

	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr = mapi_folder_->SetProps(lpPropArray.length(),
					    mapi_props,
					    (ProblemInfo ? &mapi_problems : NULL));
	}

exit:
	MAPIFreeBuffer(mapi_props);
	MAPIFreeBuffer(tags);

	if (!sPropProblem_array_mapi_to_brutus(mapi_problems, brutus_problems.inout(), true)) {
		BRUTUS_LOG_ERR("Could not convert MAPI SPropProblemArray to Brutus SPropProblemArray");
		brutus_problems->length(0);
		lppProblems = brutus_problems._retn();
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}
	lppProblems = brutus_problems._retn();

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::SetNamedProps()");
	return br;
}

::BRUTUS::BRESULT BRUTUS_IMAPIFolder_i::QueryInterface(const char *iid,
						       ::BRUTUS::IUnknown_out ppvObject)
{
	ppvObject = ::BRUTUS::IUnknown::_nil();

	GUID mapi_iid;
	if (!guid_brutus_to_mapi_no_alloc(iid, &mapi_iid)) {
		BRUTUS_LOG_BUG("Could not convert ::BRUTUS::GUID into MAPI GUID");
		return ::BRUTUS::BRUTUS_MAPI_E_INVALID_PARAMETER;
	}

	HRESULT hr;
	void *object = NULL;
	{
		ACE_Write_Guard<ACE_RW_Mutex> guard(mutex_);
		hr =  mapi_folder_->QueryInterface(mapi_iid, &object);
	}

	::BRUTUS::BRESULT br;
	if (!hresult_to_bresult(hr, br)) {
		BRUTUS_LOG_BUG("Could not convert HRESULT into BRESULT");
		return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
	}

	if (hr == S_OK) {
		if (!create_brutus_object(iid, (LPUNKNOWN)object, poa_, ppvObject, mapi_session_)) {
			BRUTUS_LOG_BUG("Could not create brutus object.");
			((LPUNKNOWN)object)->Release();
			return ::BRUTUS::BRUTUS_INTERNAL_ERROR;
		}
	}

	return br;
}

void BRUTUS_IMAPIFolder_i::Destroy(::CORBA::ULong InstanceID)
{
	BRUTUS_LOG_INF("Entering BRUTUS_IMAPIFolder_i::Destroy()");

	::PortableServer::ObjectId_var oid;
	oid = poa_->servant_to_id(this);

	poa_->deactivate_object(oid);

	BRUTUS_LOG_INF("Leaving BRUTUS_IMAPIFolder_i::Destroy()");
}
