/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef __IMESSAGES_IMPL_H_
#define __IMESSAGES_IMPL_H_

#include "IMessageS.h"
#include "utils/macros.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>

#include "Brutus_Loader_Impl_Export.h"

class Brutus_Loader_Impl_Export BRUTUS_IMessage_i : public virtual POA_BRUTUS::IMessage,
						    public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_IMessage_i::BRUTUS_IMessage_i(LPMESSAGE Message,
					     LPMAPISESSION MAPISession,
					     ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BRESULT GetAttachmentTable(::BRUTUS::BDEFINE ulFlags,
						     ::BRUTUS::IMAPITable_out lppTable);

	virtual ::BRUTUS::BRESULT OpenAttach(::CORBA::ULong ulAttachmentNum,
					     const char * lpInterface,
					     ::BRUTUS::BDEFINE ulFlags,
					     ::BRUTUS::IUnknown_out lppAttach);

	virtual ::BRUTUS::BRESULT CreateAttach(const char * lpInterface,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::CORBA::ULong_out lpulAttachmentNum,
					       ::BRUTUS::IUnknown_out lppAttach);

	virtual ::BRUTUS::BRESULT DeleteAttach(::CORBA::ULong ulAttachmentNum,
					       ::BRUTUS::IMAPIProgress_ptr lpProgress,
					       ::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT GetRecipientTable(::BRUTUS::BDEFINE ulFlags,
						    ::BRUTUS::IMAPITable_out lppTable);

	virtual ::BRUTUS::BRESULT ModifyRecipients(::BRUTUS::BDEFINE ulFlags,
						   const ::BRUTUS::ADRLIST & lpMods);

	virtual ::BRUTUS::BRESULT SubmitMessage(::BRUTUS::BDEFINE ulFlags,
						::BRUTUS::OUTLOOK_FOLDER Fate);

	virtual ::BRUTUS::BRESULT SetReadFlag(::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT GetLastError(::BRUTUS::BRESULT ReturnCode,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::MAPIERROR_out lppMAPIError);

	virtual ::BRUTUS::BRESULT SaveChanges(::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT GetProps(const ::BRUTUS::SPropTagArray & lpPropTagArray,
					   ::BRUTUS::BDEFINE ulFlags,
					   ::BRUTUS::seq_SPropValue_out lppPropArray);

	virtual ::BRUTUS::BRESULT GetPropList(::BRUTUS::BDEFINE ulFlags,
					      ::BRUTUS::SPropTagArray_out lppPropTagArray);

	virtual ::BRUTUS::BRESULT OpenProperty(::CORBA::ULong ulPropTag,
					       const char * lpiid,
					       ::CORBA::ULong ulInterfaceOptions,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::IUnknown_out lppUnk);

	virtual ::BRUTUS::BRESULT SetProps(const ::BRUTUS::seq_SPropValue & lpPropArray,
					   ::CORBA::Boolean ProblemInfo,
					   ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT DeleteProps(const ::BRUTUS::SPropTagArray & lpPropTagArray,
					      ::CORBA::Boolean ProblemInfo,
					      ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT CopyTo(const ::BRUTUS::seq_GUID & rgiidExclude,
					 const ::BRUTUS::SPropTagArray & lpExcludeProps,
					 ::BRUTUS::IMAPIProgress_ptr lpProgress,
					 const char * lpInterface,
					 const ::BRUTUS::ENTRYID & lpDestObj,
					 ::BRUTUS::BDEFINE ulFlags,
					 ::CORBA::Boolean ProblemInfo,
					 ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT CopyProps(const ::BRUTUS::SPropTagArray & lpIncludeProps,
					    ::BRUTUS::IMAPIProgress_ptr lpProgress,
					    const char * lpInterface,
					    const ::BRUTUS::ENTRYID & lpDestObj,
					    ::BRUTUS::BDEFINE ulFlags,
					    ::CORBA::Boolean ProblemInfo,
					    ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT GetNamesFromIDs(::BRUTUS::SPropTagArray & lppPropTags,
						  const char * lpPropSetGuid,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::BRUTUS::seq_MAPINAMEID_out lpppPropNames);

	virtual ::BRUTUS::BRESULT GetIDsFromNames(const ::BRUTUS::seq_MAPINAMEID & lppPropNames,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::BRUTUS::SPropTagArray_out lppPropTags);

	virtual ::BRUTUS::BRESULT SetRFC822Headers(const ::BRUTUS::seq_string & FieldNames,
						   const ::BRUTUS::seq_string & FieldBodies);

	virtual ::BRUTUS::BRESULT GetNamedProps(const char *PropSetGuid,
						const ::BRUTUS::seq_NamedPropertyTag & lpPropTagArray,
						::BRUTUS::BDEFINE ulFlags,
						::BRUTUS::seq_SPropValue_out lppPropArray);

	virtual ::BRUTUS::BRESULT SetNamedProps(const char *PropSetGuid,
						const ::BRUTUS::seq_NamedPropertyTag & lpPropTagArray,
						const ::BRUTUS::seq_SPropValue & lpPropArray,
						::CORBA::Boolean ProblemInfo,
						::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT GetLocalPointer(::CORBA::ULongLong_out Pointer);

	virtual ::BRUTUS::BRESULT GetRecurrenceState(::CORBA::Boolean is_event,
						     ::BRUTUS::RecurrenceState_out state);

	virtual ::BRUTUS::BRESULT GetRecurrenceExceptions(::CORBA::Boolean is_event,
							  const ::BRUTUS::FILETIME & start,
							  ::BRUTUS::OccurrenceTimeType time_format,
							  ::BRUTUS::seq_RecurrenceExceptionData_out exception_data_set);

	virtual ::BRUTUS::BRESULT SetRecurrencePattern(::CORBA::Boolean is_event,
						       const ::BRUTUS::FILETIME & start,
						       const ::BRUTUS::OccurrenceTime & end,
						       ::CORBA::ULong duration,
						       ::BRUTUS::DayOfWeek first_day_of_week,
						       ::BRUTUS::RecurrenceTerminationType how_to_end,
						       const ::BRUTUS::RecurrencePattern & pattern);

	virtual ::BRUTUS::BRESULT SetRecurrenceException(::CORBA::Boolean is_event,
							 const ::BRUTUS::FILETIME & start,
							 ::CORBA::ULong duration,
							 const ::BRUTUS::seq_RecurrenceExceptionData & exception_data_set);

	virtual ::BRUTUS::BRESULT RemoveRecurrenceException(::CORBA::Boolean is_event,
							    const ::BRUTUS::FILETIME & start,
							    ::CORBA::ULong duration,
							    const ::BRUTUS::OccurrenceTime & oc_time);

	virtual ::BRUTUS::BRESULT QueryInterface(const char *iid,
						 ::BRUTUS::IUnknown_out ppvObject);

	virtual void Destroy(::CORBA::ULong InstanceID);

private:

	BRUTUS_IMessage_i(void)
	{ };

	virtual ~BRUTUS_IMessage_i(void)
	{
		try {
			message_->Release();
			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	LPMESSAGE message_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;

	ULONG recurrence_proptag_;

	ACE_RW_Mutex mutex_;
};


#endif /* __IMESSAGES_IMPL_H_  */
