/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef __IMSGSTORES_IMPL_H_
#define __IMSGSTORES_IMPL_H_

#include "IMsgStoreS.h"
#include "utils/macros.h"
#include "advise_utils.h"
#include "guid.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>

#include "Brutus_Loader_Impl_Export.h"

class Brutus_Loader_Impl_Export BRUTUS_IMsgStore_i : public virtual POA_BRUTUS::IMsgStore,
						     public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_IMsgStore_i(LPMDB MsgStore,
			   LPMAPISESSION MAPISession,
			   ::PortableServer::POA_ptr Poa);


	virtual ::BRUTUS::BRESULT Advise(const ::BRUTUS::ENTRYID & lpEntryID,
					 ::BRUTUS::BDEFINE ulEventMask,
					 ::BRUTUS::IMAPIAdviseSink_ptr lpAdviseSink,
					 ::CORBA::ULong_out lpulConnection);

	virtual ::BRUTUS::BRESULT Unadvise(::CORBA::ULong ulConnection);

	virtual ::BRUTUS::BRESULT CompareEntryIDs(const ::BRUTUS::ENTRYID & lpEntryID1,
						  const ::BRUTUS::ENTRYID & lpEntryID2,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::CORBA::Boolean_out lpulResult);

	virtual ::BRUTUS::BRESULT OpenEntry(const ::BRUTUS::ENTRYID & lpEntryID,
					    const char * lpInterface,
					    ::BRUTUS::BDEFINE ulFlags,
					    ::CORBA::ULong_out lpulObjType,
					    ::BRUTUS::IUnknown_out lppUnk);

	virtual ::BRUTUS::BRESULT SetReceiveFolder(const char * lpszMessageClass,
						   ::BRUTUS::BDEFINE ulFlags,
						   const ::BRUTUS::ENTRYID & lpEntryID);

	virtual ::BRUTUS::BRESULT GetReceiveFolder(const char * lpszMessageClass,
						   ::BRUTUS::BDEFINE ulFlags,
						   ::BRUTUS::ENTRYID_out lppEntryID,
						   ::CORBA::String_out lppszExplicitClass);

	virtual ::BRUTUS::BRESULT GetReceiveFolderTable(::BRUTUS::BDEFINE ulFlags,
							::BRUTUS::IMAPITable_out lppTable);

	virtual ::BRUTUS::BRESULT StoreLogoff(::BRUTUS::BDEFINE & lpulFlags);

	virtual ::BRUTUS::BRESULT AbortSubmit(const ::BRUTUS::ENTRYID & lpEntryID,
					      ::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT GetOutgoingQueue(::BRUTUS::BDEFINE ulFlags,
						   ::BRUTUS::IMAPITable_out lppTable);

	virtual ::BRUTUS::BRESULT SetLockState(const ::BRUTUS::ENTRYID & Message,
					       ::CORBA::ULong ulLockState);

	virtual ::BRUTUS::BRESULT FinishedMsg(::BRUTUS::BDEFINE ulFlags,
					      const ::BRUTUS::ENTRYID & lpEntryID);

	virtual ::BRUTUS::BRESULT NotifyNewMail(void);

	virtual ::BRUTUS::BRESULT GetLastError(::BRUTUS::BRESULT ReturnCode,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::MAPIERROR_out lppMAPIError);

	virtual ::BRUTUS::BRESULT SaveChanges(::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT GetProps(const ::BRUTUS::SPropTagArray & lpPropTagArray,
					   ::BRUTUS::BDEFINE ulFlags,
					   ::BRUTUS::seq_SPropValue_out lppPropArray);

	virtual ::BRUTUS::BRESULT GetPropList(::BRUTUS::BDEFINE ulFlags,
					      ::BRUTUS::SPropTagArray_out lppPropTagArray);

	virtual ::BRUTUS::BRESULT OpenProperty(::CORBA::ULong ulPropTag,
					       const char * lpiid,
					       ::CORBA::ULong ulInterfaceOptions,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::IUnknown_out lppUnk);

	virtual ::BRUTUS::BRESULT SetProps(const ::BRUTUS::seq_SPropValue & lpPropArray,
					   ::CORBA::Boolean ProblemInfo,
					   ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT DeleteProps(const ::BRUTUS::SPropTagArray & lpPropTagArray,
					      ::CORBA::Boolean ProblemInfo,
					      ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT CopyTo(const ::BRUTUS::seq_GUID & rgiidExclude,
					 const ::BRUTUS::SPropTagArray & lpExcludeProps,
					 ::BRUTUS::IMAPIProgress_ptr lpProgress,
					 const char * lpInterface,
					 const ::BRUTUS::ENTRYID & lpDestObj,
					 ::BRUTUS::BDEFINE ulFlags,
					 ::CORBA::Boolean ProblemInfo,
					 ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT CopyProps(const ::BRUTUS::SPropTagArray & lpIncludeProps,
					    ::BRUTUS::IMAPIProgress_ptr lpProgress,
					    const char * lpInterface,
					    const ::BRUTUS::ENTRYID & lpDestObj,
					    ::BRUTUS::BDEFINE ulFlags,
					    ::CORBA::Boolean ProblemInfo,
					    ::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT GetNamesFromIDs(::BRUTUS::SPropTagArray & lppPropTags,
						  const char * lpPropSetGuid,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::BRUTUS::seq_MAPINAMEID_out lpppPropNames);

	virtual ::BRUTUS::BRESULT GetIDsFromNames(const ::BRUTUS::seq_MAPINAMEID & lppPropNames,
						  ::BRUTUS::BDEFINE ulFlags,
						  ::BRUTUS::SPropTagArray_out lppPropTags);

	virtual ::BRUTUS::BRESULT GetNamedProps(const char *PropSetGuid,
						const ::BRUTUS::seq_NamedPropertyTag & lpPropTagArray,
						::BRUTUS::BDEFINE ulFlags,
						::BRUTUS::seq_SPropValue_out lppPropArray);

	virtual ::BRUTUS::BRESULT SetNamedProps(const char *PropSetGuid,
						const ::BRUTUS::seq_NamedPropertyTag & lpPropTagArray,
						const ::BRUTUS::seq_SPropValue & lpPropArray,
						::CORBA::Boolean ProblemInfo,
						::BRUTUS::SPropProblemArray_out lppProblems);

	virtual ::BRUTUS::BRESULT GetIExchangeManageStore(::BRUTUS::IExchangeManageStore_out MngStore);

	virtual ::BRUTUS::BRESULT GetLocalPointer(::CORBA::ULongLong_out Pointer);

	virtual ::BRUTUS::BRESULT QueryInterface(const char *iid,
						 ::BRUTUS::IUnknown_out ppvObject);

	virtual void Destroy(::CORBA::ULong InstanceID);

private:
	BRUTUS_IMsgStore_i(void)
	{ };

	virtual ~BRUTUS_IMsgStore_i(void)
	{
		try {
			for (unsigned long n = 0; n < advise_sinks_.length(); n++)
				msg_store_->Unadvise(advise_sinks_[n]);
			advise_sinks_.Clear();

			msg_store_->Release();
			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	LPMDB msg_store_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;

	Sinks advise_sinks_;
	ACE_RW_Mutex mutex_;
};


#endif /* __IMSGSTORES_IMPL_H_  */
