/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef __IPROFADMINS_IMPL_H_
#define __IPROFADMINS_IMPL_H_

#include "IProfAdminS.h"
#include "utils/macros.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>

#include "Brutus_Loader_Impl_Export.h"

class Brutus_Loader_Impl_Export BRUTUS_IProfAdmin_i : public virtual POA_BRUTUS::IProfAdmin,
						      public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_IProfAdmin_i(LPPROFADMIN ABLogon,
			    LPMAPISESSION MAPISession,
			    ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BRESULT GetLastError(::BRUTUS::BRESULT ReturnCode,
					       ::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::MAPIERROR_out lppMAPIError);

	virtual ::BRUTUS::BRESULT GetProfileTable(::BRUTUS::BDEFINE ulFlags,
						  ::BRUTUS::IMAPITable_out lppTable);

	virtual ::BRUTUS::BRESULT CreateProfile(const char * lpszProfileName,
						const char * lpszPassword,
						::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT DeleteProfile(const char * lpszProfileName,
						::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT ChangeProfilePassword(const char * lpszProfileName,
							const char * lpszOldPassword,
							const char * lpszNewPassword,
							::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT CopyProfile(const char * lpszOldProfileName,
					      const char * lpszOldPassword,
					      const char * lpszNewProfileName,
					      ::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT RenameProfile(const char * lpszOldProfileName,
						const char * lpszOldPassword,
						const char * lpszNewProfileName,
						::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT SetDefaultProfile(const char * lpszProfileName,
						    ::BRUTUS::BDEFINE ulFlags);

	virtual ::BRUTUS::BRESULT AdminServices(const char * lpszProfileName,
						const char * lpszPassword,
						::BRUTUS::BDEFINE ulFlags,
						::BRUTUS::IMsgServiceAdmin_out lppServiceAdmin);

	virtual ::BRUTUS::BRESULT QueryInterface(const char *iid,
						 ::BRUTUS::IUnknown_out ppvObject);

	virtual void Destroy(::CORBA::ULong InstanceID);

private:
	// Skeleton constructor
	BRUTUS_IProfAdmin_i(void)
	{ };

	virtual ~BRUTUS_IProfAdmin_i(void)
	{
		try {
			prof_admin_->Release();
			if (mapi_session_)
				mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};


	LPPROFADMIN prof_admin_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;

	ACE_RW_Mutex mutex_;
};


#endif /* __IPROFADMINS_IMPL_H_  */
