/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef __ISTREAMS_IMPL_H_
#define __ISTREAMS_IMPL_H_

#include "IStreamS.h"
#include "utils/macros.h"

#include <objidl.h>
#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>

#include "Brutus_Loader_Impl_Export.h"

class Brutus_Loader_Impl_Export BRUTUS_IStream_i : public virtual POA_BRUTUS::IStream
{
public:

	BRUTUS_IStream_i(LPSTREAM Stream,
			 LPMAPISESSION MAPISession,
			 ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BRESULT Clone(::BRUTUS::IStream_out ppstm);

	virtual ::BRUTUS::BRESULT Commit(::BRUTUS::STGC grfCommitFlags);

	virtual ::BRUTUS::BRESULT CopyTo(::BRUTUS::IStream_ptr pstm,
					 ::CORBA::ULongLong cb,
					 ::CORBA::ULongLong_out pcbRead,
					 ::CORBA::ULongLong_out pcbWritten);

	virtual ::BRUTUS::BRESULT LockRegion(::CORBA::ULongLong libOffset,
					     ::CORBA::ULongLong cb,
					     ::BRUTUS::LOCKTYPE dwLockType);

	virtual ::BRUTUS::BRESULT Revert(void);

	virtual ::BRUTUS::BRESULT Seek(::CORBA::LongLong dlibMove,
				       ::BRUTUS::STREAM_SEEK dwOrigin,
				       ::CORBA::ULongLong_out plibNewPosition);

	virtual ::BRUTUS::BRESULT SetSize(::CORBA::ULongLong libNewSize);

	virtual ::BRUTUS::BRESULT Stat(::BRUTUS::STATSTG_out pstatstg,
				       ::BRUTUS::STATFLAG grfStatFlag);

	virtual ::BRUTUS::BRESULT UnlockRegion(::CORBA::ULongLong libOffset,
					       ::CORBA::ULongLong cb,
					       ::BRUTUS::LOCKTYPE dwLockType);

	virtual ::BRUTUS::BRESULT Read(::BRUTUS::seq_octet_out pv,
				       ::CORBA::ULong cb);

	virtual ::BRUTUS::BRESULT Write(const ::BRUTUS::seq_octet &pv,
					::CORBA::ULong_out pcbWritten);

	virtual ::BRUTUS::BRESULT GetSize(::CORBA::ULongLong_out Size);

	virtual ::BRUTUS::BRESULT QueryInterface(const char *iid,
						 ::BRUTUS::IUnknown_out ppvObject);

	virtual void Destroy(::CORBA::ULong InstanceID);

private:
	// Skeleton constructor
	BRUTUS_IStream_i(void)
	{ };

	virtual ~BRUTUS_IStream_i(void)
	{
		try {
			istream_->Release();
			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};


	LPSTREAM istream_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;

	ACE_RW_Mutex mutex_;
};


#endif /* __ISTREAMS_IMPL_H_  */
