/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef __ITABLEDATAS_IMPL_H_
#define __ITABLEDATAS_IMPL_H_

#include "ITableDataS.h"
#include "utils/macros.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapiutil.h>

#include "Brutus_Loader_Impl_Export.h"

class Brutus_Loader_Impl_Export BRUTUS_ITableData_i : public virtual POA_BRUTUS::ITableData,
						      public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_ITableData_i(LPTABLEDATA TableData,
			    LPMAPISESSION MAPISession,
			    ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BRESULT HrGetView(const ::BRUTUS::SSortOrderSet & lpSSortOrderSet,
					    ::BRUTUS::IMAPITable_out lppMAPITable);

	virtual ::BRUTUS::BRESULT HrModifyRow(const ::BRUTUS::SRow & lpSRow);

	virtual ::BRUTUS::BRESULT HrDeleteRow(const ::BRUTUS::SPropValue & lpSPropValue);

	virtual ::BRUTUS::BRESULT HrQueryRow(const ::BRUTUS::SPropValue & lpSPropValue,
					     ::BRUTUS::SRow_out lppSRow,
					     ::CORBA::ULong & lpuliRow);

	virtual ::BRUTUS::BRESULT HrEnumRow(::CORBA::ULong ulRowNumber,
					    ::BRUTUS::SRow_out lppSRow);

	virtual ::BRUTUS::BRESULT HrNotify(::BRUTUS::BDEFINE ulFlags,
					   const ::BRUTUS::seq_SPropValue & lpSPropValue);

	virtual ::BRUTUS::BRESULT HrInsertRow(::CORBA::ULong uliRow,
					      const ::BRUTUS::SRow & lpSRow);

	virtual ::BRUTUS::BRESULT HrModifyRows(::BRUTUS::BDEFINE ulFlags,
					       const ::BRUTUS::SRowSet & lpSRowSet);

	virtual ::BRUTUS::BRESULT HrDeleteRows(::BRUTUS::BDEFINE ulFlags,
					       const ::BRUTUS::SRowSet & lprowsetToDelete,
					       ::CORBA::ULong_out cRowsDeleted);

	virtual ::BRUTUS::BRESULT QueryInterface(const char *iid,
						 ::BRUTUS::IUnknown_out ppvObject);

	virtual void Destroy(::CORBA::ULong InstanceID);

private:
	BRUTUS_ITableData_i(void)
	{ };

	virtual ~BRUTUS_ITableData_i(void)
	{
		try {
			table_data_->Release();
			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};

	LPTABLEDATA table_data_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;

	ACE_RW_Mutex mutex_;
};


#endif /* __ITABLEDATAS_IMPL_H_  */
