/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008 OMC Denmark ApS.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU Affero General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Affero General Public License for more details.
 *
 *  You should have received a copy of the GNU Affero General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#if _MSC_VER > 1000
#pragma once
#endif

#ifndef __ITNEFS_IMPL_H_
#define __ITNEFS_IMPL_H_

#include <vector>

#include "ITnefS.h"
#include "utils/macros.h"

#define MAPIGUID_H // do not include mapiguid.h
#include <mapix.h>
#include <tnef.h>

// to hold pointers and interfaces that must be valid until
// ITnef::Finish() has been called
struct MemResource {
	void *mem; // blob
	bool com_obj; // COM object?
};

#if !defined (ACE_LACKS_PRAGMA_ONCE)
#pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "Brutus_Loader_Impl_Export.h"

class Brutus_Loader_Impl_Export BRUTUS_ITnef_i : public virtual POA_BRUTUS::ITnef,
						 public virtual ::PortableServer::RefCountServantBase
{
public:
	BRUTUS_ITnef_i(LPITNEF Tnef,
		       LPMAPISESSION MAPISession,
		       ::PortableServer::POA_ptr Poa);

	virtual ::BRUTUS::BRESULT AddProps(::BRUTUS::BDEFINE ulFlags,
					   ::CORBA::ULong ulElemID,
					   const ::BRUTUS::seq_octet & lpvData,
					   ::BRUTUS::IStream_ptr stream,
					   const ::BRUTUS::SPropTagArray & lpPropList);

	virtual ::BRUTUS::BRESULT ExtractProps(::BRUTUS::BDEFINE ulFlags,
					       const ::BRUTUS::SPropTagArray & lpPropList,
					       ::BRUTUS::STnefProblemArray_out lpProblems);

	virtual ::BRUTUS::BRESULT Finish(::BRUTUS::BDEFINE ulFlags,
					 ::CORBA::UShort_out lpKey,
					 ::BRUTUS::STnefProblemArray_out lpProblems);

	virtual ::BRUTUS::BRESULT OpenTaggedBody(::BRUTUS::IMessage_ptr lpMessage,
						 ::BRUTUS::BDEFINE ulFlags,
						 ::BRUTUS::IStream_out lppStream);

	virtual ::BRUTUS::BRESULT SetProps(::BRUTUS::BDEFINE ulFlags,
					   ::CORBA::ULong ulElemID,
					   const ::BRUTUS::SPropValue & lpProps);

	virtual ::BRUTUS::BRESULT EncodeRecips(::BRUTUS::BDEFINE ulFlags,
					       ::BRUTUS::IMAPITable_ptr lpRecipientTable);

	virtual ::BRUTUS::BRESULT FinishComponent(::BRUTUS::BDEFINE ulFlags,
						  ::CORBA::ULong ulComponentID,
						  const ::BRUTUS::SPropTagArray & lpCustomPropList,
						  const ::BRUTUS::SPropValue & lpCustomProps,
						  const ::BRUTUS::SPropTagArray & lpPropList,
						  ::BRUTUS::STnefProblemArray_out lpProblems);

	virtual ::BRUTUS::BRESULT QueryInterface(const char *iid,
						 ::BRUTUS::IUnknown_out ppvObject);

	virtual void Destroy(::CORBA::ULong InstanceID);

private:
	// Skeleton constructor
	BRUTUS_ITnef_i(void)
	{ };


	virtual ~BRUTUS_ITnef_i(void)
	{
		try {
			i_tnef_->Release();
			for (unsigned long n=0; n<mems.size(); n++) {
				if (!mems[n]->com_obj) {
					MAPIFreeBuffer(mems[n]->mem);
				} else {
					((LPUNKNOWN)(mems[n]->mem))->Release();
				}
				delete mems[n];
			}
			mems.clear();

			mapi_session_->Release();
		}
		catch (...) {
			BRUTUS_LOG_ERR("Exception caught");
		}
	};


	LPITNEF i_tnef_;
	LPMAPISESSION mapi_session_;
	::PortableServer::POA_var poa_;

	// vector of pointers to free when finish() is called
	std::vector<struct MemResource*> mems;

	ACE_RW_Mutex mutex_;
};


#endif /* __ITNEFS_IMPL_H_  */
